/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

/* Special open for the mapper.  Opens port 1 and enables raw sends
   and receives.

   Returns GM_SUCCESS on success, errno on failure */
GM_ENTRY_POINT gm_status_t
_gm_mapper_open (gm_port_t **port, unsigned int unit,
		 enum gm_api_version gm_api_version)
{
  gm_status_t status;

  status = _gm_open_common (port, unit, GM_MAPPER_PORT_ID, "mapper",
			    gm_api_version);
  if (status != GM_SUCCESS)
    goto abort_with_nothing;

  if (_gm_enable_raw_receives(*port) != GM_SUCCESS)
    goto abort_with_open;

  return GM_SUCCESS;
  
abort_with_open:
  gm_close (*port);
abort_with_nothing:
  return status;
}
