/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#endif

#define GM_DEBUG_GET_ROUTE 0

#if GM_DEBUG_GET_ROUTE
#undef GM_LOCALLY_ENABLE_CALL_TRACE
#define GM_LOCALLY_ENABLE_CALL_TRACE 1
#endif

GM_ENTRY_POINT gm_status_t
_gm_get_route (gm_port_t *p, unsigned int target_node_id,
	       char *route, unsigned int *len)
{
#if GM_KERNEL
  gm_port_state_t *ps = p->kernel_port_state;
  gm_instance_state_t *is = ps->instance;
  gm_u8_t length;

  GM_CALLED ();
  
  if (target_node_id > is->max_node_id
      || *len > GM_MAX_NETWORK_DIAMETER)
    {
      GM_RETURN_STATUS (GM_INVALID_PARAMETER);
    }
  if (!is->lanai.running)
    {
      GM_PRINT (GM_PRINT_LEVEL >= 4, ("oops: lanai.running false\n"));
      GM_RETURN_STATUS (GM_UNATTACHED);
    }

  if (*len < GM_MAX_NETWORK_DIAMETER)
    {
      GM_RETURN_STATUS (GM_INPUT_BUFFER_TOO_SMALL);
    }

  GM_PRINT (GM_DEBUG_GET_ROUTE, ("reading length\n"));
  gm_assert (len);
  _GM_PRINT (GM_DEBUG_GET_ROUTE, ("len = %p\n", len));
  *len
    = length
    = gm_read_lanai_global_u8 (is, connection[target_node_id].route_len);
  _GM_PRINT (GM_DEBUG_GET_ROUTE, ("length = %u\n", length));
		 
  if (gm_read_lanai_global_u8 (is, connection[target_node_id].has_route) != 0
      && length)
    {
      char tmp_route[GM_MAX_NETWORK_DIAMETER];

      /* copy the end-aligned route buffer to the host. */

      GM_PRINT (GM_DEBUG_GET_ROUTE, ("reading route from lanai"));
      gm_assert (sizeof (((gm_lanai_globals_t *) 0)
			   ->connection[target_node_id].route)
		   == sizeof (tmp_route));
      gm_read_lanai_global_byte_array (is, connection[target_node_id].route,
				       tmp_route);

      /* copy the end-aligned route to the start of the output buffer */

      GM_PRINT (GM_DEBUG_GET_ROUTE, ("copying route to user buffer"));
      gm_assert (route);
      GM_PRINT
	(GM_DEBUG_GET_ROUTE, ("calling gm_bcopy (%p, %p, %u)\n",
			      tmp_route[GM_MAX_NETWORK_DIAMETER - length],
			      route, length));
      gm_bcopy (&tmp_route[GM_MAX_NETWORK_DIAMETER - length], route, length);
    }

  GM_PRINT (GM_DEBUG_GET_ROUTE,
		 ("_gm_get_route() got route to node %d of length %d =\n",
		  (int) target_node_id, (int) length));
  if (GM_DEBUG_GET_ROUTE)
    {
      while (length--)
	{
	  GM_PRINT (GM_DEBUG_GET_ROUTE,
			 ("     %02x\n", route[length] & 0xff));
	}
    }

  GM_RETURN_STATUS (GM_SUCCESS);

#else
  gm_route_info_t ri;
  gm_status_t status;

  GM_CALLED ();
  
  ri.length = (gm_u8_t) *len;
  ri.target_node_id = target_node_id;

  status = _gm_user_ioctl (p, GM_GET_ROUTE, &ri, sizeof (ri));
  if (status != GM_SUCCESS)
    {
      GM_RETURN_STATUS (status);
    }
  
  /* Copy result into user buffers. */
  *len = ri.length;
  gm_bcopy (ri.route, route, *len);
  GM_RETURN_STATUS (GM_SUCCESS);
#endif
}
