/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#endif

GM_ENTRY_POINT
gm_status_t
_gm_get_page_hash_cache_size(gm_port_t *port, unsigned int *cache_size)
{
#if GM_KERNEL
  unsigned int read_cache_size;

  gm_instance_state_t *is = port->kernel_port_state->instance;
  if (!cache_size)
    return(GM_FAILURE);

  read_cache_size
    = gm_read_lanai_global_u32 (is, page_hash.cache.max_index);

  return gm_copyout (port->kernel_port_state,
             &read_cache_size, cache_size,
             sizeof (unsigned int));

#else
  return _gm_user_ioctl (port, GM_GET_PAGE_HASH_CACHE_SIZE, cache_size, 
		sizeof (unsigned int));
#endif
}
