/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1999, 2000 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_debug.h"
#endif

/* This is a simple implementation, we don't care if another port
   is being closed at the same time we're copyit out. When port
   opens and closes are stable, the array will be stable */


GM_ENTRY_POINT gm_status_t
_gm_get_opener_pids (gm_port_t * port, gm_pid_t *pid)
{
#if GM_KERNEL
	gm_instance_state_t *is;
	gm_port_state_t *ps;

	if (!port)
		return GM_FAILURE;

	ps = port->kernel_port_state;

	if (!ps)
		return GM_FAILURE;
	
	is = ps->instance;

	if (!is)
		return GM_FAILURE;

	return gm_copyout(ps, is->opener_pids, pid,
                      (GM_NUM_PORTS * sizeof(gm_pid_t)));
#else
	gm_status_t status = GM_SUCCESS;

	status = _gm_user_ioctl(port, GM_GET_OPENER_PIDS, pid,
							(GM_NUM_PORTS * sizeof(gm_pid_t)));
	return status;
#endif
}

/*
  This comment holds special emacs settings for this file.

  Local Variables:
  tab-width:4
  c-file-style:"bsd"
  End:
*/
