/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997, 1998, 1999 by Myricom, Inc.                 *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_compiler.h"
#include "gm_debug.h"
#include "gm_enable_security.h"
#include "gm_internal.h"

#define GM_DEBUG_GET_GLOBALS_BY_REQUEST 0

#if GM_DEBUG_GET_GLOBALS_BY_REQUEST
#undef GM_LOCALLY_ENABLE_CALL_TRACE
#define GM_LOCALLY_ENABLE_CALL_TRACE 1
#endif

GM_ENTRY_POINT
gm_status_t
_gm_get_globals_by_request (gm_port_t * port, gm_u8_t *ptr, unsigned int off,
			    gm_size_t length)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;
  gm_size_t len;
  GM_PARAMETER_MAY_BE_UNUSED (ptr);

  GM_CALLED_WITH_ARGS (("%p,%p,%d,%d", port, ptr, off, length));

  if (GM_ENABLE_SECURITY && !ps->privileged)
    {
      GM_RETURN_STATUS (GM_PERMISSION_DENIED);
    }
  
  len = sizeof(struct gm_lanai_globals) + 
    (ps->instance->max_node_id + 1) * sizeof(struct gm_connection);


  if (length > len)
    {
      length = len;
    }
  if ((off + length) > len)
    {
      length = len-off;
    }
  
  {
    /* The GLOBALS scratch var and cast are required to prevent
       compiler warnings with gcc. */
    void *globals;
    globals = (void *) is->lanai.globals;

    GM_RETURN_STATUS (gm_copyout (ps, ((char *)globals)+off, (void *) ptr,
				  length));
  }

#else
  {
    gm_globals_request_t request;
    request.len = GM_STATIC_CAST (gm_u32_t, length);
    request.offset = GM_STATIC_CAST (gm_u32_t, off);
    GM_PARAMETER_MAY_BE_UNUSED (ptr);
    
    GM_CALLED_WITH_ARGS (("%p,%p,%d,%ld", port, ptr, off, length));

    gm_assert (port);
    GM_RETURN_STATUS (_gm_user_ioctl (port, GM_GET_GLOBALS_BY_REQUEST, 
				      &request, sizeof(gm_globals_request_t)));
  }
#endif
}

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  End:
*/
