#include "gm_internal.h"

#ifdef STDC_HEADERS
#include <stdio.h>
#endif

GM_ENTRY_POINT void
_gm_dump_receive_queue (gm_port_t *port)
{
  unsigned int i;

  gm_always_assert (sizeof (gm_recv_event_t) == sizeof (gm_recv_t));
  gm_always_assert (sizeof (gm_recv_event_t) == sizeof (gm_sent_t));
  gm_always_assert (sizeof (gm_recv_event_t) == sizeof (gm_failed_send_event_t));
  gm_always_assert (sizeof (gm_recv_event_t) == sizeof (gm_directed_send_notification_t));
  gm_always_assert (sizeof (gm_recv_event_t) == sizeof (gm_flushed_alarm_t));

  printf ("(Empty slots are not printed.)\n");
  for (i=0; i<GM_NUM_RECV_QUEUE_SLOTS; i++)
    {
      volatile struct gm_recv_queue_slot *s;
      enum gm_recv_event_type type;
      
      s = &port->recv_queue_start[i];
      type = (enum gm_recv_event_type) gm_ntoh_u8 (s->event.recv.type);

      if (type == GM_NO_RECV_EVENT)
	continue;
      
      printf ("0x%x: %s\n", i, _gm_recv_event_name (type));
    }
}
