/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1998, 1999, 2000 by Myricom, Inc.			 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_internal.h"

#if defined STDC_HEADERS && !GM_KERNEL
#  include <stdlib.h>
#  include <stdio.h>
#endif
#if GM_KERNEL
#  include "gm_debug.h"
#endif


GM_ENTRY_POINT void
_gm_assertion_failed (const char *assertion, int line, const char *file)
{
#if GM_KERNEL

  GM_PANIC (("%s:%d: failed assertion: \"%s\".\n", file, line, assertion));

  /************
   * user-mode version
   ************/

#else /* user-mode */
  printf ("%s:%d: failed assertion: \"%s\".\n", file, line, assertion);

  /* Print process ID of failed process, if possible */

#if defined SIGSTOP
  printf ("Stopping process %ld.\n", (unsigned long) gm_getpid ());
  raise (SIGSTOP);
#endif

  abort ();

#endif /* user mode */
}

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
