/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _GM_page_table_h_
#define _GM_page_table_h_

#define GM_DEBUG_PAGE_HASH 0

#include "gm.h"
#include "gm_debug.h"
#include "gm_enable_galvantech_workaround.h"

#if GM_MCP
void gm_init_page_table (void);
#define flush_page_hash_cache gm_init_page_table
gm_dp_t get_uncached_dma_page_entry (gm_up_t page_port);
#endif /* GM_MCP */

extern const gm_u32_t gm_crc_table[];

#define GM_DEBUG_HASH 0

static gm_inline
unsigned
GM_HASH_PAGE_PORT (gm_up_t page_port)
{
  gm_u32_t c;		/* accumulated crc32 */

#if GM_BUILDING_FIRMWARE
  if (GM_DEBUG_HASH)
    {
      gm_printf ("GM_HASH_PAGE_PORT (0x%qx) called\n", (gm_u64_t) page_port);
    }
#endif

  c = (gm_u32_t) page_port;
  c = (c<<8) ^ gm_crc_table[(c>>24) & 0xff];
  c = (c<<8) ^ gm_crc_table[(c>>24) & 0xff];
  c = (c<<8) ^ gm_crc_table[(c>>24) & 0xff];
  c = (c<<8) ^ gm_crc_table[(c>>24) & 0xff];

#if GM_BUILDING_FIRMWARE
  if (GM_DEBUG_HASH)
    {
      gm_printf ("page_port 0x%qx hashes to 0x%x\n",
          (gm_u64_t) page_port, (unsigned int) c);
    }
#else
  GM_PRINT (GM_DEBUG_HASH,
         ("page_port 0x%lx hashes to 0x%x\n",
          (unsigned long) page_port, (unsigned int) c));
#endif

  return c;
}

#if GM_ENABLE_GALVANTECH_WORKAROUND
static gm_inline
gm_u32_t
gm_galvantech_PTE_checksum (gm_pte_t *_e)
{
  gm_u32_t accum;
  gm_u32_t *iptr = (gm_u32_t *)_e;
  gm_u32_t i0,i1,i2,i3;

  i0 = gm_ntohl(iptr[0]);
  i1 = gm_ntohl(iptr[1]);
  i2 = gm_ntohl(iptr[2]);
  accum = i0+i1;
  i3 = gm_ntohl(iptr[3]);
  accum += i2;
  accum += i3;
  return(accum);
}
#endif /* GALVANTECH */

void gm_fill_pte_from_host (gm_cached_pte_t *entry, unsigned int index);

#endif /* _GM_page_table_h_ */
