#ifndef gm_mdebug_h
#define gm_mdebug_h

#include "gm_config.h"		/* find out if to debug malloc */
#include "gm_debug_malloc.h"

#if GM_DEBUG_MALLOC

#if GM_KERNEL_MALLOC_ALIGNS_PAGES
#error GM_DEBUG_MALLOC & GM_KERNEL_MALLOC_ALIGNS_PAGES are incompatible
#endif

struct gm_mdebug
{
  struct gm_mdebug *next;
  void *free_function;	/* expected free function (0 if don't care) */
  void *alloc_caller;
  void *__pad;
};

extern struct gm_mdebug *gm_mdebug_root;

void _gm_mdebug_remove_client_ptr (void *ptr, void *free_func, void *caller);
void gm_malloc_residual (void);

#if defined(__GNUC__)
#define GET_CALLER_ADDR() __builtin_return_address (0)
#else
#define GET_CALLER_ADDR() 0
#endif

#endif /* GM_DEBUG_MALLOC */

/****************
 * Macros
 ****************/

/* Convert from client length to internal length, and vice versa. */

#if GM_DEBUG_MALLOC
#define GM_MDEBUG_INTERNAL_LEN(len) ((len) + sizeof (struct gm_mdebug))
#define GM_MDEBUG_CLIENT_LEN(len) ((len) - sizeof (struct gm_mdebug))
#else
#define GM_MDEBUG_INTERNAL_LEN(len) (len)
#define GM_MDEBUG_CLIENT_LEN(len) (len)
#endif

/* Convert from client ptr to internal ptr, and vice versa. */

#if GM_DEBUG_MALLOC
#define GM_MDEBUG_CLIENT_PTR(addr)					\
((void *) ((char*) (addr) + sizeof (struct gm_mdebug)))
#define GM_MDEBUG_INTERNAL_PTR(addr)					\
((struct gm_mdebug *) ((char*) (addr) - sizeof (struct gm_mdebug)))
#else
#define GM_MDEBUG_INTERNAL_PTR(ptr) ((void *)(ptr))
#define GM_MDEBUG_CLIENT_PTR(ptr) ((void *)(ptr))
#endif

/* Add/remove client ptr to/from list of allocations. */

#if GM_DEBUG_MALLOC
#define GM_MDEBUG_RECORD_CLIENT_PTR(ptr,free) do {			\
  GM_MDEBUG_INTERNAL_PTR (ptr)->next = gm_mdebug_root;			\
  GM_MDEBUG_INTERNAL_PTR (ptr)->free_function = free;			\
  GM_MDEBUG_INTERNAL_PTR (ptr)->alloc_caller = GET_CALLER_ADDR ();	\
  gm_mdebug_root = GM_MDEBUG_INTERNAL_PTR (ptr);			\
} while (0)
#define GM_MDEBUG_REMOVE_CLIENT_PTR(ptr,free) do {			\
  _gm_mdebug_remove_client_ptr (ptr, free, GET_CALLER_ADDR());		\
} while (0)
#else
#define GM_MDEBUG_RECORD_CLIENT_PTR(ptr,free)
#define GM_MDEBUG_REMOVE_CLIENT_PTR(ptr,free)
#endif

#endif				/* gm_mdebug_h */
