/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#ifndef _gm_error_counters_h_
#define _gm_error_counters_h_

/* This file simply lists all of the error counters.  It is used any
   place one needs the list.  */

#if GM_ERROR_CNT
#error You must not define GM_ERROR_CNT before including this file.
#endif

/* The following must be in ASCIIbetical order. */

#define GM_ERROR_COUNTERS						\
     GM_ERROR_CNT (bad_header_cnt, "")					\
     GM_ERROR_CNT (bad_length_cnt, "")					\
     GM_ERROR_CNT (bad_type_cnt, "")					\
     GM_ERROR_CNT (badcrc_cnt, "")					\
     GM_ERROR_CNT (badroute_cnt, "")					\
     GM_ERROR_CNT (bogus_header_cnt, "")				\
     GM_ERROR_CNT (drop_cnt, "")					\
     GM_ERROR_CNT (handle_connection_reset_request_cnt, "")		\
     GM_ERROR_CNT (misrouted_cnt, "")					\
     GM_ERROR_CNT (nack_cnt, "")					\
     GM_ERROR_CNT (nack_down_cnt, "")					\
     GM_ERROR_CNT (nack_ignore_close_connection_cnt, "")		\
     GM_ERROR_CNT (nack_ignore_open_connection_cnt, "")			\
     GM_ERROR_CNT (nack_ignored_cnt, "")				\
     GM_ERROR_CNT (nack_normal_cnt, "number of normal NACKs processed") \
     GM_ERROR_CNT (nack_receive_close_connection_cnt, "")		\
     GM_ERROR_CNT (nack_receive_open_connection_cnt, "")		\
     GM_ERROR_CNT (nack_received_cnt, "")				\
     GM_ERROR_CNT (nack_reject_cnt, "")					\
     GM_ERROR_CNT (nack_send_close_connection_cnt, "")			\
     GM_ERROR_CNT (nack_send_nothing1_cnt, "")				\
     GM_ERROR_CNT (nack_send_nothing2_cnt, "")				\
     GM_ERROR_CNT (nack_send_open_connection_cnt, "")			\
     GM_ERROR_CNT (no_match_for_datagram_recv_cnt, "")			\
     GM_ERROR_CNT (no_match_for_ether_recv_cnt, "")			\
     GM_ERROR_CNT (no_match_for_reliable_recv_cnt, "")			\
     GM_ERROR_CNT (no_match_for_raw_recv_cnt, "")			\
     GM_ERROR_CNT (out_of_sequence_cnt, "")				\
     GM_ERROR_CNT (resend_cnt, "")					\
     GM_ERROR_CNT (short_mapper_config_packet_cnt, "")			\
     GM_ERROR_CNT (short_mapper_packet_cnt, "")				\
     GM_ERROR_CNT (short_mapper_scout_packet_cnt, "")			\
     GM_ERROR_CNT (short_packet_cnt, "")				\
     GM_ERROR_CNT (zero_len_cnt, "")

/* define GM_NUM_ERROR_COUNTERS */

#define GM_ERROR_CNT(name, description) _gm_ ## name,
enum
{
  GM_ERROR_COUNTERS GM_NUM_ERROR_COUNTERS
};
#undef GM_ERROR_CNT

#endif /* _gm_error_counters_h_ */

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  End:
*/
