/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

/* This file includes support for packet counters, which slow down the
   critical path of the firmware. */

#ifndef _gm_enable_packet_counters_h_
#define _gm_enable_packet_counters_h_

/* please leave this on for any source release to customers - it helps debugging */
#define GM_ENABLE_PACKET_COUNTERS 1

/* Handy related macros */

#if GM_ENABLE_PACKET_COUNTERS
#define GM_INCR_PACKET_CNT(c) (++(c))
#define GM_DECR_PACKET_CNT(c) (--(c))
#else
#define GM_INCR_PACKET_CNT(c)
#define GM_DECR_PACKET_CNT(c)
#endif

#endif /* _gm_enable_packet_counters_h_ */

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  End:
*/
