/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_debug_h_
#define _gm_debug_h_

/* grok the architecture */

#include "gm_config.h"
#include "gm_cpp.h"
#include "gm.h"

#if GM_BUILDING_FIRMWARE
/*#include <stdio.h>*/
#endif

/****************************************************************
 * globals
 ****************************************************************/

extern int gm_debug_printing;

/***********************************************************************
 * macros and other defines to support debugging
 ***********************************************************************/

/* GM_STATIC
 *
 * In some (all?) OS's, the kernel debugging tools can't "see" even the
 * names of functions that are declared 'static'.  It's useful to have
 * those functions be static if we are not debugging, but when debugging,
 * it's more important to have them visible in a crash dump.
 */

#if GM_DEBUG
# define GM_STATIC
#else   /* ! GM_DEBUG */
# define GM_STATIC static
#endif  /* ! GM_DEBUG */


/***********************************************************************
 * printing
 ***********************************************************************/

/* gm_printf_p: print message if debugging, unless running on LANai.
   Also prints file, line, and function if possible. */

#if GM_MCP && GM_PRINT_LEVEL >= 10 && defined __GNUC__
#define gm_printf_p(args...) gm_printf (args)
#elif GM_MCP && GM_PRINT_LEVEL < 10 && defined __GNUC__
#define gm_printf_p(args...)
#elif !GM_MCP && GM_PRINT_LEVEL >=10 && defined __GNUC__
#define gm_printf_p(args) do						\
{									\
  if (gm_debug_printing)						\
    {									\
      gm_printf (__GM_WHERE__":");					\
      gm_printf (args);							\
    }									\
} while (0)
#elif !GM_MCP && !defined __GNUC__
#define gm_printf_p(args) printf (args)
#elif !GM_MCP && defined __GNUC__
#define gm_printf_p(args...) printf (args)
#else
#error Do not know how to gm_printf_p()
#endif

/***********************************************************************
 * flashing the LED
 ***********************************************************************/

#if GM_MCP
void gm_morse_async (char *s);
void gm_morse_sync (char *s);
#endif /* GM_MCP */

/***********************************************************************
 * assertions
 ***********************************************************************/

#define _GM_PRINT_PREFIX __GM_WHERE__ "():"

#if GM_KERNEL
#  define GM_PRINT_PREFIX _GM_PRINT_PREFIX "kernel:\n"
#elif GM_BUILDING_FIRMWARE
#  define GM_PRINT_PREFIX _GM_PRINT_PREFIX "firmware:\n"
#else
#  define GM_PRINT_PREFIX _GM_PRINT_PREFIX "userland:\n"
#endif

/****************
 * GM_ARCH_PRINT, INFO, PANIC, NOTE, WARN definitions
 ****************/

#if !GM_KERNEL
#define GM_ARCH_INFO(args) gm_printf args
#define GM_ARCH_NOTE(args) gm_printf args
#define GM_ARCH_PANIC(args) gm_printf args
#define GM_ARCH_PRINT(args) gm_printf args
#define GM_ARCH_WARN(args) gm_printf args
#else  /* GM_KERNEL */
#include "gm_arch.h"
#endif /* GM_KERNEL */

/****************
 * Print ontinuation macros
 ****************/

/* Use these to continue a GM_INFO, GM_NOTE, etc. message without extra
   labelling.  For example,
   GM_WARN  ("****************\n");
   _GM_WARN ("* example\n");
   _GM_WARN ("****************\n"); */

#define _GM_INFO(args) GM_ARCH_INFO (args)
#define _GM_NOTE(args) GM_ARCH_NOTE (args)
#define _GM_PANIC(args) GM_ARCH_PANIC (args)
#define _GM_WARN(args) GM_ARCH_WARN (args)

#if GM_DEBUG
#define _GM_PRINT(flag, args) do{if(flag){GM_ARCH_PRINT(args);}}while(0)
#else
#define _GM_PRINT(flag, args)
#endif

/****************
 * 
 ****************/

#ifndef GM_PRINT_LEVEL
#define GM_PRINT_LEVEL 0
#endif

/* NOTE: The following are macros instead of inline functions so that
   these macros can report the __FILE__ and __LINE__ of the caller via
   GM_PRINT_PREFIX. */

#if GM_DEBUG
#define GM_PRINT(flag, args)						\
do {									\
  int gm_print_flag;							\
									\
  gm_print_flag = (flag) ? 1 : 0;					\
  _GM_PRINT (gm_print_flag, (GM_PRINT_PREFIX));				\
  _GM_PRINT (gm_print_flag, args);					\
} while (0)
#else
#define GM_PRINT(flag, args)
#endif

#define GM_INFO(args) GM_ARCH_INFO (args)
  
#define GM_PANIC(args)							\
do {									\
  _GM_PANIC (("PANIC: "GM_PRINT_PREFIX));				\
  _GM_PANIC (args);							\
  gm_abort ();								\
} while (0)

#define GM_NOTE(args)							\
do {									\
  _GM_NOTE (( "NOTICE: "GM_PRINT_PREFIX));				\
  _GM_NOTE (args);							\
} while (0)

#define GM_WARN(args)							\
do {									\
  _GM_WARN (("WARNING: "GM_PRINT_PREFIX));				\
  _GM_WARN (args);							\
} while (0)

#endif /* _gm_debug_h_ */

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  End:
*/
