/*                                                                      tab:8
 *
 * "Copyright (c) 1994 The Regents of the University of California.
 * All rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Author:              Richard P. Martin
 * Version: 		1
 * Creation Date:       Thu Oct 28 10:47:28 PDT 1993
 * Filename:            ping.c ping test for HPAM library
 * History:
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <time.h>
#include "am.h"

extern int errno;

int *buf;
struct timeval begin,end,lapsed;
int size,count;
static volatile int go = 0;
static volatile int done1;

static void pong(int src, void *lva, int size, volatile int *flag)
{	
  if ( (int) flag ==0)
    gettimeofday(&begin,0);    
  else {
    if ((int) flag == (count-1) ) 
      go =1;
  }
}

static void poof(int src, volatile int *flag)
{
  (*flag)++; 
}
     
void main(int argc,char *argv[])
{
  int i;
  int iterations;
  int me,to;
  int bytes;

  double total_time,rtt,thruput;

  am_enable();

  buf = am_dma_calloc (1, 8192);
  gm_always_assert (buf);
  
  me = am_my_proc();
  to = 1;
  count = 10000;
  size = 8192;
  
  if (argc > 1) {
    size = atoi(argv[1]);
  }

  if (argc >= 2) 
    count = atoi(argv[2]);

  bytes=size*count;

  gettimeofday(&begin,0);    
    
  if (me == 0) {

    printf("Bulk througput test from %d to %d\n\n",me,to);

    for (i=0;i<count;i++){
      done1 =0;
      am_store(to, buf,buf,size,pong, (void *)i);  
    }    

    am_request_1(to,poof,(int)(&go));
    
    gettimeofday(&end,0);    

    if (begin.tv_usec > end.tv_usec) {
      end.tv_usec += 1000000;
      end.tv_sec--;
    }


    lapsed.tv_usec = end.tv_usec - begin.tv_usec;
    lapsed.tv_sec =  end.tv_sec - begin.tv_sec;
    
    total_time = (double)lapsed.tv_sec*1000000.00+(double)lapsed.tv_usec;

    thruput = bytes/total_time;
     
    printf("For size %d count %d total %.3f, = %.3f MB/s \n",
	   size,count,total_time,thruput);
  }
  else {
    while(go < 1) 
      am_poll();

    gettimeofday(&end,0);    

    if (begin.tv_usec > end.tv_usec) {
      end.tv_usec += 1000000;
      end.tv_sec--;
    }

    lapsed.tv_usec = end.tv_usec - begin.tv_usec;
    lapsed.tv_sec =  end.tv_sec - begin.tv_sec;
    
    total_time = (double)lapsed.tv_sec*1000000.00+(double)lapsed.tv_usec;
      
    bytes = bytes-size; /* minus one packet */

    thruput = bytes/total_time;
    printf("For size %d count %d total %.3f, = %.3f MB/s \n",
	   size,count,total_time,thruput);

  }
  printf("done!\n");
  fflush(stdout);
  am_disable();
}

