/*                                                                      tab:8
 *
 * "Copyright (c) 1994 The Regents of the University of California.
 * All rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Author:              Richard P. Martin
 * Version: 		1
 * Creation Date:       Thu Oct 28 10:47:28 PDT 1993
 * Filename:            ping.c ping test for HPAM library
 * History:
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#if GM_OS_SOLARIS
#include <sys/systeminfo.h> 
#endif
#include "am.h"

extern int errno;

volatile unsigned int in_seq = 0;
volatile unsigned int out_seq = 0;

static void poof1 (int src, volatile int *flag)
{
  (*flag)++;
}
     
static void poof2 (int src, volatile int *flag, int s1)
{
  (*flag)++;
  gm_always_assert (s1 == in_seq++);
}
     
static void poof3 (int src, volatile int *flag, int s1, int s2)
{
  (*flag)++;
  gm_always_assert (s1 == in_seq++);
  gm_always_assert (s2 == in_seq++);
}
     
static void poof4 (int src, volatile int *flag, int s1, int s2, int s3)
{
  (*flag)++;
  gm_always_assert (s1 == in_seq++);
  gm_always_assert (s2 == in_seq++);
  gm_always_assert (s3 == in_seq++);
}
     
static void poofdf (int src, volatile int *flag, int s1, double df)
{
  (*flag)++;
  gm_always_assert (s1 == in_seq++);
  gm_always_assert (df == in_seq++);
}
     
static void pong1 (int src, volatile int *return_flag)
{
  am_reply_1 (src, poof1, (int)return_flag);
}

static void pong2 (int src, volatile int *return_flag, int s1)
{
  am_reply_2 (src, poof2, (int)return_flag, out_seq++);
  gm_always_assert (s1 == in_seq++);
}

static void pong3 (int src, volatile int *return_flag, int s1, int s2)
{
  am_reply_3 (src, poof3, (int)return_flag, out_seq, out_seq+1);
  out_seq += 2;
  gm_always_assert (s1 == in_seq++);
  gm_always_assert (s2 == in_seq++);
}

static void pong4 (int src, volatile int *return_flag, int s1, int s2, int s3)
{
  am_reply_4 (src, poof4, (int)return_flag, out_seq, out_seq+1, out_seq+2);
  out_seq += 3;
  gm_always_assert (s1 == in_seq++);
  gm_always_assert (s2 == in_seq++);
  gm_always_assert (s3 == in_seq++);
}

static void pongdf (int src, volatile int *return_flag, int s1, double s2)
{
  am_reply_df (src, poofdf, (int)return_flag, out_seq, out_seq+1);
  out_seq += 2;
  gm_always_assert (s1 == in_seq++);
  gm_always_assert (s2 == in_seq++);
}


void main(int argc,char *argv[],char *envp[])
{
  int i;
  int iterations;
  int me,to;
  static volatile int go;
  static volatile int done1;
  struct timeval begin,end,lapsed;
  char my_name[64]={0};

  double total_time,rtt;

  fprintf(stderr,"about to call am_enable() \n");

  am_enable();  

  me = am_my_proc();

  am_barrier_init ();
  
#if GM_OS_SOLARIS
  sysinfo(SI_HOSTNAME,my_name,64);
#else
  gethostname(my_name,64);
#endif

  fprintf(stderr,"node %d running on %s\n",me,my_name);
  fprintf(stderr, "%d procs total\n", am_procs());
  
  am_barrier();
  
  to=1;
  iterations = 5000;

  if (argc > 1) {
    to = atoi(argv[1]);
  }

  if (argc >= 2 ) 
    iterations = atoi(argv[2]);

  am_barrier();
  
  if (me != to ) {

    printf("Round trip test from %d to %d\n\n",me,to);
    printf(" Timing full round trip time \n");
    fflush(stdout); 

    gettimeofday(&begin, NULL);    
    for (i=0;i<iterations;i++){
      done1 =0;
      am_request_1 (to, pong1, (int)&done1);   
      while (done1 ==0) 
	am_poll();   
    }    
    gettimeofday(&end, NULL);    

    if (begin.tv_usec > end.tv_usec) {
      end.tv_usec += 1e6;
      end.tv_sec--;
    }


    lapsed.tv_usec = end.tv_usec - begin.tv_usec;
    lapsed.tv_sec =  end.tv_sec - begin.tv_sec;
    
    total_time = (double)lapsed.tv_sec*1e6+(double)lapsed.tv_usec;

    rtt = total_time/iterations;
     
    printf("total %.3f, average full rtt = %.3f usec \n",total_time,rtt);

    am_request_1 (to,poof1, (int)&go); 
  }
  else {
    while(go < 1) {
       am_poll();
    }
  }

  am_barrier();

  if (me != to ) {

    printf("Round trip test from %d to %d\n\n",me,to);
    printf(" Timing full round trip time \n");
    fflush(stdout); 

    gettimeofday(&begin, NULL);    
    for (i=0;i<iterations;i++){
      done1 =0;
      am_request_2 (to, pong2, (int)&done1, out_seq++);   
      while (done1 ==0) 
	am_poll();   
    }    
    gettimeofday(&end, NULL);    

    if (begin.tv_usec > end.tv_usec) {
      end.tv_usec += 1e6;
      end.tv_sec--;
    }


    lapsed.tv_usec = end.tv_usec - begin.tv_usec;
    lapsed.tv_sec =  end.tv_sec - begin.tv_sec;
    
    total_time = (double)lapsed.tv_sec*1e6+(double)lapsed.tv_usec;

    rtt = total_time/iterations;
     
    printf("total %.3f, average full rtt = %.3f usec \n",total_time,rtt);

    am_request_2 (to,poof2, (int)&go, out_seq++); 
  }
  else {
    while(go < 1) {
       am_poll();
    }
  }

  am_barrier();

  if (me != to ) {

    printf("Round trip test from %d to %d\n\n",me,to);
    printf(" Timing full round trip time \n");
    fflush(stdout); 

    gettimeofday(&begin, NULL);    
    for (i=0;i<iterations;i++){
      done1 =0;
      am_request_3 (to, pong3, (int)&done1, out_seq, out_seq+1);
      out_seq += 2;
      while (done1 ==0) 
	am_poll();   
    }    
    gettimeofday(&end, NULL);    

    if (begin.tv_usec > end.tv_usec) {
      end.tv_usec += 1e6;
      end.tv_sec--;
    }


    lapsed.tv_usec = end.tv_usec - begin.tv_usec;
    lapsed.tv_sec =  end.tv_sec - begin.tv_sec;
    
    total_time = (double)lapsed.tv_sec*1e6+(double)lapsed.tv_usec;

    rtt = total_time/iterations;
     
    printf("total %.3f, average full rtt = %.3f usec \n",total_time,rtt);

    am_request_3 (to,poof3, (int)&go, out_seq, out_seq+1);
    out_seq += 2;
  }
  else {
    while(go < 1) {
       am_poll();
    }
  }

  am_barrier();

  if (me != to ) {

    printf("Round trip test from %d to %d\n\n",me,to);
    printf(" Timing full round trip time \n");
    fflush(stdout); 

    gettimeofday(&begin, NULL);    
    for (i=0;i<iterations;i++){
      done1 =0;
      am_request_4 (to, pong4, (int)&done1, out_seq, out_seq+1, out_seq+2);
      out_seq += 3;
      while (done1 ==0) 
	am_poll();   
    }    
    gettimeofday(&end, NULL);    

    if (begin.tv_usec > end.tv_usec) {
      end.tv_usec += 1e6;
      end.tv_sec--;
    }


    lapsed.tv_usec = end.tv_usec - begin.tv_usec;
    lapsed.tv_sec =  end.tv_sec - begin.tv_sec;
    
    total_time = (double)lapsed.tv_sec*1e6+(double)lapsed.tv_usec;

    rtt = total_time/iterations;
     
    printf("total %.3f, average full rtt = %.3f usec \n",total_time,rtt);

    am_request_4 (to,poof4, (int)&go, out_seq, out_seq+1, out_seq+2); 
    out_seq += 3;
  }
  else {
    while(go < 1) {
       am_poll();
    }
  }

  am_barrier();

  if (me != to ) {

    printf("Round trip test from %d to %d\n\n",me,to);
    printf(" Timing full round trip time \n");
    fflush(stdout); 

    gettimeofday(&begin, NULL);    
    for (i=0;i<iterations;i++){
      done1 =0;
      am_request_df (to, pongdf, (int)&done1, out_seq, out_seq+1);
      out_seq += 2;
      while (done1 ==0) 
	am_poll();   
    }    
    gettimeofday(&end, NULL);    

    if (begin.tv_usec > end.tv_usec) {
      end.tv_usec += 1e6;
      end.tv_sec--;
    }


    lapsed.tv_usec = end.tv_usec - begin.tv_usec;
    lapsed.tv_sec =  end.tv_sec - begin.tv_sec;
    
    total_time = (double)lapsed.tv_sec*1e6+(double)lapsed.tv_usec;

    rtt = total_time/iterations;
     
    printf("total %.3f, average full rtt = %.3f usec \n",total_time,rtt);

    am_request_df (to,poofdf, (int)&go, out_seq, out_seq+1);
    out_seq += 2;
  }
  else {
    while(go < 1) {
       am_poll();
    }
  }

  am_barrier();

  printf("done!\n");
  fflush(stdout);

  am_disable(); 
}
