/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#include "am.h"
#include <malloc.h>

struct gm_port *port = 0;
int my_proc = -1;
int num_procs = -1;

am_chainable_mesg_t *free_buffers[32];

static void 
create_free_buffers(int num, int size,
					am_chainable_mesg_t ** free)
{
	int i;
	am_chainable_mesg_t *p;

	*free = 0;
	for (i = 0; i < num; i++) {
		p = (am_chainable_mesg_t *) gm_dma_calloc(port, 1, 1 << size);
		gm_always_assert(p);
#if GM_DEBUG_BUFFERS
		gm_register_buf(&p->message, size);
#endif
		p->next = *free;
		*free = p;
	}
}

gm_u32_t port_id = 2;
gm_u32_t board_num = 0;
gm_u32_t this_node_id = 0;

void 
am_enable(void)
{
	int instance;
	am_chainable_mesg_t *tmp_free;
	gm_status_t status;

	gm_always_assert(DF_MESG_LEN <= gm_max_length_for_size(RR_MESG_SIZE));
	gm_always_assert(I4_MESG_LEN <= gm_max_length_for_size(RR_MESG_SIZE));
	gm_always_assert(STORE_TYPE_MESG_LEN <= gm_max_length_for_size(RR_MESG_SIZE));

	/* open the GM port */
	if (gm_open(&port, board_num, port_id, "GAM/GM", GM_API_VERSION_1_0) != GM_SUCCESS)
		goto abort_with_nothing;

	status = gm_get_node_id(port,&this_node_id);
	gm_always_assert(status);

	my_proc = am_from_gm_node_map(/*port->*/this_node_id);
	num_procs = gm_max_used_node_id(port);

	/* let GM manage the tokens */
	gm_free_send_tokens(port, GM_HIGH_PRIORITY, HIGH_SEND_TOKENS(port));
	gm_free_send_tokens(port, GM_LOW_PRIORITY, LOW_SEND_TOKENS(port));

	create_free_buffers(LOW_SEND_TOKENS(port),
						RR_MESG_SIZE,
						&free_buffers[RR_MESG_SIZE]);

	create_free_buffers(gm_num_receive_tokens(port) / 2, RR_MESG_SIZE, &tmp_free);
	while (tmp_free) {
		gm_provide_receive_buffer(port,
								  &tmp_free->message,
								  RR_MESG_SIZE,
								  GM_LOW_PRIORITY);
		tmp_free = tmp_free->next;
	}

	create_free_buffers(gm_num_receive_tokens(port) / 2, RR_MESG_SIZE, &tmp_free);
	while (tmp_free) {
		gm_provide_receive_buffer(port,
								  &tmp_free->message,
								  RR_MESG_SIZE,
								  GM_HIGH_PRIORITY);
		tmp_free = tmp_free->next;
	}

	am_barrier_init();
	am_barrier();

  abort_with_nothing:
}
