/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#include "am.h"
#include <malloc.h>

void handle_queued_messages(void);

int 
am_disable(void)
{
	int tok, i;

	handle_queued_messages();

	/*
	 * recover all tokens; this ensures that all sends are
	 * flushed
	 */
	tok = 0;
	do {
		_am_poll(0);
		if (gm_alloc_send_token(port, GM_HIGH_PRIORITY))
			tok++;
	} while (tok != HIGH_SEND_TOKENS(port));

	tok = 0;
	do {
		_am_poll(0);
		if (gm_alloc_send_token(port, GM_LOW_PRIORITY))
			tok++;
	} while (tok != LOW_SEND_TOKENS(port));

	/*
	 * weak sanity check to try to make sure we have not added any
	 * tokens to the pool
	 */
	for (i = 0; i < 10000; i++)
		_am_poll(1);
	gm_always_assert(!gm_alloc_send_token(port, GM_LOW_PRIORITY));
	gm_always_assert(!gm_alloc_send_token(port, GM_HIGH_PRIORITY));

	gm_close(port);
	free(port);
	return 0;
}
