/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gam_h_
#define _gam_h_

#ifdef WIN32
#ifdef GAM_BUILDING_DLL
#define GAM_ENTRY_POINT __declspec(dllexport)
#else
#define GAM_ENTRY_POINT __declspec(dllimport)
#endif
#else
#define GAM_ENTRY_POINT
#endif

#include "gm.h"

#ifdef STDC_HEADERS
#include <stdio.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifndef WIN32
typedef gm_s32_t LONG;
typedef gm_s16_t SHORT;
typedef gm_s8_t CHAR;
typedef unsigned int ULONG;
typedef gm_u16_t USHORT;
typedef gm_u8_t UCHAR;
typedef unsigned int BOOLEAN;
#define DWORD long long
#define _cdecl int
#define TRUE 1
#define FALSE 0
#endif

typedef unsigned int vnn_t;
typedef void (*handler_t) ();

#define MAX_NODES 256

/*
 * the ratio between these should be something other than 1:1
 * if it is expected that not every request is replied to
 */
#define LOW_SEND_TOKENS(x) (gm_num_send_tokens(x)/2)
#define HIGH_SEND_TOKENS(x) (gm_num_send_tokens(x)/2)

#ifndef GAM_PRINT_LEVEL
#define GAM_PRINT_LEVEL 10
#endif

#define GAM_PRINT(level, args)						\
do {									\
  if (level<=GAM_PRINT_LEVEL) {	   				        \
    printf ("gam: ");							\
    printf args;							\
  }									\
} while (0)

extern struct gm_port *port;
extern int num_procs;
extern int my_proc;

extern gm_u32_t port_id;
extern gm_u32_t board_num;
extern gm_u32_t this_node_id;

/*
 * if this changes, be sure to change msg_type_names
 * in poll.c
 */
enum am_message_type {
	NO_RECV_TYPE = 0,
	REQ0_TYPE,
	REQ1_TYPE,
	REQ2_TYPE,
	REQ3_TYPE,
	REQ4_TYPE,					/* 5 */
	REQDF_TYPE,
	STORE_TYPE,
	STORE_DONE_TYPE,
	STORE_ASYNC_TYPE,
	GET_TYPE,					/* 10 */
	REP0_TYPE,
	REP1_TYPE,
	REP2_TYPE,
	REP3_TYPE,
	REP4_TYPE,					/* 15 */
	REPDF_TYPE,
	GET_REP_TYPE,
};

typedef union am_message {
	/*
	 * NOTE: type and handler must be the first two
	 * fields of any message
	 */

	struct i4_message {
		enum am_message_type type;
		handler_t handler;
		int arg1;
		int arg2;
		int arg3;
		int arg4;
	} i4;

#define AM_GM_DMA_ROUNDUP(n,m) (((gm_u32_t)(m)+(gm_u32_t)(GM_DMA_GRANULARITY)-1)&~((gm_u32_t)(GM_DMA_GRANULARITY)-1))

#define I0_MESG_LEN AM_GM_DMA_ROUNDUP(unsigned int, (sizeof (struct i4_message) - 16))
#define I1_MESG_LEN AM_GM_DMA_ROUNDUP(unsigned int, (sizeof (struct i4_message) - 12))
#define I2_MESG_LEN AM_GM_DMA_ROUNDUP(unsigned int, (sizeof (struct i4_message) - 8))
#define I3_MESG_LEN AM_GM_DMA_ROUNDUP(unsigned int, (sizeof (struct i4_message) - 4))
#define I4_MESG_LEN AM_GM_DMA_ROUNDUP(unsigned int, (sizeof (struct i4_message)))

	struct df_message {
		enum am_message_type type;
		handler_t handler;
		int arg1;
		int arg2;
		double arg3;
	} df;

#define DF_MESG_LEN AM_GM_DMA_ROUNDUP(unsigned int, (sizeof (struct df_message)))

	struct store_message {
		enum am_message_type type;
		handler_t handler;
		int dest;
		void *lva;
		void *rva;
		int nbytes;
		void *handler_arg;
		handler_t endfunc;
		void *endfunc_arg;
	} store;

#define STORE_TYPE_MESG_LEN AM_GM_DMA_ROUNDUP(unsigned int, (sizeof (struct store_message)))

} am_mesg_t;

#define RR_MESG_SIZE 6

void
    am_enable(void);

static inline
int
am_procs(void)
{
	gm_assert(port);
	return num_procs;
}

static inline
int
am_my_proc(void)
{
	gm_assert(port);
	return my_proc;
}

void _am_poll(int handle);

static inline
void
_am_get_low_token(void)
{
	/*
	 * handle messages while polling
	 */
	while (1) {
		if (gm_alloc_send_token(port, GM_LOW_PRIORITY))
			return;
		_am_poll(1);
	}
}

static inline
void
_am_get_high_token(void)
{
	/*
	 * queue messages while polling
	 */
	while (1) {
		if (gm_alloc_send_token(port, GM_HIGH_PRIORITY))
			return;
		_am_poll(0);
	}
}

typedef struct am_chainable_mesg {
	struct am_chainable_mesg *next;
	unsigned int sender;
	am_mesg_t message;
} am_chainable_mesg_t;

static inline
    am_chainable_mesg_t *
am_chainable_parent(am_mesg_t * p)
{
	return (am_chainable_mesg_t *)
		((char *) p -
		 (sizeof(am_chainable_mesg_t) - sizeof(am_mesg_t)));
}

extern am_chainable_mesg_t *free_buffers[];

static inline
    am_mesg_t *
_am_get_buffer(int size)
{
	am_chainable_mesg_t *p;

	while (!free_buffers[size]) {
		_am_poll(1);
	}

	p = free_buffers[size];
	free_buffers[size] = p->next;
	return &p->message;
}

/*
 * AM -> GM node mapping - hack
 */
static inline
int
am_to_gm_node_map(int node)
{
	return node + 1;
}

/*
 * GM -> AM node mapping - hack
 */
static inline
int
am_from_gm_node_map(int node)
{
	return node - 1;
}

static inline
int
am_request_0(vnn_t dest,
			 handler_t handler)
{
	am_mesg_t *p;

	gm_assert(port);
	gm_assert(dest < num_procs);

	p = _am_get_buffer(RR_MESG_SIZE);

	p->i4.type = REQ0_TYPE;
	p->i4.handler = handler;

	_am_get_low_token();
	gm_send_to_peer(port,
					p,
					RR_MESG_SIZE,
					I0_MESG_LEN,
					GM_LOW_PRIORITY,
					am_to_gm_node_map(dest));

	return 0;
}

static inline
int
am_request_1(vnn_t dest,
			 handler_t handler,
			 int arg1)
{
	am_mesg_t *p;

	gm_assert(port);
	gm_assert(dest < num_procs);

	p = _am_get_buffer(RR_MESG_SIZE);

	p->i4.type = REQ1_TYPE;
	p->i4.handler = handler;
	p->i4.arg1 = arg1;

	_am_get_low_token();
	gm_send_to_peer(port,
					p,
					RR_MESG_SIZE,
					I1_MESG_LEN,
					GM_LOW_PRIORITY,
					am_to_gm_node_map(dest));

	return 0;
}

static inline
int
am_request_2(vnn_t dest,
			 handler_t handler,
			 int arg1,
			 int arg2)
{
	am_mesg_t *p;

	gm_assert(port);
	gm_assert(dest < num_procs);

	p = _am_get_buffer(RR_MESG_SIZE);

	p->i4.type = REQ2_TYPE;
	p->i4.handler = handler;
	p->i4.arg1 = arg1;
	p->i4.arg2 = arg2;

	_am_get_low_token();
	gm_send_to_peer(port,
					p,
					RR_MESG_SIZE,
					I2_MESG_LEN,
					GM_LOW_PRIORITY,
					am_to_gm_node_map(dest));

	return 0;
}

static inline
int
am_request_3(vnn_t dest,
			 handler_t handler,
			 int arg1,
			 int arg2,
			 int arg3)
{
	am_mesg_t *p;

	gm_assert(port);
	gm_assert(dest < num_procs);

	p = _am_get_buffer(RR_MESG_SIZE);

	p->i4.type = REQ3_TYPE;
	p->i4.handler = handler;
	p->i4.arg1 = arg1;
	p->i4.arg2 = arg2;
	p->i4.arg3 = arg3;

	_am_get_low_token();
	gm_send_to_peer(port,
					p,
					RR_MESG_SIZE,
					I3_MESG_LEN,
					GM_LOW_PRIORITY,
					am_to_gm_node_map(dest));

	return 0;
}

static inline
int
am_request_4(vnn_t dest,
			 handler_t handler,
			 int arg1,
			 int arg2,
			 int arg3,
			 int arg4)
{
	am_mesg_t *p;

	gm_assert(port);
	gm_assert(dest < num_procs);

	p = _am_get_buffer(RR_MESG_SIZE);

	p->i4.type = REQ4_TYPE;
	p->i4.handler = handler;
	p->i4.arg1 = arg1;
	p->i4.arg2 = arg2;
	p->i4.arg3 = arg3;
	p->i4.arg4 = arg4;

	_am_get_low_token();
	gm_send_to_peer(port,
					p,
					RR_MESG_SIZE,
					I4_MESG_LEN,
					GM_LOW_PRIORITY,
					am_to_gm_node_map(dest));

	return 0;
}

static inline
int
am_request_df(vnn_t dest,
			  handler_t handler,
			  int arg1,
			  int arg2,
			  double arg3)
{
	am_mesg_t *p;

	gm_assert(port);
	gm_assert(dest < num_procs);

	p = _am_get_buffer(RR_MESG_SIZE);

	p->df.type = REQDF_TYPE;
	p->df.handler = handler;
	p->df.arg1 = arg1;
	p->df.arg2 = arg2;
	p->df.arg3 = arg3;

	_am_get_low_token();
	gm_send_to_peer(port,
					p,
					RR_MESG_SIZE,
					DF_MESG_LEN,
					GM_LOW_PRIORITY,
					am_to_gm_node_map(dest));

	return 0;
}

extern am_mesg_t *_am_cur_buf;
extern int _am_cur_buf_used;

static inline
int
am_reply_0(vnn_t dest,
		   handler_t handler)
{
	gm_assert(port);
	gm_assert(!_am_cur_buf_used);
	gm_assert(dest < num_procs);

	_am_cur_buf->i4.type = REP0_TYPE;
	_am_cur_buf->i4.handler = handler;

	_am_get_high_token();
	gm_send_to_peer(port,
					_am_cur_buf,
					RR_MESG_SIZE,
					I0_MESG_LEN,
					GM_HIGH_PRIORITY,
					am_to_gm_node_map(dest));

	_am_cur_buf_used = 1;

	return 0;
}

static inline
int
am_reply_1(vnn_t dest,
		   handler_t handler,
		   int arg1)
{
	gm_assert(port);
	gm_assert(!_am_cur_buf_used);
	gm_assert(dest < num_procs);

	_am_cur_buf->i4.type = REP1_TYPE;
	_am_cur_buf->i4.handler = handler;
	_am_cur_buf->i4.arg1 = arg1;

	_am_get_high_token();
	gm_send_to_peer(port,
					_am_cur_buf,
					RR_MESG_SIZE,
					I1_MESG_LEN,
					GM_HIGH_PRIORITY,
					am_to_gm_node_map(dest));

	_am_cur_buf_used = 1;

	return 0;
}

static inline
int
am_reply_2(vnn_t dest,
		   handler_t handler,
		   int arg1,
		   int arg2)
{
	gm_assert(port);
	gm_assert(!_am_cur_buf_used);
	gm_assert(dest < num_procs);

	_am_cur_buf->i4.type = REP2_TYPE;
	_am_cur_buf->i4.handler = handler;
	_am_cur_buf->i4.arg1 = arg1;
	_am_cur_buf->i4.arg2 = arg2;

	_am_get_high_token();
	gm_send_to_peer(port,
					_am_cur_buf,
					RR_MESG_SIZE,
					I2_MESG_LEN,
					GM_HIGH_PRIORITY,
					am_to_gm_node_map(dest));

	_am_cur_buf_used = 1;

	return 0;
}

static inline
int
am_reply_3(vnn_t dest,
		   handler_t handler,
		   int arg1,
		   int arg2,
		   int arg3)
{
	gm_assert(port);
	gm_assert(!_am_cur_buf_used);
	gm_assert(dest < num_procs);

	_am_cur_buf->i4.type = REP3_TYPE;
	_am_cur_buf->i4.handler = handler;
	_am_cur_buf->i4.arg1 = arg1;
	_am_cur_buf->i4.arg2 = arg2;
	_am_cur_buf->i4.arg3 = arg3;

	_am_get_high_token();
	gm_send_to_peer(port,
					_am_cur_buf,
					RR_MESG_SIZE,
					I3_MESG_LEN,
					GM_HIGH_PRIORITY,
					am_to_gm_node_map(dest));

	_am_cur_buf_used = 1;

	return 0;
}

static inline
int
am_reply_4(vnn_t dest,
		   handler_t handler,
		   int arg1,
		   int arg2,
		   int arg3,
		   int arg4)
{
	gm_assert(port);
	gm_assert(!_am_cur_buf_used);
	gm_assert(dest < num_procs);

	_am_cur_buf->i4.type = REP4_TYPE;
	_am_cur_buf->i4.handler = handler;
	_am_cur_buf->i4.arg1 = arg1;
	_am_cur_buf->i4.arg2 = arg2;
	_am_cur_buf->i4.arg3 = arg3;
	_am_cur_buf->i4.arg4 = arg4;

	_am_get_high_token();
	gm_send_to_peer(port,
					_am_cur_buf,
					RR_MESG_SIZE,
					I4_MESG_LEN,
					GM_HIGH_PRIORITY,
					am_to_gm_node_map(dest));

	_am_cur_buf_used = 1;

	return 0;
}

static inline
int
am_reply_df(vnn_t dest,
			handler_t handler,
			int arg1,
			int arg2,
			double arg3)
{
	gm_assert(port);
	gm_assert(!_am_cur_buf_used);
	gm_assert(dest < num_procs);

	_am_cur_buf->df.type = REPDF_TYPE;
	_am_cur_buf->df.handler = handler;
	_am_cur_buf->df.arg1 = arg1;
	_am_cur_buf->df.arg2 = arg2;
	_am_cur_buf->df.arg3 = arg3;

	_am_get_high_token();
	gm_send_to_peer(port,
					_am_cur_buf,
					RR_MESG_SIZE,
					DF_MESG_LEN,
					GM_HIGH_PRIORITY,
					am_to_gm_node_map(dest));

	_am_cur_buf_used = 1;

	return 0;
}

static inline
int
am_store(vnn_t dest_vnn,
		 void *lva,
		 void *rva,
		 int nbytes,
		 handler_t request_handler,
		 void *handler_arg)
{
	am_mesg_t *p;

	gm_assert(port);
	gm_assert(dest_vnn < num_procs);

	_am_get_low_token();
	gm_directed_send(port,
					 lva,
					 rva,
					 nbytes,
					 GM_LOW_PRIORITY,
					 am_to_gm_node_map(dest_vnn),
					 port_id);

	p = _am_get_buffer(RR_MESG_SIZE);

	p->store.type = STORE_TYPE;
	p->store.handler = request_handler;
	p->store.handler_arg = handler_arg;
	p->store.rva = rva;
	p->store.nbytes = nbytes;

	_am_get_low_token();
	gm_send_to_peer(port,
					p,
					RR_MESG_SIZE,
					STORE_TYPE_MESG_LEN,
					GM_LOW_PRIORITY,
					am_to_gm_node_map(dest_vnn));

	/*
	 * when the SENT event is received, _am_poll will
	 * change the type of the message for us
	 */
	do {
		_am_poll(1);
	} while (p->store.type != STORE_DONE_TYPE);

	return 0;
}

static inline
int
am_store_async(vnn_t dest_vnn,
			   void *lva,
			   void *rva,
			   int nbytes,
			   handler_t request_handler,
			   void *handler_arg,
			   handler_t endfunc,
			   void *endfunc_arg)
{
	am_mesg_t *p;

	gm_assert(port);
	gm_assert(dest_vnn < num_procs);

	_am_get_low_token();
	gm_directed_send(port,
					 lva,
					 rva,
					 nbytes,
					 GM_LOW_PRIORITY,
					 am_to_gm_node_map(dest_vnn),
					 port_id);

	p = _am_get_buffer(RR_MESG_SIZE);

	p->store.type = STORE_ASYNC_TYPE;
	p->store.handler = request_handler;
	p->store.handler_arg = handler_arg;
	p->store.endfunc = endfunc;
	p->store.endfunc_arg = endfunc_arg;
	p->store.lva = lva;
	p->store.rva = rva;
	p->store.dest = am_to_gm_node_map(dest_vnn);

	_am_get_low_token();
	gm_send_to_peer(port,
					p,
					RR_MESG_SIZE,
					STORE_TYPE_MESG_LEN,
					GM_LOW_PRIORITY,
					am_to_gm_node_map(dest_vnn));

	return 0;
}

static inline
int
am_get(vnn_t dest_vnn,
	   void *rva,
	   void *lva,
	   int nbytes,
	   handler_t reply_handler,
	   void *handler_arg)
{
	am_mesg_t *p;

	gm_assert(port);
	gm_assert(dest_vnn < num_procs);

	p = _am_get_buffer(RR_MESG_SIZE);

	p->store.type = GET_TYPE;
	p->store.handler = reply_handler;
	p->store.handler_arg = handler_arg;
	p->store.rva = rva;
	p->store.lva = lva;
	p->store.nbytes = nbytes;

	_am_get_low_token();
	gm_send_to_peer(port,
					p,
					RR_MESG_SIZE,
					STORE_TYPE_MESG_LEN,
					GM_LOW_PRIORITY,
					am_to_gm_node_map(dest_vnn));

	return 0;
}

static inline
int
am_max_size(void)
{
	return (1 << 30);
}

int am_disable(void);

static inline
void
am_poll(void)
{
	_am_poll(1);
}

static inline
void *
am_dma_calloc(num, len)
{
	return gm_dma_calloc(port, num, len);
}

int
    am_barrier_init(void);

void
    am_barrier(void);

void
    am_wait(volatile int *flag, int value);

void
    am_poll_wait(volatile int *flag, int value);

extern struct gm_port *port;
extern int procs;
extern int my_proc;

#endif
