#ifndef ge_link_h
#define ge_link_h


#define GM_CPU_sparc

#include "gm_internal.h"

typedef struct GeLink
{
  int version;
  gm_status_t (*gm_open) (gm_port_t **p, unsigned unit,
			  unsigned port, char *port_name,
			  enum gm_api_version version);
  union gm_recv_event* (*gm_receive) (gm_port_t *p);
  void (*gm_unknown) (gm_port_t * p, union gm_recv_event *e);
  void (*gm_ethernet_send) (gm_port_t *p,
			    gm_u32_t segment_count,
			    gm_ethernet_segment_descriptor_t segment[],
			    gm_u8_t *ethernet_addr,
			    int prepend_type);
  void (*gm_ethernet_broadcast) (gm_port_t *p,
				 gm_u32_t segment_cnt,
				 gm_ethernet_segment_descriptor_t segment[],
				 int prepend_type);
  void (*gm_provide_ethernet_scatter_list) (gm_port_t *p,
					    gm_u32_t segment_cnt,
					    gm_ethernet_segment_descriptor_t
					    segment[]);
  gm_status_t (*gm_get_unique_board_id) (gm_port_t *port,
					 char unique[6]);

  void (*gm_close) (gm_port_t * p);
  void (*enableInterrupts) (gm_port_t *p);
  void (*disableInterrupts) (gm_port_t *p);
  void (*gm_ethernet_set_sent_intr_callback) (gm_port_t *p,
					      void (*callback)(void *),
					      void *context);
  void (*gm_ethernet_set_recv_intr_callback) (gm_port_t*p,
					      void (*callback) (void*, unsigned),
					      void*context);
  
}GeLink;

#endif /*ge_link_h*/
