#ifndef ge_h
#define ge_h

#define GE_MAX_BOARDS 4
#define GE_SLOP 16
#define GE_GRAIN 8
#define GE_BUFFER_SIZE (GM_ETHERNET_MTU + GE_SLOP)
#define GE_SPEED 1000*1000*1000
#define GE_NAME "myri"
#define GE_DESCRIPTION "Myricom GM SENS Driver"
#define GE_NUM_SEND_BUFFERS (GM_NUM_SEND_TOKENS * 4)
#define GE_NUM_RECEIVE_BUFFERS (GM_NUM_ETHERNET_RECV_TOKENS * 4)
#define GE_QUEUE_SIZE GE_NUM_SEND_BUFFERS + GE_NUM_RECEIVE_BUFFERS + 10
#define GE_MAX_RECEIVES_PER_INTERRUPT GM_NUM_ETHERNET_RECV_TOKENS
#define GE_MIN_FIRST_BUFFER 100
#define GE_GM_SIZEOF_GM_HEADER 2
#define GE_MIN_RECEIVE_BUFFERS 2
#define GE_MIN_GATHER_LENGTH 0
#define GE_ROUND_POINTER(p)(char*)(((((unsigned)(p)) + (GE_GRAIN - 1)) & ~(GE_GRAIN - 1)))
#define GE_ROUND_INT(p)(int)(((((unsigned)(p)) + (GE_GRAIN - 1)) & ~(GE_GRAIN - 1)))

typedef struct GeQueue
{
  int head;
  int tail;
  void*items [GE_QUEUE_SIZE + 1];
}GeQueue;

typedef struct GeDevice
{
  END_OBJ end;
  struct gm_port *port;
  UCHAR address [6];
  int muxUnit;
  int gmUnit;
  NET_POOL sendPool;
  NET_POOL receivePool;
  int numSendTokens;
  GeQueue sendQueue;
  GeQueue receiveQueue;
  M_CL_CONFIG endBlockTable;
  CL_DESC endClusterTable;
  
  M_CL_CONFIG sendBlockTable;
  CL_DESC sendClusterTable;
  M_CL_CONFIG receiveBlockTable;
  CL_DESC receiveClusterTable;
  CACHE_FUNCS cacheFunctions;
  int gmStarted;
  int provided;
  
}GeDevice;

int geFull (GeQueue*queue);
int geEmpty (GeQueue*queue);
int gePut (GeQueue*queue, void*buffer);
void*geGet (GeQueue*queue);


#endif /*ge_h*/
