/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_arch_types_h_
#define _gm_arch_types_h_

/**********************************************************************
 * This file architecture-specific types and macros needed by gm_impl.h
 **********************************************************************/

#ifndef __KERNEL__
#define __KERNEL__ 1
#endif

#include "vxWorks.h"
#include "semLib.h"

/* minimum linux include files to have the required types declared here */

/* Architecture-specific type for the "arch" field of the gm_intance_state_t
   data structure. */

#define GM_ARCH_KMALLOC_REGION 1
#define GM_ARCH_VMALLOC_REGION 2
#define GM_ARCH_GFP_REGION 3

struct gm_instance_state;

typedef struct gm_arch_dma_region
{
  struct gm_instance_state *is; /* for debugging purpose */
  void *addr; /* aligned address */
  void *addr2; /* incremented address */
  char *original_addr; /* for gm_arch_dma_region_advance */
  void *alloc_addr;
  unsigned len;
  int flags;
  unsigned char type;
  unsigned char order;
} gm_arch_dma_region_t;

#define GM_SEND_RING 4
#define GM_RECV_RING 8
#define GM_SEND_RING_MAX_INDEX (GM_SEND_RING -1)
#define GM_RECV_RING_MAX_INDEX (GM_RECV_RING -1)
#define GM_NET_COPY_THRESHOLD 400

struct gm_port;



typedef struct gm_arch_instance_info  
{
  unsigned long membase;
  struct gm_instance_state *next;
  int interrupt; /* 1 if we are currently inside the interrupt handler, 0 otherwise  */
  unsigned char irq;
  unsigned char revision;
  int pcibusno;
  int pcideviceno;
  int pcifuncno;
} gm_arch_instance_info_t;

typedef struct gm_arch_port_info
{
  /*  int mode; */
  int ref_count; /* open file descriptor + mapping count */
  
} gm_arch_port_info_t;

/************
 * GM synchronization types
 ************/

#define GM_SLEEP_WOKE 0
#define GM_SLEEP_INTERRUPTED 1

typedef struct gm_arch_sync
{
	unsigned int topline;
	SEM_ID semMutex;
	SEM_ID semSync;
	unsigned int botline;
} gm_arch_sync_t;

#define USER_LOCK_DEAD 0x6598731
#define USER_LOCK_ALIVE 0x635290

#if GM_CAN_REGISTER_MEMORY
typedef struct
{
  long vma;
  int magic;
} gm_arch_page_lock_t;
#else
typedef char gm_arch_page_lock_t;
#endif

typedef int /*minor_t*/ gm_arch_minor_t;

typedef int gm_arch_ioctl_context_t;


/************
 * Debugging output macros
 ************/

#define GM_ERR(level, type, args...)  do { \
  if ((level)<=GM_PRINT_LEVEL) printf ((type), "gm: " args); \
} while (0)


/************
 * variable and declaration to allow one binary for everyone
 ************/


#endif /* _gm_arch_types_h_ */
     
