
/* frcPciLib.c */

#include "force/h/pci/frcPciLibInclude.h"

#define pciFindDevice(a,b,c,d,e,f)  XpciFindDevice(a,b,c,d,e,f) 
#define pciDevConfig(a,b,c,d,e,f)   XpciDevConfig(a,b,c,d,e,f)

#define pciConfigInByte(a,b,c,d,e)  XpciConfigInByte(a,b,c,d,e)
#define pciConfigInWord(a,b,c,d,e)  XpciConfigInWord(a,b,c,d,e)
#define pciConfigInLong(a,b,c,d,e)  XpciConfigInLong(a,b,c,d,e)

#define pciConfigOutByte(a,b,c,d,e) XpciConfigOutByte(a,b,c,d,e)
#define pciConfigOutWord(a,b,c,d,e) XpciConfigOutWord(a,b,c,d,e)
#define pciConfigOutLong(a,b,c,d,e) XpciConfigOutLong(a,b,c,d,e)

extern STATUS frcPciFindDevice 
         ( 
         UINT32      id,     /* vendor and device ID */ 
         UINT16      index,  /* instance of the device */ 
         UINT8 *     busNum, /* bus number */
         UINT8 *     devNum, /* device number */ 
         UINT8 *     funNum  /* function number */ 
         ); 

extern STATUS frcPciDeviceInit
         (
         UINT8         busNum,   /* the selected bus                    */
         UINT8         devNum,   /* the selected device                 */
         UINT8         funNum,   /* the selected function               */
         PCI_DEV_INIT  *regs,    /* some register contents              */
         FUNCPTR       routine,  /* user defined initialisation routine */
         ULONG         par1,     /* parameter to be passed to the user routine   */
         ULONG         par2
         );

extern STATUS frcPciConfigReadByte
	 (
         UINT8    busNum,  /* the selected bus                             */
         UINT8    devNum,  /* the selected device                          */
         UINT8    funNum,  /* the selected function                        */
         UINT8    regNum,  /* the register offset in Byte,                 */
                           /* from which to be loaded                      */
         UINT8 *  data     /* 8 bit value read from the PCI config space   */
	 );

extern STATUS frcPciConfigReadWord
	 (
         UINT8     busNum,  /* the selected bus                             */
         UINT8     devNum,  /* the selected device                          */
         UINT8     funNum,  /* the selected function                        */
         UINT8     regNum,  /* the register offset in Byte,                 */
                            /* from which to be loaded                      */
         UINT16 *  data     /* 16 bit value read from the PCI config space  */
	 );

extern STATUS frcPciConfigReadDword
	 (
         UINT8     busNum,  /* the selected bus                             */
         UINT8     devNum,  /* the selected device                          */
         UINT8     funNum,  /* the selected function                        */
         UINT8     regNum,  /* the register offset in Byte,                 */
                            /* from which to be loaded                      */
         UINT32 *  data     /* 32 bit value read from the PCI config space  */
	 );

extern STATUS frcPciConfigWriteByte
	 (
         UINT8  busNum,  /* the selected bus                     */
         UINT8  devNum,  /* the selected device                  */
         UINT8  funNum,  /* the selected function                */
         UINT8  regNum,  /* the register offset in Byte,         */
                         /* from which to be loaded              */
         UINT8  data     /* 8 bit value for the PCI config space */
	 );

extern STATUS frcPciConfigWriteWord
	 (
         UINT8   busNum,  /* the selected bus                             */
         UINT8   devNum,  /* the selected device                          */
         UINT8   funNum,  /* the selected function                        */
         UINT8   regNum,  /* the register offset in Byte,                 */
                          /* from which to be loaded                      */
         UINT16  data     /* 16 bit value for the PCI config space        */
	 );

extern STATUS frcPciConfigWriteDword
         (
         UINT8   busNum,  /* the selected bus                             */
         UINT8   devNum,  /* the selected device                          */
         UINT8   funNum,  /* the selected function                        */
         UINT8   regNum,  /* the register offset in Byte,                 */
                          /* from which to be loaded                      */
         UINT32  data     /* 32 bit value for the PCI config space        */
         );


LOCAL STATUS XpciFindDevice
    (
    int    vendorId,    /* vendor ID */
    int    deviceId,    /* device ID */
    int    index,       /* desired instance of device */
    int *  pBusNo,      /* bus number */
    int *  pDeviceNo,   /* device number */
    int *  pFuncNo      /* function number */
    )
{
  UINT32  Xid;     /* vendor and device ID */ 
  UINT16  Xindex;  /* instance of the device */ 
  UINT8   XbusNum; /* bus number */
  UINT8   XdevNum; /* device number */ 
  UINT8   XfunNum; /* function number */ 

  Xid = (UINT32)((vendorId & 0xffff) | ( deviceId << 16));
  Xindex = (UINT16)index;
  XbusNum = (UINT8)(*pBusNo & 0xff);
  XdevNum = (UINT8)(*pDeviceNo & 0xff);
  XfunNum = (UINT8)(*pFuncNo & 0xff);

  if(frcPciFindDevice(Xid,Xindex,&XbusNum,&XdevNum,&XfunNum)== ERROR)
    return(ERROR);

  *pBusNo =    (int)XbusNum;
  *pDeviceNo = (int)XdevNum;
  *pFuncNo =   (int)XfunNum;
  return(OK);
}

LOCAL STATUS XpciDevConfig
    (
    int pciBusNo,          /* PCI bus number */
    int pciDevNo,          /* PCI device number */
    int pciFuncNo,         /* PCI function number */
    UINT32 devIoBaseAdrs,  /* device IO base address */
    UINT32 devMemBaseAdrs, /* device memory base address */
    UINT32 command         /* command to issue */
    )
{
    STATUS tmp;
    PCI_DEV_INIT regs;

    regs.cmdStatReg     = command;
    regs.bar[0]         = devMemBaseAdrs;
    regs.bar[1]         = devIoBaseAdrs;
    regs.bar[2]         = NULL;
    regs.bar[3]         = NULL;
    regs.bar[4]         = NULL;
    regs.bar[5]         = NULL;
    regs.latencyTimer   = 64;

  tmp = frcPciDeviceInit((UINT8)(pciBusNo & 0xff),(UINT8)(pciDevNo & 0xff),\
     (UINT8)(pciFuncNo & 0xff),&regs,NULL,0,0);
    
  return(tmp);
}

LOCAL STATUS XpciConfigInByte
    (  
    int busNo,    /* bus number */
    int deviceNo, /* device number */
    int funcNo,   /* function number */
    int offset,   /* offset into the configuration space */
    UINT8 * pData /* data read from the offset */
    )
{
  STATUS tmp;
  tmp = frcPciConfigReadByte((UINT8)(busNo & 0xff),(UINT8)(deviceNo & 0xff),\
     (UINT8)(funcNo & 0xff), (UINT8)(offset & 0xff), pData);
    
  return(tmp);
}
 
LOCAL STATUS XpciConfigInWord
    (
    int busNo,      /* bus number */
    int deviceNo,   /* device number */
    int funcNo,     /* function number */
    int offset,     /* offset into the configuration space */
    UINT16 * pData  /* data read from the offset */
    )
{
  STATUS tmp;
  tmp = frcPciConfigReadWord((UINT8)(busNo & 0xff),(UINT8)(deviceNo & 0xff),\
     (UINT8)(funcNo & 0xff), (UINT8)(offset & 0xff), pData);
    
  return(tmp);
}
 
LOCAL STATUS XpciConfigInLong
    (
    int busNo,     /* bus number */
    int deviceNo,  /* device number */
    int funcNo,    /* function number */
    int offset,    /* offset into the configuration space */
    UINT32 * pData /* data read from the offset */
    )
{
  STATUS tmp;
  tmp = frcPciConfigReadDword((UINT8)(busNo & 0xff),(UINT8)(deviceNo & 0xff),\
     (UINT8)(funcNo & 0xff), (UINT8)(offset & 0xff), pData);
    
  return(tmp);
}
 
 
LOCAL STATUS XpciConfigOutByte
    (
    int busNo,    /* bus number */
    int deviceNo, /* device number */
    int funcNo,   /* function number */
    int offset,   /* offset into the configuration space */
    UINT8 data    /* data written to the offset */
    )
{
  STATUS tmp;
  tmp = frcPciConfigWriteByte((UINT8)(busNo & 0xff),(UINT8)(deviceNo & 0xff),\
     (UINT8)(funcNo & 0xff), (UINT8)(offset & 0xff), data);
    
  return(tmp);
}
 
 
LOCAL STATUS XpciConfigOutWord
    (
    int busNo,    /* bus number */
    int deviceNo, /* device number */
    int funcNo,   /* function number */
    int offset,   /* offset into the configuration space */
    UINT16 data   /* data written to the offset */
    )
{
  STATUS tmp;
  tmp = frcPciConfigWriteWord((UINT8)(busNo & 0xff),(UINT8)(deviceNo & 0xff),\
     (UINT8)(funcNo & 0xff), (UINT8)(offset & 0xff), data);
    
  return(tmp);
}
 
LOCAL STATUS XpciConfigOutLong
    (
    int busNo,    /* bus number */
    int deviceNo, /* device number */
    int funcNo,   /* function number */
    int offset,   /* offset into the configuration space */
    UINT32 data   /* data written to the offset */
    )
{
  STATUS tmp;
  tmp = frcPciConfigWriteDword((UINT8)(busNo & 0xff),(UINT8)(deviceNo & 0xff),\
     (UINT8)(funcNo & 0xff), (UINT8)(offset & 0xff), data);
    
  return(tmp);
}
