

#include "boardCsr.h"


gm_u32_t
gm_get_control_reg (gm_instance_state_t * is)
{
	PPCLAN *pPpcLanRegs = (PPCLAN *)is->lanai.control_regs;

	return(pPpcLanRegs->CSR_SET.reg);
}

gm_status_t
gm_board_reset_on (gm_instance_state_t * is)
{
	PPCLAN *pPpcLanRegs = (PPCLAN *)is->lanai.control_regs;

	return(GM_SUCCESS);
}

gm_status_t
gm_board_reset_off (gm_instance_state_t * is)
{
    PPCLAN *pPpcLanRegs = (PPCLAN *)is->lanai.control_regs;

	return(GM_SUCCESS);
}

gm_status_t
gm_ebus_reset_on (gm_instance_state_t * is)
{
    PPCLAN *pPpcLanRegs = (PPCLAN *)is->lanai.control_regs;

	pPpcLanRegs->CSR_SET.reg = LANRST | ERST;
	GM_STBAR ();
	return(GM_SUCCESS);
}

gm_status_t
gm_ebus_reset_off (gm_instance_state_t * is)
{
    PPCLAN *pPpcLanRegs = (PPCLAN *)is->lanai.control_regs;

	pPpcLanRegs->CSR_CLR.reg = ERST;
	GM_STBAR ();
	return(GM_SUCCESS);
}


gm_status_t
gm_lanai_reset_on (gm_instance_state_t * is)
{
    PPCLAN *pPpcLanRegs = (PPCLAN *)is->lanai.control_regs;

	pPpcLanRegs->INTE_CLR.reg = LANAI_INT;
	pPpcLanRegs->CSR_SET.reg = LANRST;
	pPpcLanRegs->CSR_CLR.reg = EN_DMA;
	GM_STBAR ();
	return(GM_SUCCESS);
}

gm_status_t
gm_lanai_reset_off (gm_instance_state_t * is)
{
    PPCLAN *pPpcLanRegs = (PPCLAN *)is->lanai.control_regs;

	pPpcLanRegs->CSR_SET.reg = EN_DMA;
	pPpcLanRegs->CSR_CLR.reg = LANRST;
	gm_set_EIMR (is, 0);
	GM_STBAR ();
	return(GM_SUCCESS);
}


gm_status_t
gm_enable_interrupts (gm_instance_state_t * is)
{
	PPCLAN *pPpcLanRegs = (PPCLAN *)is->lanai.control_regs;

	/* Make sure the host only ever gets host interrupts. */

	gm_set_EIMR (is, GM_HOST_SIG_BIT);
	GM_STBAR ();
	gm_arch_spin (is, 20000);

	pPpcLanRegs->INTE_SET.reg = LANAI_INT;
	GM_STBAR ();
	is->pausible = 1;
	return(GM_SUCCESS);
}

gm_status_t
gm_disable_interrupts (gm_instance_state_t * is)
{
    PPCLAN *pPpcLanRegs = (PPCLAN *)is->lanai.control_regs;

	gm_set_EIMR (is, 0);
	pPpcLanRegs->INTE_CLR.reg = LANAI_INT;
	GM_STBAR ();
	is->pausible = 0;
	return(GM_SUCCESS);
}

