/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#include "gm_internal.h"
#include "gm_ether.h"

#include    <sys/types.h>
#include    <sys/errno.h>
#include    <sys/debug.h>
#include    <sys/stropts.h>
#include    <sys/stream.h>
#include    <sys/strlog.h>
#include    <sys/cmn_err.h>
#include    <sys/kmem.h>
#include    <sys/conf.h>
#include    <sys/ksynch.h>
#include    <sys/stat.h>
#include    <sys/dlpi.h>
#include    <sys/modctl.h>
#ifdef  KSTAT
#include        <sys/kstat.h>
#endif
/*
   #include    <string.h>
 */

#include    <sys/ddi.h>
#include    <sys/sunddi.h>

#include "myri.h"

static int setup_buff_ptr(struct myri *myrip,
						  struct buff_info *infop, int length, int dir);


extern ddi_dma_attr_t gm_dma_attr;
extern struct ddi_device_acc_attr gm_dev_access_attr;

/************************  myri_alloc_buffers ****************************/

int
myri_alloc_buffers(struct myri *myrip)
{
	int i, rv = 0;
	struct buff_info *infop;

	if (!myrip) {
		return (0);
	}

	CMN_ERR(5, (CE_CONT, "myri_allocate: allocating buffer structures\n"));
	CMN_ERR(5, (CE_CONT, "myri_allocate: sizeof buff_info = %d handle = %d\n",
				sizeof(struct buff_info),
				sizeof(ddi_dma_handle_t)));

	MUTEX_ENTER(&myrip->myri_bufflock);
	ASSERT(++myrip->buff_count == 1);

	/* get buffers page aligned */

	infop = &myrip->recv1info[0];

	for (i = 0; i < NUM_RECV_BUFF1; i++, infop++) {
		infop->myrip = myrip;
		infop->index = i;
		infop->status = BUF_NOT_MAPPED;

		if ((rv = setup_buff_ptr(myrip, infop,
								 RECV1_LEN, DDI_DMA_READ))) {
			if (rv == -1) {
				goto setup_fail;
			}
			else if (rv == -2) {
				goto failed2;
			}
		}

		infop->free_func.free_func = (void (*)()) myri_add_buff;
		infop->free_func.free_arg = (char *) infop;
		infop->queue = RECV1_Q;
	}

	myrip->last_recv_index = -1;
	myrip->head_recv_index = 0;
	myrip->recv_buffer_count = NUM_RECV_BUFF1;

	infop = &myrip->sendinfo[0];
	for (i = 0; i < NUM_SEND_BUFF; i++, infop++) {
		infop->myrip = myrip;
		infop->index = i;
		infop->status = BUF_NOT_MAPPED;

		if ((rv = setup_buff_ptr(myrip, infop,
								 SEND_LEN, DDI_DMA_WRITE))) {
			if (rv == -1) {
				goto setup_fail;
			}
			else if (rv == -2) {
				goto failed2;
			}
		}

		infop->free_func.free_func = (void (*)()) myri_add_buff;
		infop->free_func.free_arg = (char *) infop;
		infop->queue = SENDQ;
	}
	myrip->last_send_index = -1;
	myrip->head_send_index = 0;
	myrip->send_buffer_count = 0;

	CMN_ERR(5, (CE_CONT, "Got addresses for the buffers\n"));

#if (GM_PRINT_LEVEL>=1)
	myri_dump_buff_info(&myrip->recv1info[0]);
	myri_dump_buff_info(&myrip->sendinfo[0]);
#endif							/* GM_PRINT_LEVEL */

	myrip->buff_count--;
	MUTEX_EXIT(&myrip->myri_bufflock);
	return (1);

  setup_fail:
  failed2:
	myrip->buff_count--;
	MUTEX_EXIT(&myrip->myri_bufflock);
	return (0);
}



/*******************   setup_buff_ptr()  *****************************/
static int
setup_buff_ptr(struct myri *myrip, struct buff_info *infop, int length, int dir)
{
	int rv;
	ddi_dma_cookie_t cookie;
	uint_t count;
	size_t rlen;
	static int i = 0;

	CMN_ERR(3, (CE_CONT, "before DMA setup %d\n", ++i));

	gm_dma_attr.dma_attr_align = GM_PAGE_LEN;
	gm_dma_attr.dma_attr_granular = GM_PAGE_LEN;

	rv = ddi_dma_alloc_handle(myrip->gm_port->kernel_port_state->instance->arch.dip,
					  &gm_dma_attr, DDI_DMA_DONTWAIT, NULL, &infop->handle);
	CMN_ERR(3, (CE_CONT, "after stuff myrip %d  infop_ %d rv %d\n", myrip, infop->handle, rv));

	if (rv != DDI_SUCCESS) {
		CMN_ERR_PRINT(0, (CE_CONT, "alloc_buffers: dma_alloc_handle failed infop = 0x%lx\n",
						  (unsigned long) infop));
		myri_dma_error(rv);
		return (-1);
	}

	CMN_ERR(3, (CE_CONT, "after DMA setup\n"));


	rv = ddi_dma_mem_alloc(infop->handle, (uint_t) length, &gm_dev_access_attr,
						   DDI_DMA_STREAMING, DDI_DMA_DONTWAIT, NULL,
				  (caddr_t *) & infop->kptr, &rlen, &infop->dma_acc_handle);


	if (rv != DDI_SUCCESS) {
		ddi_dma_free_handle(&infop->handle);
		CMN_ERR_PRINT(0, (CE_CONT, "alloc_buffers: dma_mem_handle failed infop = 0x%lx\n",
						  (unsigned long) infop));
		return -1;
	}

	CMN_ERR(3, (CE_CONT, "handle %d kernel ptr %d rlength %ld access_handle %d\n",
				infop->handle, infop->kptr, rlen, infop->dma_acc_handle));

	rv = ddi_dma_addr_bind_handle(infop->handle, (struct as *) NULL,
								  (caddr_t) infop->kptr, rlen,
		  DDI_DMA_STREAMING | dir, DDI_DMA_DONTWAIT, NULL, &cookie, &count);

	CMN_ERR(3, (CE_CONT, "after stuff  count %d rv %d\n", count, rv));

/* FIX - should make sure buffer has good alignment?? */

	if (rv != DDI_DMA_MAPPED) {
		CMN_ERR_PRINT(0, (CE_CONT, "alloc_buffers: dma_bind_handle failed infop = 0x%lx\n",
						  (unsigned long) infop));
		myri_dma_error(rv);

		(void) ddi_dma_mem_free(&infop->dma_acc_handle);
		ddi_dma_free_handle(&infop->handle);
		return (-2);
	}

	infop->dptr = (gm_dp_t) cookie.dmac_address;
	infop->rlen = rlen;
	infop->status = BUF_UNUSED;

	infop->ether_pkt.ptr = gm_hton_dp(infop->dptr);
	infop->ether_pkt.len = gm_hton_u32(length);

    if (infop) {
		CMN_ERR(1, (CE_CONT, "infop->dptr = 0x%lx  ether_pkt.ptr = 0x%lx\n",
				(unsigned long) infop->dptr,
				(unsigned long) infop->ether_pkt.ptr));
	}

	return (0);
}

/* BUGS BUGS BUGS */
void
myri_unalloc_buffers(struct myri *myrip)
{
	int i = 0;
	struct buff_info *infop;

	CMN_ERR(0, (CE_CONT, "myri_UNalloc_buffers: freeing buffers\n"));

	if (myrip) {
		CMN_ERR(0, (CE_CONT, "myri_UNalloc_buffers: freeing send buffers\n"));
		for (i = 0; i < NUM_SEND_BUFF; i++) {
			infop = &myrip->sendinfo[i];
			if (infop) {
				CMN_ERR(0, (CE_CONT, "freeing send buffer %d\n",i));
				ddi_dma_unbind_handle(infop->handle);
				ddi_dma_mem_free(&infop->dma_acc_handle);
				ddi_dma_free_handle(&infop->handle);
			}
		}

		infop = &myrip->recv1info[0];

		CMN_ERR(0, (CE_CONT, "myri_UNalloc_buffers: freeing receive buffers\n"));
		for (i = 0; i < NUM_RECV_BUFF1; i++) {
			infop = &myrip->recv1info[i];
			if (infop->status != BUF_LOANED) {
				if (infop) {
					CMN_ERR(0, (CE_CONT, "freeing recv buffer %d\n",i));
					ddi_dma_unbind_handle(infop->handle);
					ddi_dma_mem_free(&infop->dma_acc_handle);
					ddi_dma_free_handle(&infop->handle);
				}
			}
			else {
				CMN_ERR(0, (CE_CONT, "myri_UNalloc_buffers: recv buff %d is loaned\n", i));
			}
		}
	}
}



/********************* myri_free_buff_all() ******************/

int
myri_free_buff_all(struct myri *myrip)
{
	int i;
	register struct buff_info *infop;

	CMN_ERR(BUFF_PRINT, (CE_CONT, "myri_free_buff_all() called\n"));

	MUTEX_ENTER(&myrip->myri_bufflock);
	ASSERT(++myrip->buff_count == 1);

	infop = &myrip->recv1info[0];
	for (i = 0; i < NUM_RECV_BUFF1; i++, infop++) {
		if (infop->status != BUF_LOANED) {
			infop->status = BUF_UNUSED;
		}
	}

	infop = &myrip->sendinfo[0];
	for (i = 0; i < NUM_SEND_BUFF; i++, infop++) {
		if (infop->status != BUF_LOANED) {
			infop->status = BUF_UNUSED;
		}
	}

	myrip->buff_count--;
	MUTEX_EXIT(&myrip->myri_bufflock);

	return (1);
}



void
myri_reset_recv_buff(struct myri *myrip)
{
	struct buff_info *infop;
	int i;

	infop = &myrip->recv1info[0];
	for (i = 0; i < NUM_RECV_BUFF1; i++, infop++) {
		myri_add_buff(infop);
	}							/* for i */
}								/* all the bufs */

/************************   myri_add_buff()  ************************/
/*
 * Called to free a recv_buff and hand it to the LANai
 * If index == -1 then try to add all bufs for a particular queue
 *
 */

void
myri_add_buff(struct buff_info *infop)
{
	struct myri *myrip = infop->myrip;

	CMN_ERR(5, (CE_CONT, "myri_add_buff(%s,%d,%s)\n",
				(infop->queue == RECV1_Q) ? "queue1" : "BAD_Q",
				infop->index,
			  (infop->index == -1) ? "-" : BUFFINFO_STATUS(infop->status)));

	MUTEX_ENTER(&myrip->myri_bufflock);
	ASSERT(++myrip->buff_count == 1);

	switch (infop->status) {
	 case BUF_LOANED:
	 case BUF_UNUSED:
	 case BUF_NULL:
		 infop->status = BUF_LANAI;
		 /*      infop->ether_pkt.ptr = gm_hton_dp(infop->dptr); */
		 /* infop->ether_pkt.len = gm_htonl(RECV1_LEN); */
		 _gm_provide_ethernet_scatter_list(myrip->gm_port, 1, &infop->ether_pkt);
		 myrip->last_recv_index = CYCLE(myrip->last_recv_index, NUM_RECV_BUFF1);
		 myrip->recv_buf_index[myrip->last_recv_index].infop = infop;
		 myrip->recv_buffer_count++;
		 ASSERT(myrip->recv_buffer_count > NUM_RECV_BUFF1);
		 break;

	 case BUF_LANAI:
	 default:
		 /* invalid status for adding to LANai */
		 CMN_ERR(0, (CE_CONT, "myri_add_buff: bad status? = %s queue%d idx=%d\n",
			   BUFFINFO_STATUS(infop->status), infop->queue, infop->index));
		 break;
	}							/* switch */

	CMN_ERR(5, (CE_CONT, "----->myri_add_buff(EXIT)\n"));

	myrip->buff_count--;
	MUTEX_EXIT(&myrip->myri_bufflock);
}


/************************   myri_dump_buff_info()  ************************/
/*
 * Called to print the information in a buff_info array
 *
 */
void
myri_dump_buff_info(struct buff_info *infop)
{
	int i;
	int max;
	int unit = ddi_get_instance(infop->myrip->myri_dip);

	if ((unsigned long) infop == (unsigned long) &infop->myrip->recv1info[0]) {
		max = NUM_RECV_BUFF1;
		CMN_ERR(0, (CE_CONT, "Recv1 buffers\n"));
	}
	else if ((unsigned long) infop == (unsigned long) &infop->myrip->sendinfo[0]) {
		max = NUM_SEND_BUFF;
		CMN_ERR(0, (CE_CONT, "SEND buffers\n"));
	}
#ifdef SAFE_BUFF
	else if ((unsigned long) infop == (unsigned long) &infop->myrip->safeinfo[0]) {
		max = NUM_RECV_BUFF1;
		CMN_ERR(0, (CE_CONT, "SAFE buffers\n"));
	}
#endif							/* SAFE_BUFF */
	else {
		CMN_ERR(0, (CE_CONT, "infop - no match\n"));
		return;
	}

	CMN_ERR(0, (CE_CONT, "index\tkptr\tdptr\tlen\tunit\tqueue\tstatus\n"));
	for (i = 0; i < max; i++, infop++) {
		CMN_ERR(0, (CE_CONT, "%d\t%p\t%lx\t%lx\t%d\t%d\t%s\n",
					infop->index,
					infop->kptr,
					infop->dptr,
					infop->rlen,
					unit,
					infop->queue,
					BUFFINFO_STATUS(infop->status)));
	}
}

/*
  Local Variables:
  tab-width:4
  End:
*/

/* end of myri_buff.c */
