/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#include "gm_ether.h"

#define ALIGNED_SIZE	8192
/* #define MYRINET_MTU	(8192+128+40) */
#define MYRINET_MTU	GM_IP_MTU

#if defined(MYRI_DEBUG) 
#define CMN_ERR(level, args)   if (level <= GM_PRINT_LEVEL) cmn_err args
#else
#define CMN_ERR(level, args)
#endif

#define CMN_ERR_PRINT(level, args) if (level <= GM_PRINT_LEVEL)  cmn_err args

#define BUFF_PRINT	5	/* debug buff stuff  if <= GM_PRINT_LEVEL */
#define RESET_PRINT	0	/* debug reset stuff if <= GM_PRINT_LEVEL */
#define SEND_BLOCKED 5	/* debug send blocked by LANai if <= GM_PRINT_LEVEL */

#define MUTEX_ENTER(p)  { \
    if (p) mutex_enter(p); \
	 CMN_ERR(5, (CE_CONT, "mutex_ENTER(0x%x)\n", (unsigned)(p))); \
		      }

#define MUTEX_EXIT(p)   { \
    CMN_ERR(5, (CE_CONT, " mutex_EXIT(0x%x)\n", (unsigned)(p))); \
		if (p) mutex_exit(p); \
		     }

#define MYRI_MAX_BOARDS	(16)	/* maximum number of SBus boards */

#define RECV_FEW_MSGS		(3)	/* only rcv a few msgs per interrupt */
#define RECV_ALL_MSGS		(0xFFFF)	/* recv all msgs after send */
#define MYRI_MAX_SEND_TRIES	(5)		/* if AddSend fails, then retry */

/*for readability*/
#define RECV1_Q 1
#define SENDQ 4

#define HOWMANY(x, y)   (((x)+((y)-1))/(y))
#define CYCLE(x,max)    ((((x)+(1))>=(max))?0:((x)+(1)))

enum OPS {
    NO_OP, INSERT, DELETE, FREE_BUF, FIND_DELETE
};



/*
 * XXX Note that values used for #defines are bogus. You need to use
 * values that are appropriate for your driver/device. Also feel free
 * to add fields in the structs defined in this file.
 */

/*
 * XXX Declarations specific to the medium
 */

#define MEDIUM_MTU	(MYRINET_MTU)	/* max frame w/o header */
#define MEDIUM_MIN	(0)
#define MEDIUM_MAX	(HOST_MTU)	/* max frame w/header w/o fcs */


#define MEDIUMTYPE_MAX	(0xffff)/* max valid medium type */

/*
 * XXX Medium address length
 */

#define MEDIUM_ADDRL		(6)

/*
 * XXX structure for the medium specific address
 */

struct medium_addr {
    u_char medaddr[MEDIUM_ADDRL];
};

/*
 * XXX structure for the medium specific header
 */

struct medium_header {
    struct medium_addr med_dhost;
    struct medium_addr med_shost;
    u_short med_type;
};

#define	ETHERTYPE_PUP		(0x0200)	/* PUP protocol */
#define	ETHERTYPE_IP		(0x0800)	/* IP protocol */
#define	ETHERTYPE_ARP		(0x0806)	/* Addr. resolution protocol */
#define	ETHERTYPE_REVARP	(0x8035)	/* Reverse ARP */
#define	ETHERTYPE_MAX		(0xffff)	/* Max valid ethernet type */


/*
static struct medium_addr myri_zero_addr = {{0, 0, 0, 0, 0, 0}};
*/



/*
 * XXX Maximum # of multicast addresses per Stream
 */

#define DEVMAXMC	64
#define DEVMCALLOC	(DEVMAXMC * sizeof (struct medium_addr))

/*
 * XXX Declarations and definitions specific to the device. Add fields
 * as necessary.
 */


/*
 * XXX Definitions for modumyri_info.
 * Fill in values appropriate for your driver.
 * Contact USL to obtain a unique "registered" module ID number
 */

#define         MYRIIDNUM         (999)	/* module ID number */
#if GM_USE_MYRIGM
#define         MYRINAME          "myrigm"	/* module name */
#else
#define         MYRINAME          "myri"	/* module name */
#endif 
#define         MYRIMINPSZ        (0)	/* min packet size */
#define         MYRIMAXPSZ         (MYRINET_MTU)	/* max packet size */
#define         MYRIHIWAT         (0x7fffffff)	/* hi-water mark */
#define         MYRILOWAT         (1)	/* lo-water mark */



/*
 * Per-Stream instance state information.
 *
 * Each instance is dynamically allocated at open() and free'd at
 * close(). Each per-stream instance points to at most one per-device
 * structure using the sl_myrip field. All instances are threaded
 * together into one list of active instances ordered on minor device
 * number.
 */

struct myristr {
    struct myristr *sl_nextp;	/* next in list */
    queue_t *sl_rq;		/* ptr to our rq */
    struct myri *sl_myrip;	/* attached device */
    u_long sl_state;	/* current state */
    u_long sl_sap;		/* bound sap */
    u_long sl_flags;	/* misc flags */
    u_int sl_mccount;	/* # enabled multicast addrs */
    struct medium_addr *sl_mctab;	/* table of multicast addrs */
    u_long sl_minor;	/* minor device number */
    kmutex_t sl_lock;	/* protect this struct */
};

#define get_ether_type(ptr) (\
        (((u_char *)&((struct medium_header *)ptr)->med_type)[0] << 8) | \
        (((u_char *)&((struct medium_header *)ptr)->med_type)[1]))
#define put_ether_type(ptr, value) {\
        ((u_char *)(&((struct medium_header *)ptr)->med_type))[0] = \
                ((u_int)value & 0xff00) >> 8; \
        ((u_char *)(&((struct medium_header *)ptr)->med_type))[1] = \
                (value & 0xff); }

/* per-stream flags */
#define	SLFAST		0x01	/* "M_DATA fastpath" mode */
#define SLRAW           0x02	/* M_DATA plain raw mode */
#define SLALLPHYS       0x04	/* "promiscuous mode" */
#define SLALLMULTI      0x08	/* enable all multicast addresses */
#define SLALLSAP        0x10	/* enable all ether type values */





enum BUFF_STATUS {
    BUF_NULL = 0, BUF_LANAI, BUF_LOANED, BUF_UNUSED, BUF_NOT_MAPPED
};

#define BUFFINFO_STATUS(x) \
                           (x==BUF_NULL)?"NULL": \
			   (x==BUF_LANAI)?"LANAI": \
			   (x==BUF_LOANED)?"LOANED": \
			   (x==BUF_UNUSED)?"UNUSED": \
			   (x==BUF_NOT_MAPPED)?"NOT_MAPPED":"UNKNOWN"

struct buff_info {
  caddr_t kptr;	                        /* kernel virtual pointer */
  gm_dp_t dptr;

  unsigned int offset;
  unsigned int rlen;                    /* real length allocated */  

  int index;	                  	/* buffer index */
  int queue;		                /* buffer used for which queue */
  int status;		                /* free, in use etc */
  int next;	                	/* used for chaining possibly */

  ddi_dma_handle_t handle;              /* from ddi_dma_alloc */
  ddi_acc_handle_t dma_acc_handle;      /* for DMA mem alloc */

  frtn_t free_func;	                /* free_function and parameters */
  unsigned int *orig_ptr;	        /* originally allocated pointer */
  struct myri *myrip;            	/* pointer to the owner of the buff */

  gm_ethernet_segment_descriptor_t ether_pkt;
};

/*
	buffer layout

	recv1_buff[NUM_RECV_BUFF1]
	snd_buff[NUM_SEND_BUFF]
*/

/*
#define MYRI_IMMED_LEN  (256+TCP_IP_HDR_SIZE+ETHER_HEADER+ MYRI_MAX_PAD_LEN)
*/
#define MYRI_IMMED_LEN  (0)

#if 0
#define RECV1_LEN       (GM_ETHERNET_MTU)
#define SEND_LEN        (GM_ETHERNET_MTU)
#endif

#define RECV1_LEN       (GM_IP_MTU + 40)
#define SEND_LEN        (GM_IP_MTU + 40)

#ifdef intel_solaris
#define NUM_RECV_BUFF1	(GM_NUM_ETHERNET_RECV_TOKENS)
#define NUM_SEND_BUFF	(16)
#else
#define NUM_RECV_BUFF1	(GM_NUM_ETHERNET_RECV_TOKENS)
#define NUM_SEND_BUFF	(GM_NUM_SEND_TOKENS)
#endif

#define MYRI_LBUF_MIN  (NUM_RECV_BUFF1 / 4)	/* minimum num bufs for LANai, was 8 */

enum {TYPE_FREE=0, TYPE_MBUF, TYPE_SENDBUF, TYPE_SENDIMMED};
#define MAX_SEND_INDEX  (NUM_SEND_BUFF)

typedef struct _buffer_index
{
    struct buff_info *infop;
} buffer_index_t;

/*
 * Per-Device instance state information.
 *
 * Each instance is dynamically allocated on first attach.
 */
struct myri
{
  struct myri *myri_nextp;/* next in linked list */

  volatile int *myri_regsp;	/* addr of register set */
  
  dev_info_t *myri_dip;	/* dev info */
  struct medium_addr myri_ouraddr;	/* local address */
  u_int myri_flags;	/* misc. flags */
  u_int myri_wantw;	/* out of resources */
  kmutex_t myri_xmitlock;	/* protect send and send_ack Q */
  kmutex_t myri_recvlock;	/* protect recv_ack Q */
  kmutex_t myri_bufflock;	/* protect recv_buf Q */
  int xmit_count;
  int recv_count;
  int buff_count;

  queue_t *myri_ipq;		/* ip read queue */

  /* counters to keep stats for netstat support */
  ulong_t myri_ipackets;	/* # packets received */
  ulong_t myri_ierrors;	/* # total input errors */
  ulong_t myri_opackets;	/* # packets sent */
  ulong_t myri_oerrors;	/* # total output errors */
  ulong_t myri_collisions;/* # collisions */

  int alive;
  
  int head_send_index;
  int last_send_index;
  int send_buffer_count;
  struct buff_info sendinfo[NUM_SEND_BUFF];

  int head_recv_index;
  int last_recv_index;
  int recv_buffer_count;
  struct buff_info recv1info[NUM_RECV_BUFF1];
  buffer_index_t recv_buf_index[NUM_RECV_BUFF1];       /* for reclaiming recv_buffers */    

  kstat_t *ksp;
  int unit;
  gm_port_t *gm_port;    
};

/* flags */
#define MYRIRUNNING       0x01	/* chip is initialized */
#define MYRISLAVE         0x02	/* slave device (no DMA) */
#define MYRIPROMISC       0x04	/* promiscuous mode enabled */


/*
 * XXX Define offset to receive descriptor.
 */

#define MYRIHEADROOM	34

/*
 * Private DLPI full dlsap address format.
 * You need to specify a physical address (dl_phys) appropriate for
 * your medium
 */


struct myridladdr {
    struct medium_addr dl_phys;
    u_short dl_sap;
};

/*
 * Full DLSAP address length
 * You need to customize this based on your dladdr struct.
 */

#define DEVICE_ADDRL (sizeof (u_short) + MEDIUM_ADDRL)

#define DLADDRL	(80)		/* large upper bound on DL ADDR LEN */

#ifdef KSTAT

/*
 * "Export" a few of the error counters via the kstats mechanism.
 */
struct myristat {
    struct kstat_named les_ipackets;
    struct kstat_named les_ierrors;
    struct kstat_named les_opackets;
    struct kstat_named les_oerrors;
    struct kstat_named les_collisions;
};

#endif				/* KSTAT */

/* Some streams defines */

#define	DB_BASE(mp)		((mp)->b_datap->db_base)
#define	DB_LIM(mp)		((mp)->b_datap->db_lim)
#define	DB_REF(mp)		((mp)->b_datap->db_ref)
#define	DB_TYPE(mp)		((mp)->b_datap->db_type)

#define	MBLKL(mp)		((mp)->b_wptr - (mp)->b_rptr)
#define	MBLKSIZE(mp)	        ((mp)->b_datap->db_lim - (mp)->b_datap->db_base)
#define	MBLKHEAD(mp)	        ((mp)->b_rptr - (mp)->b_datap->db_base)
#define	MBLKTAIL(mp)	        ((mp)->b_datap->db_lim - (mp)->b_wptr)
#define	MBLKIN(mp, off, len)	(((mp)->b_rptr + off + len) <= (mp)->b_wptr)

#define	OFFSET(base, p)	        ((caddr_t)(p) - (caddr_t)(base))

/*
 * Function prototypes.
 */

extern void myriwenable(struct myri * myrip);
extern struct myristr *
myriaccept(struct myristr * slp, struct myri * myrip,
	   int type, struct medium_addr * addrp);

void myrisendup(struct myri *, mblk_t *);

#ifdef  KSTAT
static void myristatinit(struct myri *);
#endif

int
myri_update_list(unsigned id, ddi_dma_handle_t * handle,
		 mblk_t ** head, mblk_t ** tail, int op);
int myri_bad_alignment(mblk_t ** mptr_ptr);
int myri_tolanai(queue_t * wq, mblk_t * mp, struct myri * myrip);
void myri_dma_error(int rv);
void myri_free_send_buff(struct myri * myrip, int index_to_free);
void myri_lanai_error(struct myri * myrip);
void myri_init_lanai(struct myri * myrip);
unsigned short myri_what_sts(struct myri * myrip);
void myri_mutex_enter(struct myri * myrip);
void myri_mutex_exit(struct myri * myrip);
int myri_lanai_handshake(struct myri * myrip);
int myri_reset_lanai(struct myri * myrip);
int myri_handle_lanai_intr(struct myri * myrip);
int myri_do_l2h(struct myri * myrip);
mblk_t *myri_do_recv(struct myri * myrip, unsigned int len);
int myrinet_init_pointers_sbus(dev_info_t * dip, int instance, struct myri *myrip);

void lanai_reset_unit_sbus(int unit, int action);
void lanai_interrupt_unit_sbus(int unit, int action);
void lanai_set_ex1_unit_sbus(int unit, int action);
void myrierror(dev_info_t * dip, const char *fmt,...);

void myri_stop_lanai(struct myri * myrip);
void myri_dump_msg(mblk_t * mp);
int myriLoadLCPkernel(struct myri * myrip);

int myri_alloc_buffers(struct myri * myrip);
void myri_unalloc_buffers(struct myri *myrip);

int myri_free_buff_all(struct myri * myrip);
void myri_add_buff(struct buff_info * infop);
void myri_dump_buff_info(struct buff_info *);

gm_u32_t copy_mblk_to_buffer(char *vptr, char *lptr2);
void myri_reset_recv_buff (struct myri *myrip);

extern unsigned int TOTSIZE_BYTES(int unit);


#ifdef DO_CKSUM
int verify_cksum(unsigned char *head, mblk_t * m);
#endif DO_CKSUM


/*
extern int putq(queue_t * q, mblk_t * mp);
extern int putnext(queue_t * q, mblk_t * mp);
extern int canputnext(queue_t * q);
*/


extern ddi_dma_lim_t myri_dma_lim;
extern volatile u_short *LANAI[MYRI_MAX_BOARDS];
extern struct myri *myridev;



#ifdef DO_TIMING
#define GET_TIME(t_val) uniqtime(&(t_val))
#define SUB_TIME(t,sub) {               \
                t.tv_sec-=sub.tv_sec;   \
                t.tv_usec-=sub.tv_usec; \
        if (t.tv_usec < 0) {    \
                    t.tv_sec--;         \
                    t.tv_usec+=1000000; \
                }                       \
                if (t.tv_sec < 0) {     \
                    t.tv_sec = 0;       \
                    t.tv_usec = 0;      \
                    } \
        }
#define TIMING_PRINT	0
#else
#define GET_TIME(t_val) {}
#define SUB_TIME(t,sub) {}
#define TIMING_PRINT	100
#endif 


/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
 * psli.h header for the Sample Streams DLPI Driver
 */

/* end of myri.h */
