/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_myarch_h_
#define _gm_myarch_h_

/**********************************************************************
 * This file architecture-specific marcros and inline functions
 * required by gm.c and gm_arch.c. See gm_arch_types.h for typedefs.
 **********************************************************************/

/************************************************************************
 * Items in this section are not required by gm.c, but needed by the
 * implementations of the functions required by gm.c.
 ************************************************************************/


#include "gm_internal.h"
#include "gm_arch_types.h"
#include "gm_impl.h"
#include "gm_lanai.h"

#define GM_ARCH_MAX_INSTANCE 4	/* max number of boards */

/* Values of flags passed to
   dma_region_alloc() to indicate the
   type of receive buffer to allocate */

#define GM_ARCH_DMA_READ	0x10
#define GM_ARCH_DMA_WRITE	0x20
#define GM_ARCH_DMA_RDWR	(GM_ARCH_DMA_READ | GM_ARCH_DMA_WRITE)
#define GM_ARCH_DMA_CONSISTENT  0x40
#define GM_ARCH_DMA_STREAMING   0x80
#define GM_ARCH_DMA_CONTIGUOUS  0x100

#define GM_ARCH_INTR_CLAIMED         1
#define GM_ARCH_INTR_UNCLAIMED       2
#define GM_ARCH_SYNC_FOR_DEVICE      3
#define GM_ARCH_SYNC_FOR_CPU         4

#define GM_WOKE                      8
#define GM_SLEEP_TIMED_OUT           16
/* #define GM_INTERRUPTED               32 */

/************
 * Error notification values, used as return values for most driver functions.
 ************/
  
#define GM_EACCES		EACCES
#define GM_EBUSY		EBUSY
#define GM_EFAULT       	EFAULT
#define GM_EINTR		EINTR
#define GM_EINVAL		EINVAL
#define GM_ENOMEM		ENOMEM
#define GM_ENOTTY		ENOTTY
#define GM_EPERM		EPERM
#define GM_EPROTO		EPROTO
#define GM_EUNATCH		-99 /*EUNATCH*/

/****************************************************************
 * Debugging output macros
 ****************************************************************/

#define GM_ARCH_PRINT(args) printf args
#define GM_ARCH_INFO(args) printf args
#define GM_ARCH_NOTE(args) printf args
#define GM_ARCH_WARN(args) printf args
#define GM_ARCH_PANIC(args) printf args

#endif /* _gm_myarch_h_ */
     
