/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997, 1998 by Myricom, Inc.                       *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_lanai.h"
#include "gm_internal.h"
#include "gm_arch.h"
#include "gm_page_hash.h"

static gm_instance_state_t *dev_head = 0;
static gm_instance_state_t *gm_instances[GM_ARCH_MAX_INSTANCE];
int gm_instance_initialized[GM_ARCH_MAX_INSTANCE] = { 0, 0, 0, 0 };
static int gm_num_instance = 0;


/************
 * gm_port_state initialization 
 ************/

/* This is called just after the port state is created (in gm_minor.c)
   to perform architecture-specific initialization. */

gm_status_t gm_arch_port_state_init (gm_port_state_t * ps)
{
  return GM_SUCCESS;
}

/* This is called just before the port state is destroyed (in
   gm_minor.c) to perform architecture-specific finalization. */

void
gm_arch_port_state_fini (gm_port_state_t * ps)
{
  return;
}

/************
 * gm_port_state initialization 
 ************/

/* This is called at the end of gm_port_state_open() to perform architecture-
   specific initialization. */

gm_status_t gm_arch_port_state_open (gm_port_state_t * ps)
{
  return GM_SUCCESS;
}

/* This is called at the start of gm_port_state_close to perform
   architecture-specific finalization. */

void
gm_arch_port_state_close (gm_port_state_t * ps)
{
  return;
}

/***********************************************************************
 * Utility functions
 ***********************************************************************/

/* These are required so the gm_ioctl( ) can copy its arguments
   and results. */

gm_status_t
gm_arch_copyin (gm_port_state_t * ps,
		void *what, void *where, gm_size_t amount)
{
  return GM_FAILURE;
}

gm_status_t
gm_arch_copyout (gm_port_state_t * ps,
		 void *what, void *where, gm_size_t amount)
{
  return GM_FAILURE;
}


gm_status_t _gm_kernel_recv_queue_update (gm_port_t * p)
{
  return GM_FAILURE;
}




/************
 * PCI configuration space access functions.
 ************/

gm_status_t
gm_arch_read_pci_config_32 (gm_instance_state_t * is,
			    gm_offset_t offset, gm_u32_t * valueptr)
{
  return GM_SUCCESS;
}

gm_status_t
gm_arch_write_pci_config_32 (gm_instance_state_t * is,
			     gm_offset_t offset, gm_u32_t value)
{
  return GM_SUCCESS;
}

/* 16-bit accesses */

gm_status_t
gm_arch_read_pci_config_16 (gm_instance_state_t * is,
			    gm_offset_t offset, gm_u16_t * valueptr)
{
  return GM_SUCCESS;
}

gm_status_t
gm_arch_write_pci_config_16 (gm_instance_state_t * is,
			     gm_offset_t offset, gm_u16_t value)
{
  return GM_SUCCESS;
}

/* 8-bit accesses */

gm_status_t
gm_arch_read_pci_config_8 (gm_instance_state_t * is,
			   gm_offset_t offset, gm_u8_t * valueptr)
{
  return GM_SUCCESS;
}

gm_status_t
gm_arch_write_pci_config_8 (gm_instance_state_t * is,
			    gm_offset_t offset, gm_u8_t value)
{
  return GM_SUCCESS;
}


void
gm_arch_sync_init (gm_arch_sync_t * s, gm_instance_state_t * is)
{
}

void
gm_arch_sync_reset (gm_arch_sync_t * s)
{
}

void
gm_arch_sync_destroy (gm_arch_sync_t * s)
{
}

void
gm_arch_mutex_enter (gm_arch_sync_t * s)
{
}

void
gm_arch_mutex_exit (gm_arch_sync_t * s)
{
}

/* Sleep functions. Return 0 on wake, -1 on timeout, and 1 on signal. */

/* Wake the thread sleeping on the synchronization variable. */
void
gm_arch_wake (gm_arch_sync_t * s)
{
}

/* sleep until awakend or timeout */
gm_arch_sleep_status_t gm_arch_timed_sleep (gm_arch_sync_t * s, int seconds)
{
  return GM_WOKE;
}

/* sleep until awakened or get a signal */
gm_arch_sleep_status_t gm_arch_signal_sleep (gm_arch_sync_t * s)
{
  return GM_WOKE;
}

/*********************************************************************
 * DMA region functions
 *********************************************************************/

static void
gm_arch_lock_page (unsigned long phys)
{
}

static void
gm_arch_unlock_page (unsigned long phys)
{
}




gm_status_t
gm_arch_lock_user_buffer_page (gm_instance_state_t * is, gm_up_t in,
			       gm_dp_t * dma_addr, gm_arch_page_lock_t * lock)
{
  return GM_FAILURE;
}


void
gm_arch_unlock_user_buffer_page (gm_arch_page_lock_t * lock)
{
}



/* Allocate LEN bytes of DMA memory that is contiguous in kernel space
   by possibly segmented in DMA space.

   If r->register_function is non-null, call r->register_page_function
   (r, dma_addr) for each page. */

gm_status_t
gm_arch_dma_region_alloc (gm_instance_state_t * is, 
			gm_arch_dma_region_t * r,
			  gm_size_t len, gm_u32_t flags,
			  gm_register_page_function_t reg_function,
			  void *user_arg)
{
  return GM_SUCCESS;
}

void
gm_arch_dma_region_free (gm_arch_dma_region_t * r)
{
}

void *
gm_arch_dma_region_kernel_addr (gm_arch_dma_region_t * r)
{
	return r->addr;
}

gm_s32_t gm_arch_dma_region_status (gm_arch_dma_region_t * r)
{
  return 0xf;
}


gm_dp_t gm_arch_dma_region_dma_addr (gm_arch_dma_region_t * r)
{
  return r->dmaaddr;
}

gm_dp_t gm_arch_dma_region_dma_addr_advance (gm_arch_dma_region_t * r)
{
}

gm_status_t gm_arch_dma_region_sync (gm_arch_dma_region_t * r, int command)
{
  return GM_SUCCESS;
}


/*********************************************************************
 * kernel memory allocation functions 
 *********************************************************************/

void *
gm_arch_kernel_malloc (unsigned long len, int flags)
{
  void *ptr=NULL;
  return (ptr);
}

void
gm_arch_kernel_free (void *ptr)
{
  if (ptr)
    {
      /*free (ptr);*/
    }
}

/*********************************************************************
 * memory mapping (into kernel space)
 *********************************************************************/

gm_status_t
gm_arch_map_io_space (gm_instance_state_t * is, gm_u32_t offset, gm_u32_t len,
		      void **kaddr)
{
  return GM_SUCCESS;
}

void
gm_arch_unmap_io_space (gm_instance_state_t * is, gm_u32_t offset,
			gm_u32_t len, void **kaddr)
{
  return;
}

/* needed for memory registration? */

gm_status_t
gm_arch_mmap_contiguous_segment (gm_port_state_t * ps,
				 void *kaddr,
				 unsigned long blockSize, gm_up_t * vaddr)
{
  return GM_FAILURE;
}

void
gm_arch_munmap_contiguous_segments (gm_port_state_t * ps)
{
}

/*********************************************************************
 * miscellaneous functions
 *********************************************************************/

gm_status_t gm_arch_page_len (unsigned long *result)
{
  /* *result = ptob(1);*/
  return GM_SUCCESS;
}

gm_status_t gm_arch_physical_pages (gm_u32_t * result)
{
  return GM_FAILURE;
}


extern int gethostname (char *name, int nameLen);
gm_status_t gm_arch_gethostname (char *ptr, int len)
{
/*
  int rv;
  rv = gethostname (ptr, len);
  if (rv == OK)
    {
      ptr[len - 1] = 0;
      return GM_SUCCESS;
    }
*/
  return GM_FAILURE;
}

void
gm_arch_spin (gm_instance_state_t * is, gm_u32_t usecs)
{
  /* usleep(usecs); */
}

gm_status_t gm_arch_get_page_len (unsigned long *page_len)
{
  /* *page_len = ptob(1);*/
  return GM_SUCCESS;
}

gm_dp_t gm_arch_no_VM_dma_bits_to_set (gm_instance_state_t * is)
{
  return 0;
}


gm_dp_t gm_arch_no_VM_dma_bits_to_clear (gm_instance_state_t * is)
{
  return 0;
}


#ifdef EXAMPLE_CODE
  for (i = 0; i < units; i++)
    {
      GM_PRINT (GM_PRINT_LEVEL >= 1,
		("Inititializing instance %d\n", gm_num_instance));
      gm_instances[gm_num_instance] = malloc (sizeof (gm_instance_state_t));
      if (gm_instances[gm_num_instance] == NULL)
	{
	  GM_NOTE (("malloc of GM instance struct failed\n"));
	  goto abort_with_nothing;
	}
      is = gm_instances[gm_num_instance];
      bzero ((unsigned char *) is, sizeof (gm_instance_state_t));
      GM_PRINT (1, ("Instance state ptr = %p\n", is));

      is->id = gm_num_instance;


      if (gm_instance_init (is, gm_num_instance, GM_SYSTEM_BUS_TYPE) !=
	  GM_SUCCESS)
	{
	  GM_INFO (("Could not initialize instance %d.\n", gm_num_instance));
	  gm_instance_initialized[gm_num_instance] = 0;
	  goto abort_with_instance;
	}
      gm_instance_initialized[gm_num_instance] = 1;

      /* Set up the interrupt handler and enable interrupts */

      gm_enable_interrupts (gm_instance_for_id (gm_num_instance));
      gm_instance_initialized[gm_num_instance] = 1;

      GM_INFO (("Init Complete for instance %d.\n", gm_num_instance));

      gm_num_instance++;
    }

  return (OK);

abort_with_instance:
abort_with_nothing:
  gm_instance_initialized[gm_num_instance] = 0;
  return (ERROR);
}
#endif /* EXAMPLE_CODE */



/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  c-backslash-column:72
  tab-width:8
  End:
*/
