#include <ndis.h>
#include "gmm.h"

NDIS_STATUS gmm_SetInformation (NDIS_HANDLE miniportAdapterContext,
 NDIS_OID oid,
 PVOID informationBuffer,
 ULONG informationBufferLength,
 PULONG bytesRead,
 PULONG bytesNeeded)
{
  GMM_PRINT (("gmm_SetInformation called.\n"));

  switch (oid)
  {
    case OID_802_3_MULTICAST_LIST:
      GMM_PRINT (("gmm_SetInformation OID_802_3_MULTICAST_LIST (%d)\n", informationBufferLength));
      return NDIS_STATUS_SUCCESS;

    case OID_GEN_CURRENT_PACKET_FILTER:
      GMM_PRINT (("gmm_SetInformation OID_GEN_CURRENT_PACKET_FILTER (%d)\n", informationBufferLength));
      return NDIS_STATUS_SUCCESS;

    case OID_GEN_CURRENT_LOOKAHEAD:
      GMM_PRINT (("gmm_SetInformation OID_GEN_CURRENT_LOOKAHEAD (%d)\n", informationBufferLength));
      return NDIS_STATUS_SUCCESS;

    case OID_GEN_PROTOCOL_OPTIONS:
      GMM_PRINT (("gmm_SetInformation OID_GEN_PROTOCOL_OPTIONS (%lu)\n",
		  informationBufferLength));
      return NDIS_STATUS_SUCCESS;

    default:
      GMM_PRINT (("gmm_SetInformation with unsupported OID %lx.\n",
		  (ULONG) (oid)));
       
      return NDIS_STATUS_INVALID_OID;
  }
  return NDIS_STATUS_FAILURE;
}


/*mandatory oids*/
static NDIS_OID supportedOids[]=
{
  OID_GEN_SUPPORTED_LIST,
  OID_GEN_HARDWARE_STATUS,
  OID_GEN_MEDIA_SUPPORTED,
  OID_GEN_MEDIA_IN_USE,
  OID_GEN_MAXIMUM_LOOKAHEAD,
  OID_GEN_MAXIMUM_FRAME_SIZE,
  OID_GEN_LINK_SPEED,
  OID_GEN_TRANSMIT_BUFFER_SPACE,
  OID_GEN_RECEIVE_BUFFER_SPACE,
  OID_GEN_TRANSMIT_BLOCK_SIZE,
  OID_GEN_RECEIVE_BLOCK_SIZE,
  OID_GEN_VENDOR_ID,
  OID_GEN_VENDOR_DESCRIPTION,
  OID_GEN_VENDOR_DRIVER_VERSION, /*todo*/
  OID_GEN_CURRENT_PACKET_FILTER,
  OID_GEN_CURRENT_LOOKAHEAD,
  OID_GEN_DRIVER_VERSION,
  OID_GEN_MAXIMUM_TOTAL_SIZE,
  OID_GEN_PROTOCOL_OPTIONS, /*todo*/
  OID_GEN_MAC_OPTIONS,
  OID_GEN_MEDIA_CONNECT_STATUS,
  OID_GEN_MAXIMUM_SEND_PACKETS,
  
  OID_GEN_XMIT_OK,
  OID_GEN_RCV_OK,
  OID_GEN_XMIT_ERROR,
  OID_GEN_RCV_ERROR,
  OID_GEN_RCV_NO_BUFFER,
  
  OID_802_3_PERMANENT_ADDRESS,
  OID_802_3_CURRENT_ADDRESS,
  OID_802_3_MULTICAST_LIST,
  OID_802_3_MAXIMUM_LIST_SIZE,
  OID_802_3_MAC_OPTIONS,
  
  OID_802_3_RCV_ERROR_ALIGNMENT,
  OID_802_3_XMIT_ONE_COLLISION,
  OID_802_3_XMIT_MORE_COLLISIONS
};


NDIS_STATUS gmm_QueryInformation (NDIS_HANDLE miniportAdapterContext,
 NDIS_OID oid,
 PVOID informationBuffer,
 ULONG informationBufferLength,
 PULONG bytesWritten,
 PULONG bytesNeeded)
{

  gmm_Context*context = (gmm_Context*)miniportAdapterContext;
  NDIS_MEDIUM medium = NdisMedium802_3;
  UINT longval;
  USHORT shortval;
  UCHAR address[6];
  NDIS_HARDWARE_STATUS hardwareStatus;
  ULONG filter =
    NDIS_PACKET_TYPE_ALL_FUNCTIONAL |
    NDIS_PACKET_TYPE_ALL_LOCAL |
    NDIS_PACKET_TYPE_DIRECTED |
    NDIS_PACKET_TYPE_FUNCTIONAL |
    NDIS_PACKET_TYPE_GROUP |
    NDIS_PACKET_TYPE_PROMISCUOUS |
    NDIS_PACKET_TYPE_SOURCE_ROUTING;
  
  PVOID source; 
  ULONG bytes;
  NDIS_STATUS status = NDIS_STATUS_SUCCESS;

  if (gm_get_unique_board_id (context->port, address) != GM_SUCCESS)
  {
    GMM_PRINT (("gm_get_unique_board_id failed\n"));
    return NDIS_STATUS_FAILURE;
  }
  
  GMM_PRINT (("gmm_QueryInformation called.\n"));

  *bytesWritten = 0;
  *bytesNeeded = 0;
  source = &longval;
  bytes = sizeof (longval);
  
  switch (oid)
  {
    
    case OID_GEN_SUPPORTED_LIST:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_SUPPORTED_LIST\n"));
  
      source = (PVOID) supportedOids;
      bytes = sizeof (supportedOids);
      break;
      
    case OID_GEN_HARDWARE_STATUS:
      GMM_PRINT (("gmm_QueryInformation: OID_\n"));
      
      hardwareStatus = NdisHardwareStatusReady;
      source = &hardwareStatus;
      bytes = sizeof (hardwareStatus);
      break;
      
    case OID_GEN_MEDIA_SUPPORTED:
    case OID_GEN_MEDIA_IN_USE:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_MEDIA_IN_USE\n"));

      source = &medium;
      bytes = sizeof (medium);
      break;
      
    case OID_GEN_MAXIMUM_LOOKAHEAD:
    case OID_GEN_MAXIMUM_FRAME_SIZE:
    case OID_GEN_CURRENT_LOOKAHEAD:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_CURRENT_LOOKAHEAD\n"));

      longval = GMM_MTU - GMM_SLOP;
      break;
      
    case OID_GEN_LINK_SPEED:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_LINK_SPEED\n"));

      /*units of 100 bps*/
      longval = 10*1000*1000; /*whatever*/
      break;
      
    case OID_GEN_TRANSMIT_BUFFER_SPACE:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_TRANSMIT_BUFFER_SPACE\n"));

      longval = GMM_NUM_SEND_BUFFERS*GMM_MTU;
      break;
      
    case OID_GEN_RECEIVE_BUFFER_SPACE:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_RECEIVE_BUFFER_SPACE\n"));

      longval = GMM_NUM_RECEIVE_BUFFERS*GMM_MTU;
      break;
      
    case OID_GEN_TRANSMIT_BLOCK_SIZE:
    case OID_GEN_RECEIVE_BLOCK_SIZE:
    case OID_GEN_MAXIMUM_TOTAL_SIZE:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_MAXIMUM_TOTAL_SIZE\n"));

      longval = GMM_MTU - GMM_SLOP;
      break;
      
    case OID_GEN_VENDOR_ID:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_VENDOR_ID\n"));

      longval = 1; /*todo*/
      break;
      
    case OID_GEN_VENDOR_DESCRIPTION:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_VENDOR_DESCRIPTION\n"));

      source = GMM_VENDOR_DESCRIPTION;
      bytes = GM_STATIC_CAST(ULONG, strlen (GMM_VENDOR_DESCRIPTION) + 1);
      break;

    case OID_GEN_VENDOR_DRIVER_VERSION:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_VENDOR_DRIVER_VERSION\n"));
      shortval = GMM_DRIVER_VERSION << 8;
      source = &shortval;
      bytes = sizeof (shortval);
      break;

    case OID_GEN_CURRENT_PACKET_FILTER:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_CURRENT_PACKET_FILTER\n"));

      if (informationBufferLength != 4)
	return NDIS_STATUS_INVALID_DATA;
      longval = filter;
      break;

    case OID_GEN_DRIVER_VERSION:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_DRIVER_VERSION\n"));

      shortval = GM_MINIPORT_MAJOR_VERSION * 0x100 + GM_MINIPORT_MINOR_VERSION;
      source = &shortval;
      bytes = sizeof (shortval);
      break;
      
    case OID_GEN_MAC_OPTIONS:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_MAC_OPTIONS\n"));

      longval =  (NDIS_MAC_OPTION_COPY_LOOKAHEAD_DATA |
		  NDIS_MAC_OPTION_NO_LOOPBACK |
		  NDIS_MAC_OPTION_TRANSFERS_NOT_PEND |
		  NDIS_MAC_OPTION_FULL_DUPLEX);
      break;
    
    case OID_GEN_MEDIA_CONNECT_STATUS:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_MEDIA_CONNECT_STATUS\n"));

      longval = NdisMediaStateConnected;
      break;
      
    case OID_GEN_MAXIMUM_SEND_PACKETS:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_MAXIMUM_SEND_PACKETS\n"));

     longval = GMM_MAX_PACKETS_PER_SEND;
      break;
      
    case OID_GEN_XMIT_OK:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_XMIT_OK\n"));

      longval = context->gmm_numGoodSends;
      break;
      
    case OID_GEN_RCV_OK:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_RCV_OK\n"));

      longval = context->gmm_numGoodReceives;
      break;
      
    case OID_GEN_XMIT_ERROR:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_XMIT_ERROR\n"));

      longval = context->gmm_numBadSends;
      break;
      
    case OID_GEN_RCV_ERROR:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_RCV_ERROR\n"));

      longval = context->gmm_numBadReceives;
      break;
      
    case OID_GEN_RCV_NO_BUFFER:
      GMM_PRINT (("gmm_QueryInformation: OID_GEN_RCV_NO_BUFFER\n"));

      longval = context->gmm_numNoBuffers;
      break;
      
    case OID_802_3_PERMANENT_ADDRESS:
    case OID_802_3_CURRENT_ADDRESS:
      GMM_PRINT (("gmm_QueryInformation: OID_802_3_CURRENT_ADDRESS\n"));
      
      source = address;
      bytes = 6;
      break;
      
    case OID_802_3_MULTICAST_LIST:
      GMM_PRINT (("gmm_QueryInformation: OID_802_3_MULTICAST_LIST\n"));

      return NDIS_STATUS_INVALID_OID;
      
    case OID_802_3_MAXIMUM_LIST_SIZE:
      GMM_PRINT (("gmm_QueryInformation: OID_802_3_MAXIMUM_LIST_SIZE\n"));

      longval = GMM_MAX_MULTICAST_ADDRESSES;
      break;
      
    case OID_802_3_MAC_OPTIONS:
      GMM_PRINT (("gmm_QueryInformation: OID_802_3_MAC_OPTIONS\n"));

      longval = 0;
      break;
      
    case OID_802_3_RCV_ERROR_ALIGNMENT:
      GMM_PRINT (("gmm_QueryInformation: OID_802_3_RCV_ERROR_ALIGNMENT\n"));

      longval = context->gmm_numBadReceiveAlignments;
      break;
      
    case OID_802_3_XMIT_ONE_COLLISION:
      GMM_PRINT (("gmm_QueryInformation: OID_802_3_XMIT_ONE_COLLISION\n"));

      longval = 0;
      break;
      
    case OID_802_3_XMIT_MORE_COLLISIONS:
      GMM_PRINT (("gmm_QueryInformation: OID_802_3_XMIT_MORE_COLLISIONS\n"));

      longval = 0;
      break;
      
    default:
      GMM_PRINT (("gmm_QueryInformation: OID_802_3_XMIT_MORE_COLLISIONS\n"));

      return NDIS_STATUS_INVALID_OID;
  }
  if (bytes > informationBufferLength)
  {
    *bytesNeeded = bytes;
    GMM_PRINT (("gmm_QueryInformation returning INVALID_LENGTH (%d/%d)\n", bytes, informationBufferLength));

    return NDIS_STATUS_INVALID_LENGTH;
  }

  GMM_PRINT (("gmm_QueryInformation returning SUCCESS. \n"));
  
  *bytesWritten = bytes;
  NdisMoveMemory(informationBuffer, source, bytes);
  
    
  return NDIS_STATUS_SUCCESS;
}
