#ifndef GMM_DRIVER_LINK_H
#define GMM_DRIVER_LINK_H

#define GMM_DRIVER_LINK_DEVICE_NAME L"\\Device\\gmDriverLink"
#define GMM_DRIVER_LINK_VERSION 3

typedef struct gmm_DriverLink
{
  /* The TYPE field must not be moved or its type changed, as it is
     used to distinguish this type of NT device extension from others
     used in the GM driver. */
  enum gm_nt_device_extension_type type;

#if !GM_INTEGRATE_DRIVERS
  int version;
  PDRIVER_OBJECT driver;
#endif
  unsigned int interruptVector;
  unsigned int interruptLevel;
  
  void (*allocateSharedMemory)(struct gm_port *p,
			       int size, void**virtualAddress,
			       ULONG*physicalLow, ULONG*physicalHigh);
  void (*freeSharedMemory)(struct gm_port *p, void*virtualAddress);
  gm_status_t (*gm_open) (struct gm_port **p, unsigned unit,
			  unsigned port, char *port_name,
			  enum gm_api_version version);
  union gm_recv_event* (*gm_receive) (struct gm_port *p);
  void (*gm_unknown) (struct gm_port * p, union gm_recv_event *e);
  void (*gm_ethernet_send) (struct gm_port *p,
			    gm_u32_t segment_count,
			    gm_ethernet_segment_descriptor_t segment[],
			    gm_u8_t *ethernet_addr,
			    int prepend_type);
  void (*gm_ethernet_broadcast) (struct gm_port *p,
				 gm_u32_t segment_cnt,
				 gm_ethernet_segment_descriptor_t segment[],
				 int prepend_type);
  void (*gm_provide_ethernet_scatter_list) (struct gm_port *p,
					    gm_u32_t segment_cnt,
					    gm_ethernet_segment_descriptor_t
					    segment[]);
  gm_status_t (*gm_get_unique_board_id) (struct gm_port *port,
					 char unique[6]);

  void (*gm_close) (struct gm_port * p);
  void (*enableInterrupts) (struct gm_port *p);
  void (*disableInterrupts) (struct gm_port *p);
  void (*gm_ethernet_set_sent_intr_callback) (gm_port_t *p,
					      void (*callback)(void *),
					      void *context);
  void (*gm_ethernet_set_recv_intr_callback) (gm_port_t*p,
					      void (*callback) (void*, unsigned),
					      void*context);
  
  /* void*instance; */
} gmm_DriverLink;


#endif /*GMM_DRIVER_LINK_H*/
