/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if GM_KERNEL
#include <devioctl.h>
#else
#include <windows.h>
#endif

/* Windows packs additional meaning into the IOCTL commands */

#  define GM_IO(command) \
    CTL_CODE (FILE_DEVICE_UNKNOWN, 0x800+(command), \
	      METHOD_BUFFERED, FILE_ANY_ACCESS)
#  define GM_IO_NEITHER(command) \
    CTL_CODE (FILE_DEVICE_UNKNOWN, 0x800+(command), \
	      METHOD_NEITHER, FILE_ANY_ACCESS)

typedef struct gm_mmap_info
{
  gm_u32_t offset;		/* offset to map */
  gm_u32_t len;			/* length to map */
  unsigned int requested_permissions;	/* GM_MAP_READ/GM_MAP_WRITE */
  void *va;			/* Virtual address hint */
}
gm_mmap_info_t;

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
