/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 			 *
 * Copyright (c) 2000 by Myricom, Inc.					 				 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#if GM_NEED_MODVERSIONS
#include <linux/config.h>
#ifdef CONFIG_MODVERSIONS
#define MODVERSIONS
#include <linux/modversions.h>
#endif
#endif /*GM_NEED_MODVERSIONS*/

#include "gm_internal.h"
#include "gm_ether.h"
#include "gm_debug_lanai_dma.h"


#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include <linux/string.h>
#define __NO_VERSION__
#include <linux/module.h>
#include <linux/etherdevice.h>
#include <asm/byteorder.h>
#include <asm/io.h>

#include "gm_arch_def.h"
#include "gm_klog_debug.h"
#include "gm_trace.h"
#include "gm_pio.h"

#if 0
/* to disable interrupts while sending a ethernet packet,
   normally not needed */
#define GM_XMIT_CLI
#endif

/* should be a multiple of 16 bytes */
static inline
gm_size_t
GM_SKB_SIZE (struct net_device *dev)
{
  gm_size_t mtu;

  mtu = dev->mtu;

  return (GM_ROUNDUP (size, mtu, 16)
		  + (unsigned) ETH_HLEN
		  + 2U
		  + (GM_DMA_GRANULARITY < 16
			 ? 16U
			 : (unsigned) GM_DMA_GRANULARITY)
		  + 128U);
}

#if GM_DEBUG_KLOG
struct gm_klog_struct gm_klog_tab[GM_KLOG_NBEVT];
atomic_t gm_klog_index;
#endif

static void gm_set_bitmap(gm_instance_state_t *is,void *addr,int len, int set)
{
  if (GM_TRACE_LANAI_DMA)
	{
	  static unsigned char pagecount[GM_MAX_HOST_DMA_PAGES];
	  ulong p = virt_to_phys(addr);
	  ulong end = p + len;
	  long flags;
	  
	  /* Here is the trick, there can be several buffer in the same page,
		 so we increments the page count, to track this, this work as long
		 as the clean becomes before freeing the buffer, and that the
		 memory is kmalloced memory so page->count = 1 means not in use
		 anymore (except with slab, page->count can be zero) --Loic */
	  
	  save_flags(flags);
	  /* protect concurrent modification between interrupt handler and
         net context */
	  cli(); 
	  while ((p & ~(PAGE_SIZE-1)) < end) {
		int pagenum = GM_PHYS_MAP_NR(p);
		struct page *page = mem_map+pagenum;
		gm_always_assert(pagenum < GM_MAX_HOST_DMA_PAGES);
		if (set) {
		  GM_BITMAP_WRAPPING_SET (*is->dma_page_bitmap, pagenum);
		  gm_always_assert(atomic_read(&page->count) >= 0);
		  pagecount[pagenum]++;
		} else {
		  gm_always_assert(atomic_read(&page->count) >= 0);
		  gm_always_assert(pagecount[pagenum]>=1);
		  pagecount[pagenum]--;
		  if (pagecount[pagenum]==0) {
			GM_BITMAP_WRAPPING_SET (*is->dma_page_bitmap, pagenum);
		  }
		}
		p += PAGE_SIZE;
	  }
	  restore_flags(flags);
	}
}

#define GM_DMA_WILL_CROSS_PAGE 1

static int 
gmip_build_desc(void *data,int len, gm_ethernet_segment_descriptor_t desc[GM_MAX_ETHERNET_SCATTER_CNT]) {

#if !GM_DMA_WILL_CROSS_PAGE
  int i = 0;
  unsigned long start = (unsigned long)data;
  while (len > 0) {
    unsigned long end = (start + PAGE_SIZE) & ~(PAGE_SIZE-1);
    unsigned long fraglen;
    gm_assert(i == 0 || (start & (PAGE_SIZE - 1)) == 0);
    gm_always_assert(i < GM_MAX_ETHERNET_SCATTER_CNT);
    fraglen = end > start + len ? len : end - start;
    desc[i].ptr = gm_hton_dp(gm_virt_to_bus((void*)start));
    desc[i].len = gm_htonl(fraglen);
    start += fraglen;
    len -= fraglen;
    i += 1;
  }
  gm_assert(len == 0);
  return i;
#else
  desc[0].ptr = gm_hton_dp(gm_virt_to_bus(data));
  desc[0].len = gm_hton_u32(len);

  return 1;
#endif
  
}

#if GM_ENABLE_TRACE
unsigned gm_tcp_window(char *data,int len)
{
#if 0
  if (len >= 56)
    return ntohs(((unsigned short*)data)[(14/*eth*/+20/*ip*/+14/*window off*/)/2])+(len << 16);
  else
#endif
    return 1+ (len<<16);
}
#endif

static
void gmip_recv_interrupt (void *gmnetp, const unsigned int ulen, gm_u16_t csum)
{
  gm_arch_net_info_t *gmnet = gmnetp;
  struct net_device *dev = gmnet->dev;
  int index = gmnet->rdone & GM_RECV_RING_MAX_INDEX;
  gm_ethernet_segment_descriptor_t desc[GM_MAX_ETHERNET_SCATTER_CNT];
  int nbdesc;
  const int len = ulen;
  gm_u16_t myritype;
  struct sk_buff *new,*skb = gmnet->recv_ring[index];
  gm_always_assert(skb);
  
  GM_LOG_STAMPED_EVT(GM_ETHER_RCV,gm_tick(),0, gm_tcp_window((char*)skb->data+2,ulen-2));
  
  GM_PRINT (GM_PRINT_LEVEL >= 5,("gmip_recv_interrupt(%p, len=%d)\n",gmnetp,ulen));

  gm_set_bitmap(gmnet->is, skb->data,skb_tailroom(skb),0);
  gmnet->recv_ring[index] = 0;

  if (len < ETH_HLEN + 2) {
    GM_PRINT (1, ("Hmm, received invalid packet: len=%d\n",len));
    gmnet->stats.rx_dropped += 1;
    goto end;
  }
  if (len > skb_tailroom(skb)) {
    GM_PANIC (("Received ethernet packet bigger than buffer: len=%d,tailroom=%d\n",len,skb_tailroom(skb)));
  }
  
  /* set the skb len to the amount received */
  skb_put(skb,len);

  /* remove the type */
  myritype = *(gm_u16_t*)skb->data;
  skb_pull(skb,2);
  if (myritype != __gm_hton_u16(GM_ETHERNET_PACKET_TYPE)) {
    GM_PRINT (1,("%s: received packet with strange header:0x%x\n",dev->name,myritype));
    gmnet->stats.rx_dropped += 1;
    goto end;
  }
  if (ulen <= 2 + sizeof (struct ethhdr)
	  || ulen >= GM_SKB_SIZE (dev)) {
    struct ethhdr *eth = (struct ethhdr*)skb->data;
    GM_PRINT (1,("%s:bad eth pkt rcvd, len= %d, src:%x:%x:%x:%x:%x:%x "
                "dst: %x:%x:%x:%x:%x:%x proto=0x%x\n",gmnet->dev->name,len,
                eth->h_source[0],eth->h_source[1],eth->h_source[2],
                eth->h_source[3], eth->h_source[4],eth->h_source[5],
                eth->h_dest[0],eth->h_dest[1],eth->h_dest[2],
                eth->h_dest[3], eth->h_dest[4],eth->h_dest[5],ntohs(eth->h_proto)));
    gmnet->stats.rx_dropped += 1;
    goto end;
  }

    

  
  if (0 && len < GM_NET_COPY_THRESHOLD) {
    new = alloc_skb(skb->len+2, GFP_ATOMIC);
    if (!new) {
      gmnet->stats.rx_dropped += 1;
      goto end;
    }
    /* to align the IP part */
    skb_reserve(skb,2);
    memcpy(skb_put(new,skb->len), skb->data, skb->len);
    new->ip_summed = CHECKSUM_NONE;
    new->protocol = eth_type_trans(skb,dev);
    new->dev = dev;
    netif_rx(new);
    /* the new buffer to put into the ring */
    new = skb;
  } else {
    new = alloc_skb(GM_SKB_SIZE(dev), GFP_ATOMIC);
    if (!new) {
      gmnet->stats.rx_dropped += 1;
      goto end;
    }

#if GM_SUPPORT_L7_ONLY
#define GM_IP_CHECKSUM_FAKE /*1*/ 0
#else
#define GM_IP_CHECKSUM_FAKE 0
#endif

#if GM_IP_CHECKSUM_FAKE
    skb->ip_summed = CHECKSUM_UNNECESSARY;
    skb->csum = 0;
#else
    if (0 && csum) {
        /* card gave us an IP checksum of the message */
	  unsigned short *sptr = (unsigned short *)skb->data;

        GM_PRINT (1,("card gave us an IP csum = 0x%04x  rev = 0x%04x\n",csum,__gm_ntoh_u16(csum)));
        skb->ip_summed = CHECKSUM_HW;
        /* subtract out the 0x0020 */
        /* subtract out ethernet header */
		skb->csum = __gm_ntoh_u16(csum);
        skb->csum +=  ~__gm_hton_u32 (GM_ETHERNET_PACKET_TYPE);
		skb->csum += (~sptr[0] + ~sptr[1] + ~sptr[2] +
		              ~sptr[3] + ~sptr[4] + ~sptr[5]);
	skb->csum = (skb->csum&0xFFFF) + (skb->csum>>16);
	skb->csum = (skb->csum&0xFFFF) + (skb->csum>>16);

	GM_PRINT (1,("final corrected csum = 0x%08x\n", skb->csum));
    }
    else {
    	skb->ip_summed = CHECKSUM_NONE;
    	skb->csum = 0;
    }
#endif

    skb->protocol = eth_type_trans(skb,dev);
    skb->dev = dev;

    GM_PRINT (GM_PRINT_LEVEL >= 5,("%s: received packet with protocol, passed to netif_rx:0x%x,type=%d,len=%d\n",
	dev->name,ntohs(skb->protocol),skb->pkt_type,skb->len));
    GM_KLOG_EVT(GM_KLOG_RECV,skb);
    netif_rx(skb);
  }
  gmnet->stats.rx_packets += 1;

  skb = new;

 end:
  /* be sure to reset the skbuff */
  skb->tail = skb->data = skb->head;
  skb->len = 0;

  gm_assert ((gm_size_t) skb_tailroom (skb) == GM_SKB_SIZE (dev)
			   || (gm_size_t) dev->mtu != (unsigned) GM_IP_MTU);
  skb_reserve(skb,48);
  nbdesc = gmip_build_desc(skb->data,skb_tailroom(skb),desc);
  GM_KLOG_EVT(GM_KLOG_PROVIDE,skb);
  GM_PRINT (GM_PRINT_LEVEL >= 5,("receive dma ptr = 0x%08x\n",desc[0].ptr));
  _gm_provide_ethernet_scatter_list (gmnet->port,
                                     nbdesc,
                                     desc);
  gm_set_bitmap(gmnet->is, skb->data,skb_tailroom(skb),1);
  gmnet->recv_ring[index] = skb;
  gmnet->rdone += 1;
}

static
void gmip_sent_interrupt(void *gmnetp)
{
  int index;
  gm_arch_net_info_t *gmnet = gmnetp;
  struct sk_buff *skb;

  index = gmnet->sdone & GM_SEND_RING_MAX_INDEX;

  GM_PRINT (GM_PRINT_LEVEL >= 5,("gmip_sent_interrupt(%p) index = %d\n",gmnetp,index));

  if (gmnet->sreq - gmnet->sdone == 0) {
    GM_WARN (("%s: Internal error: SENT_EVENT but no skb in send_ring!??,sreq=%u,sdone=%u\n",
			  gmnet->dev->name,gmnet->sreq, gmnet->sdone));
    return;
  }
  skb = gmnet->send_ring[index];
  gm_always_assert(skb);

  if (gmnet->send_copy[index])
    GM_LOG_STAMPED_EVT(GM_ETHER_SINTR,gm_tick(),0,gm_tcp_window(skb->data,skb->len));
  else
	{
	  GM_LOG_STAMPED_EVT (GM_ETHER_SINTR, gm_tick(), 0,
						  gm_tcp_window ((char*)skb->data + 2, skb->len-2));
	}
  
  if (gmnet->send_copy[index]) {
#if GM_TRACE_LANAI_DMA		/* #if to prevent unused var warning */
    void *data = GM_DMA_ROUNDUP(ptr,gmnet->send_copy[index]);
#endif
    gm_set_bitmap(gmnet->is, skb->data,skb->len+2,0);
    kfree(gmnet->send_copy[index]);
    gmnet->send_copy[index] = 0;
  } else {
    gm_set_bitmap(gmnet->is, skb->data,skb->len,0);
  }
  dev_kfree_skb_any(skb);
  gmnet->send_ring[index] = 0;
  gmnet->sdone += 1;
  gmnet->stats.tx_packets += 1;
  if (gmnet->sreq - gmnet->sdone < GM_SEND_RING / 2) {
	netif_wake_queue(gmnet->dev);
  }
}

static int gmip_open(struct net_device *dev)
{
  gm_arch_net_info_t *gmnet = dev->priv;
  int status,err,i;

  MOD_INC_USE_COUNT;
  netif_start_queue(dev);
  
  status = gm_open(&gmnet->port, gmnet->is->id, GM_ETHERNET_PORT_ID, "ethernet", GM_API_VERSION_1_0);
  /*    myrip->gm_port = gmk_open(unit,GM_ETHERNET_PORT_ID,&myrip->gm_device); */
  if (status != GM_SUCCESS) {
	GM_NOTE (("%s:error opening GM port,status=%d\n",dev->name,status));
    err =  -EIO;
    goto error;
  }

  gmnet->sreq = 0;
  gmnet->sdone = 0;
  gmnet->rdone = 0;
  gmnet->dead = 0;
  
  gm_always_assert(GM_NUM_SEND_TOKENS > GM_SEND_RING);
  gm_always_assert(GM_NUM_ETHERNET_RECV_TOKENS > GM_RECV_RING);

  /* this must be done early because we do not want to miss an ether interrupt */
  /* the ring might not be complete, but this is ok: gmnet->rdone will be updated correctly */
  gm_ethernet_set_recv_intr_callback(gmnet->port,gmip_recv_interrupt,gmnet);
  gm_ethernet_set_sent_intr_callback(gmnet->port,gmip_sent_interrupt,gmnet);
  
  for (i=0;i<GM_RECV_RING;i++) {
    struct sk_buff *skb;
    gm_ethernet_segment_descriptor_t desc[GM_MAX_ETHERNET_SCATTER_CNT];
    int nbdesc;
    gm_always_assert(gmnet->recv_ring[i] == NULL);
    skb = alloc_skb(GM_SKB_SIZE(dev), GFP_ATOMIC);
    gm_set_bitmap(gmnet->is,skb->data,skb_tailroom(skb),1);
    if (!skb) {
      /* undo everything */
      int j;
      gm_close(gmnet->port);
      for (j=0;j<i;j++) {
        gm_set_bitmap(gmnet->is, gmnet->recv_ring[j]->data,skb_tailroom(gmnet->recv_ring[j]),0);
        dev_kfree_skb_any(gmnet->recv_ring[j]);
        gmnet->recv_ring[j] = NULL;
      }
      err = -ENOMEM;
      gmnet->port = 0;
      goto error;
    }
    gmnet->recv_ring[i] = skb;
	skb_reserve(skb,48);
    nbdesc = gmip_build_desc(skb->data,skb_tailroom(skb),desc);
    GM_PRINT (GM_PRINT_LEVEL >= 5,("receive dma ptr = 0x%08x\n",desc[0].ptr));
    _gm_provide_ethernet_scatter_list (gmnet->port,
                                       nbdesc,
                                       desc);
  }

  gm_write_lanai_special_reg_u32 (gmnet->port->kernel_port_state->instance,
								  l4.LED, 0x44444444);
  gm_tracing(gmnet->port,1);

  return 0;

 error:
  MOD_DEC_USE_COUNT;
  return err;
}

static int gmip_close(struct net_device*dev)
{
  int i;
  gm_arch_net_info_t *gmnet = (gm_arch_net_info_t *)dev->priv;
  /* suppress the interrupt handlers */
  gm_ethernet_set_recv_intr_callback(gmnet->port,0,0);
  gm_ethernet_set_sent_intr_callback(gmnet->port,0,0);
  gm_close(gmnet->port);
  gmnet->port = 0;
  /* code looks strange but overflow on gmnet->sreq and gmnet->sdone should handled correctly */
  for (i=0;i<gmnet->sreq-gmnet->sdone;i++) {
    int index = (gmnet->sdone+i)&GM_SEND_RING_MAX_INDEX;
    gm_always_assert(gmnet->send_ring[index]);
    dev_kfree_skb_any(gmnet->send_ring[index]);
    gmnet->send_ring[index] = NULL;
    gmnet->stats.tx_dropped += 1;
  }
  for (i=0;i<GM_RECV_RING;i++) 
    if (gmnet->recv_ring[i]) {
      gm_set_bitmap(gmnet->is, gmnet->recv_ring[i]->data,skb_tailroom(gmnet->recv_ring[i]),0);
      dev_kfree_skb_any(gmnet->recv_ring[i]);
      gmnet->recv_ring[i] = NULL;
    } else {
      GM_WARN(("%s: recv ring is not full at close time !!!\n"));
    }
  MOD_DEC_USE_COUNT;
  return 0;
}

static int gm_max_diff_ring = 0;

static int gmip_xmit(struct sk_buff *skb, struct net_device *dev)
{
  gm_arch_net_info_t *gmnet = dev->priv;
  struct ethhdr *eth = (struct ethhdr*)skb->data;
  void *data;
  int len;
  int index;
  int prepend;
#if GM_XMIT_CLI
  long flags;
#endif
  gm_ethernet_segment_descriptor_t desc[GM_MAX_ETHERNET_SCATTER_CNT];
  int nbdesc;

  if (!gmnet->is->lanai.running)
    goto drop;

  if  (gmnet->sreq - gmnet->sdone >= GM_SEND_RING) {
    GM_NOTE (("Send queue overflowed\n"));
    goto drop_busy;
  }
  if (skb->len > dev->mtu + ETH_HLEN + 2) {
    GM_NOTE (("%s,oops , skbuff len (%d) > mtu+hw-headers(%d)!!!??\n",
			  skb->len,dev->mtu+ETH_HLEN+2));
    goto drop;
  }

  index = gmnet->sreq & GM_SEND_RING_MAX_INDEX;
  gm_always_assert(gmnet->send_ring[index] == 0);
  gm_always_assert(gmnet->send_copy[index] == 0);
    /* Linux does not give buffer aligned on a 8 byte
       boundary, if you look at kmalloc code, I think this was
       explicitely done to annoy people, there is no reason not to provide
       this alignment, so deal with copy here if necessary */
  
  if (((long)skb->data & (GM_DMA_GRANULARITY-1)) == 2) {
    /* prepend the myrinet type */
    gm_always_assert(skb_headroom(skb) >= 2);
    *(gm_u16_t *)skb_push(skb,2) = __gm_hton_u16(GM_ETHERNET_PACKET_TYPE);
    data = skb->data;
    len = GM_DMA_ROUNDUP(u32,skb->len);
    prepend = 0;
  } else if (1 || !GM_DMA_ALIGNED(skb->data)) { /* never use prepend */
    GM_PRINT (GM_PRINT_LEVEL >= 4,("%s:kernel buffer %p  (head=%d,tail=%d,len=%d),proto=%d is not aligned, attempt to memcpy\n",
                gmnet->dev->name,skb->data,skb_headroom(skb),skb_tailroom(skb),skb->len,__gm_ntoh_u16(skb->protocol))); 
    gmnet->send_copy[index] = kmalloc(skb->len+2+GM_DMA_GRANULARITY-1,GFP_ATOMIC);
    data = GM_DMA_ROUNDUP(ptr,gmnet->send_copy[index]);
    if (!data)
      goto drop;
    memcpy((char*)data+2,skb->data,skb->len);
    *(gm_u16_t *)data = __gm_hton_u16(GM_ETHERNET_PACKET_TYPE);
    len = GM_DMA_ROUNDUP(u32,skb->len + 2);
    prepend = 0;
  } else {
    data = skb->data;
    len = GM_DMA_ROUNDUP(u32,skb->len);
    prepend = 1;
  }
  nbdesc = gmip_build_desc(data,len,desc);
  if (0 && !GM_DMA_ALIGNED(data)) {
    GM_NOTE (("%s:internal error:kernel buffer %p  is not aligned, sorry I drop the packet\n",gmnet->dev->name,data));
    goto drop;
  }
  gm_set_bitmap(gmnet->is, data,len,1);
  GM_PRINT (GM_PRINT_LEVEL >= 5,("%s:send eth pkt %p, proto=0x%x, len = %d numdesc = %d dma=0x%08x\n",
	gmnet->dev->name,skb->data,
	ntohs(skb->protocol),GM_DMA_ROUNDUP(u32,skb->len),
	nbdesc, desc[0].ptr));
#if (GM_PRINT_LEVEL >= 5)  
  gm_hex_dump(data, len);
#endif

#if GM_XMIT_CLI
  save_flags(flags);
  cli();
#endif
  /* update the send_ring before actually sending so the interrupt handler is sure to have an uptodate send_ring info */
  dev->trans_start = jiffies;
  gmnet->send_ring[index] = skb;
  atomic_inc((atomic_t *) &gmnet->sreq);
  
  /* when tracing, get in the aux field the len and the potential tcp window */
  GM_LOG_STAMPED_EVT(GM_ETHER_SND,gm_tick(),0,gm_tcp_window(data+2,len-2));
  
  if (eth->h_dest[0] & 0x01) {
    gm_ethernet_broadcast(gmnet->port,nbdesc,desc,prepend);
  } else {
    gm_ethernet_send(gmnet->port,nbdesc,desc,eth->h_dest,prepend);
  }
  
  GM_PRINT (GM_PRINT_LEVEL >= 5,("gmip_xmit - sent a packet sreq=%d sdone=%d\n",
			gmnet->sreq, gmnet->sdone));
  if ((gmnet->sreq - gmnet->sdone) > gm_max_diff_ring ) {
	gm_max_diff_ring = (gmnet->sreq - gmnet->sdone);
  }

  if (gmnet->sreq - gmnet->sdone < GM_SEND_RING) {
    /* used to catch ring overrun??? */
	netif_start_queue(dev);
  }

#ifdef XMIT_CLI
  restore_flags(flags);
#endif
  GM_KLOG_EVT(GM_KLOG_SENDEND,skb);
  return 0;
  
 drop:
  netif_start_queue(dev);
 drop_busy:
  gmnet->stats.tx_dropped += 1;
  dev_kfree_skb_any(skb);
  return 0;
}
    

static struct net_device_stats *gmip_get_stats(struct net_device *dev)
{ 
  gm_arch_net_info_t *gmnet = dev->priv;
  return &gmnet->stats; 
}

static
int gmip_dev_init(struct net_device *dev)
{
  GM_INFO (("Initialized network driver %s\n",dev->name));
  return 0;
}


static int gmip_change_mtu(struct net_device *dev, int new_mtu)
{
  int save_mtu = dev->mtu;
  
  dev->mtu = new_mtu;
  if ((new_mtu < 68) || (GM_SKB_SIZE(dev) > GM_ETHERNET_MTU))
    {
       dev->mtu = save_mtu;
       GM_NOTE (("new_mtu (%d) is not valid\n",new_mtu));
       return -EINVAL;
    }

  GM_INFO (("changing mtu from %d to %d\n",save_mtu,new_mtu));
  return 0;
}

void gmip_timeout( struct net_device *dev )
{
  gm_arch_net_info_t *gmnet = dev->priv;
  gmnet->dead = 1;  
}

/* we do not count the 2 bytes of
   myrinet type in the dev->hard_header_len, */

int gmip_init(gm_instance_state_t *is)
{
  struct net_device *dev;
  int i, err;

  dev = dev_alloc ("myri%d", &err);
  if (!dev)
    return err;

  ether_setup(dev);
  /* currently take the smallest page_size of all linux system to compute the same MTU everywhere */
  dev->mtu = GM_IP_MTU;
  gm_always_assert(dev->mtu + 2 <= GM_ETHERNET_MTU);
  dev->open = gmip_open;
  dev->stop = gmip_close;
  dev->hard_start_xmit = gmip_xmit;
  dev->get_stats = gmip_get_stats;
  dev->base_addr = is->arch.busbase;
  dev->irq = is->arch.irq;
  dev->init = gmip_dev_init;
  dev->change_mtu = gmip_change_mtu;
  dev->tx_timeout = gmip_timeout;
  dev->watchdog_timeo = HZ/10;
  
  for (i=0;i<6;i++)
    dev->dev_addr[i] = is->lanai.eeprom.lanai_board_id[i];
  
  gm_always_assert(dev->hard_header_len == 14);
  
  is->arch.net.dev = dev;
  is->arch.net.is = is;
  (gm_arch_net_info_t*)dev->priv = &is->arch.net;
  if (register_netdev(dev)) {
    GM_NOTE (("%s:register_netdev failed!!\n",dev->name));
    kfree(dev);
    return -EIO;
  }
  return 0;
}

void gmip_finalize(gm_instance_state_t *is)
{
  struct net_device *dev = is->arch.net.dev;
  unregister_netdev(dev);
  kfree(dev);
}

  
/*
  Local Variables:
  tab-width:4
  End:
*/
