/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_arch_types_h_
#define _gm_arch_types_h_

/**********************************************************************
 * This file architecture-specific types and macros needed by gm_impl.h
 **********************************************************************/

#ifndef __KERNEL__
#define __KERNEL__ 1
#endif

/* minimum linux include files to have the required types declared here */
#include <linux/version.h>
#include <linux/stddef.h>
#include <linux/tqueue.h>
#include <linux/timer.h>
#include <asm/page.h>
#include <asm/semaphore.h>
#include <asm/atomic.h>
#include <linux/errno.h>
#include <linux/if_ether.h>
#include <linux/string.h>
#include <linux/netdevice.h>

#include "gm_arch_def.h"
/* Architecture-specific type for the "arch" field of the gm_intance_state_t
   data structure. */

#define GM_ARCH_KMALLOC_REGION 1
#define GM_ARCH_VMALLOC_REGION 2
#define GM_ARCH_GFP_REGION 3

struct gm_instance_state;

typedef struct gm_arch_dma_region
{
  struct gm_instance_state *is; /* for debugging purpose */
  void *addr; /* aligned address */
  char *addr2; /* for gm_arch_dma_region_advance */
  void *alloc_addr;
  unsigned len;
  int flags;
  unsigned char type;
  unsigned char order;
} gm_arch_dma_region_t;

#define GM_SEND_RING 16	/* MUST be power of 2 */
#define GM_RECV_RING 8	/* MUST be power of 2 */
#define GM_SEND_RING_MAX_INDEX (GM_SEND_RING -1)
#define GM_RECV_RING_MAX_INDEX (GM_RECV_RING -1)
#define GM_NET_COPY_THRESHOLD 400

struct gm_port;

typedef struct  {
  struct net_device *dev; /* the network (ethernet driver) */
  struct gm_instance_state *is;
  struct gm_port *port;
  struct sk_buff *send_ring[GM_SEND_RING];
  void *send_copy[GM_SEND_RING];
  struct sk_buff *recv_ring[GM_RECV_RING];
  struct net_device_stats stats;
  int sreq;
  int sdone;
  unsigned rdone;
  int dead; /* timeout, MCP may be dead */
} gm_arch_net_info_t;

void gmip_finalize(struct gm_instance_state *is);
int gmip_init(struct gm_instance_state *is);

typedef struct gm_arch_instance_info  
{
  unsigned long busbase;
  unsigned long phys_base_addr;
  struct gm_instance_state *next;
  unsigned long interrupt; /* 1 if we are currently inside the
                              interrupt handler, 0 otherwise, this should be a long because of
                              test_and_set_bit */
  struct pci_dev *pci_dev;
  unsigned int irq;
  struct tq_struct timer_task;
  struct timer_list timer;
  gm_arch_net_info_t net;
} gm_arch_instance_info_t;

typedef struct gm_arch_port_info
{
  /*  int mode; */
  int ref_count; /* open file descriptor + mapping count */
  
} gm_arch_port_info_t;

/************
 * GM synchronization types
 ************/

#define GM_SLEEP_WOKE 0
#define GM_SLEEP_INTERRUPTED 1

/*  quite the same than Solaris */
typedef struct gm_arch_sync
{
  /* fields for mutex aquire/release */
  struct semaphore mu;
  /* fields for sleep/wake */
  atomic_t wake_cnt;
  wait_queue_head_t sleep_queue;
  struct semaphore wake_sem;
} gm_arch_sync_t;

#define USER_LOCK_DEAD 0x6598731
#define USER_LOCK_ALIVE 0x635290

#if GM_CAN_REGISTER_MEMORY
typedef struct
{
  struct gm_instance_state *is;
  /*long pagenum;*/
  struct page *page;
  int magic;
  long virt_pagenum;
  unsigned long phys;
} gm_arch_page_lock_t;
#else
typedef char gm_arch_page_lock_t;
#endif

typedef int /*minor_t*/ gm_arch_minor_t;

typedef int gm_arch_ioctl_context_t;

typedef atomic_t gm_atomic_t;
#define GM_HAS_ATOMIC_T 1

/****************************************************************
 * optional feature switches
 ****************************************************************/

#define GM_ARCH_RECV_QUEUE_UPDATE(p) _GM_ARCH_RECV_QUEUE_UPDATE (p)

#endif /* _gm_arch_types_h_ */
     
