#ifndef gm_arch_def_h
#define gm_arch_def_h

#include "gm_config.h"

/* the rules of wether passing to ioremap(alias vremap on x86 2.0) and
to remap_page_range a physical or a virtual address are quiet
intricated:
For x86 2.0 : phys = virt pas de problemes
For x86 2.1: ioremap and remap_page_range take a phys
For axp 2.0:  ioremap and remap_page_range take a virt
For axp 2.1:  ioremap take a virt and remap_page_range take a phys

There is no logic in these 4 different cases,Linux is a mess in this regard :-(
*/

/*******************************
    NOTE about virtual adresses 
We can manipulate 6 different kind of addresses:
1)User virtual addresses
2)Kernel virtual addresses
3)Kernel "canonical" address ("canonical" is not an official term, but it is what I propose)
4)Kernel non segmented address
5)Physical address for main bus
6)PCI addresses

Explanation:
1) a user address is what is used inside its processus: it is supposed here to be equivalent
 to  4) as regards conversion to physical address (but it is in a distinct range)
2) and 3) can directly be referenced in kernel mode, the difference
 is:
 - a "canonical" address is within the mapping that every Linux make
 to map the complete physical memory (and on the Alpha to map all IO
 spaces), if this is an adress representing main memory, we can get
 the physical address via  __pa, which is a translation.
 Canon addresses for real memory are guaranteed to be in the range:
 [PAGE_OFFSET;high_memory[
 - a kernel virtual address has been allocated via vmalloc, or vremap
4) A kernel non segmented address is what is feed to the MMU, it is always manipulated as
   1). In lot of cases 3) and 4) are the same, but not for Linux 2.0 x86 where segmentation  creates 
   a constant offset betweeen the two.
5) This is an address after MMU translation, it can also be obtained from 3) by translation
6) PCI addresses are adress as they are used on the PCI bus.
   The address of main memory asseen on the PCI bus is obtained by virt_to_bus.

On the ALPHA physical space is uniformly mapped at IDENT_ADDR, the
current canonical address base is PAGE_OFFSET which is currently
always equal (linux2.0->2.2), although I try not make this assumption
in the driver, I verify that through an assertion, should it be
changed, people will be aware of the fact.


virt_to_bus and __pa takes a canonical address and gives a physical address.
you cannot feed them a general kernel virtual address.
you cannot feed them an IO address

An important function of this module is kvirt_to_phys which takes
either a kernel or a user addresse (depending on boolean second
argument) and gives the corresponding physical address.

Most Linux functions are organized to manipulate canonical address:
pte_page
MAP_NR
high_memory
mk_pte

we could use elegantly canonical address (extended the concept for IO
addresses), but on 2.1 x86 __va(__pa(x)) does not map
the identity function for IO addr, Linux sucks (but still my preferred OS :-)!!!

So we manipulate physical addresses everywhere and using GM_PHYS_MAP_NR instead of MAP_NR

the memory physically begin at __pa((void*)PAGE_OFFSET), this
will be 0 in all cases I know, so a lot of assertions will convert
into ((unsigned_value) >= 0), but better to leave them (maybe in case
we want to use it on sparc64bit platforms

*******************/




#if GM_CPU_alpha
/* alpha architecture */
unsigned long (*gm_virt_to_bus)(void *addr);

/* hack: this bits in the pte of < 21264 are ignored,
   for 21264, at least the higher-one (bit 43) is necessary:  marks non-cacheable space 
   rationale: for 21164, the non-cacheable bit is included in the base address of the PCI memory region,
   for the 21264, this cannot be the case while Linux use a 41 bit KSEG (it would need a 48KSEG segment) */ 
#define GM_PAGE_CACHE 0

#define GM_PAGE_NOCACHE (1L<<(43+19))
/* hack: 
   - for 21264,  the bit 43 is necessary: it  marks non-cacheable space 
   - for 21164, the non-cacheable bit (bit 39) is included in the base address of the PCI memory region,
   - for the 21264, this unfortunately cannot be the case because Linux use a 41 bit KSEG (it would need a 48KSEG segment)
   - on 2.0 Linux will be confused finding this bit in the pte when clearing it, strange things will happen.
   - we always set the bit in linux >= 2.2, it will be ignored by 21164 harware.
*/ 
#define GM_BASE2PHYS(a) __pa(v22_dense_mem(a)+((a)&0xffffffffUL))
#endif


#if GM_CPU_x86
/* i386 architecture */

#ifndef _PAGE_PWT 
#define _PAGE_PWT   0x008
#endif

/* add in no write-combining too */
#define GM_PAGE_NOCACHE (_PAGE_PCD | _PAGE_PWT)
#define GM_PAGE_CACHE 0
#define GM_BASE2PHYS(a) (a)
#define gm_virt_to_bus virt_to_bus
#endif

#if GM_CPU_ia64
/* ia64 architecture */
#define GM_PAGE_NOCACHE _PAGE_MA_UC
#define GM_PAGE_CACHE 0
#define GM_BASE2PHYS(a) (a)
#define gm_virt_to_bus virt_to_bus
#endif

#if GM_CPU_sparc && ! defined __sparc_v9__
/* sparc32 architecture */
/* ... */
#endif

#if GM_CPU_sparc64
/* sparc64 architecture */
#define GM_PAGE_NOCACHE _PAGE_E
#define GM_PAGE_CACHE _PAGE_CACHE
#define GM_BASE2PHYS(a) (__pa(a))
#define gm_virt_to_bus virt_to_bus
#endif


#if GM_CPU_powerpc
#define GM_PAGE_NOCACHE _PAGE_NO_CACHE
#define GM_PAGE_CACHE 0
#define GM_BASE2PHYS(a) (_ISA_MEM_BASE+(a))
#define gm_virt_to_bus virt_to_bus
#endif

#define REMAPARG(x) (x)

#define GM_MM_FAULT(task, vma, ptr, write) handle_mm_fault(task, vma, ptr, write)


#include "gm_hybrid_mod.h"


#endif /* gm_arch_def_h */
