#ifndef _linux20_h
#define _linux20_h


#ifndef LINUX_VERSION_CODE
#  include <linux/version.h>
#endif

#ifndef VERSION_CODE
#  define VERSION_CODE(vers,rel,seq) ( ((vers)<<16) | ((rel)<<8) | (seq) )
#endif

#if LINUX_VERSION_CODE < VERSION_CODE(2,1,0)
#define LINUX_20
#define LINUX_XX 20
/* Need to implement this part for 2.0 compatibility. */
#elif LINUX_VERSION_CODE < VERSION_CODE(2,3,0)

#define LINUX_22
#define LINUX_XX 22

#if LINUX_VERSION_CODE < VERSION_CODE(2,2,0)   /* less than 2.2.0 */
/* This has not been tested yet. Sorry. */
#warning "You're on your own between 2.1.0 and 2.2.0.... "
#warning "Please use 2.2.0 or higher."
#endif

#else

#define LINUX_24
#define LINUX_XX 24

#endif /* LINUX_VERSION */


#ifdef LINUX_20

#include <linux/kernel.h>

#if defined __alpha__ || defined __i386__
#define cpu_to_le32(a) (a)
#else
#error cannot define cpu_to_le32 for your arch
#endif


#  define v22_put_user(val,add)           (put_user((val),(add)), 0)
#define v22_get_user(a,b)         ((a) = get_user(b),0)
#define copy_from_user(a,b,c) memcpy_fromfs(a,b,c)
#define copy_to_user(a,b,c)   memcpy_tofs(a,b,c)
//#define queue_task            queue_task_irq_off
//#define memcpy_fromio        memcpy
#define pci_present           pcibios_present
//#define pci_find_device       pcibios_find_device
#define MODULE_PARM(a,b) 
#define MODULE_PARM_DESC(v,t)
#define MODULE_AUTHOR(n)
#define MODULE_DESCRIPTION(d)
#define MODULE_SUPPORTED_DEVICE(n)

#define release_t void
#define release_return(x) return

//#include <asm/bitops.h>
#include <linux/pci.h>
#include <linux/bios32.h>
#include <linux/types.h>

#  define test_and_set_bit(nr,addr)  set_bit((nr),(addr))
#  define test_and_clear_bit(nr,addr) clear_bit((nr),(addr))
#  define test_and_change_bit(nr,addr) change_bit((nr),(addr))


#define tty_flip_buffer_push(tty) queue_task_irq_off(&(tty)->flip.tqueue, &tq_timer);

typedef struct v22_pci_dev {
  unsigned index;
  unsigned busnum;
  struct {
    unsigned number;
  } *bus;
  unsigned devfn;
  unsigned irq;
  unsigned long base_address[6];
} v22_pci_dev;

#define V22_MAX_FIND_DEVICE 10

v22_pci_dev *v22_pci_find_device(unsigned int vendor, unsigned int device, v22_pci_dev *from);


static int
v22_pci_read_config_byte(v22_pci_dev *dev, unsigned char where, unsigned char *val)
{
	return pcibios_read_config_byte(dev->busnum, dev->devfn, where, val);
}

static int
v22_pci_read_config_word(v22_pci_dev *dev, unsigned char where, unsigned short int *val)
{
	return pcibios_read_config_word(dev->busnum, dev->devfn, where, val);
}

static int
v22_pci_read_config_dword(v22_pci_dev *dev, unsigned char where, unsigned int *val)
{
	return pcibios_read_config_dword(dev->busnum, dev->devfn, where, val);
}

static int
v22_pci_write_config_byte(v22_pci_dev *dev, unsigned char where, unsigned char val)
{
	return pcibios_write_config_byte(dev->busnum, dev->devfn, where, val);
}

static int
v22_pci_write_config_word(v22_pci_dev *dev, unsigned char where, unsigned short int val)
{
	return pcibios_write_config_word(dev->busnum, dev->devfn, where, val);
}

static int
v22_pci_write_config_dword(v22_pci_dev *dev, unsigned char where, unsigned int val)
{
	return pcibios_write_config_dword(dev->busnum, dev->devfn, where, val);
}

#define  pci_read_config_byte v22_pci_read_config_byte
#define  pci_read_config_word v22_pci_read_config_word
#define  pci_read_config_dword v22_pci_read_config_dword
#define  pci_write_config_byte v22_pci_write_config_byte
#define  pci_write_config_word v22_pci_write_config_word
#define  pci_write_config_dword v22_pci_write_config_dword
#define pci_find_device v22_pci_find_device



#ifdef __i386__


void* v22_ioremap_flags(long iobase,long size,long flags);

#define v22_ioremap(a,b) v22_ioremap_flags((a),(b),_PAGE_PCD)
#define v22_ioremap_cache(a,b) v22_ioremap_flags((a),(b),0)
#define v22_iounmap vfree

#elif defined __alpha__
#define v22_ioremap(a,b) __va(a)
#define v22_iounmap(a) /* no-op */
#endif

struct task_struct;
struct wait_queue;

int signal_pending(struct task_struct *p);

static void sigfillset(unsigned long *mask)
{
  *mask = ~0L;
}

long interruptible_sleep_on_timeout(struct wait_queue ** p, long timeout);

long sleep_on_timeout(struct wait_queue ** p, long timeout);


long schedule_timeout(signed long timeout);



#define capable(a) suser()

#ifdef __alpha__
extern unsigned long v22_dense_mem(unsigned long a);
#endif

#define atomic_read(v)		(*(v))
#define atomic_set(v,i)		(*(v) = (i))

#define v22_get_free_pages(a,b) __get_free_pages((a),(b),(0))
#define dev_kfree_skb_any(a) dev_kfree_skb((a),FREE_WRITE)
#define dev_kfree_skb_irq(a) dev_kfree_skb((a),FREE_WRITE)

#define VMALLOC_END (VMALLOC_START+32*1024*1024)

#define __pa(x)			((unsigned long) (x) - PAGE_OFFSET)
#define __va(x)			((void *)((unsigned long) (x) + PAGE_OFFSET))

#define pgd_offset_k(a) pgd_offset(v22_get_current()->mm,(a))

struct task_struct * v22_get_current(void);

#define in_interrupt() (intr_count!=0)

#else /* LINUX_XX >= 22 */

#include <asm/uaccess.h>


#define v22_get_user  get_user
#define v22_put_user put_user
#define v22_pci_dev pci_dev

#define release_t int
#define release_return(x) return (x)


#ifdef __alpha__
extern unsigned long v22_dense_mem(unsigned long a);
#endif

#define v22_iounmap iounmap

#ifdef __alpha__
#define v22_ioremap(a,len) __va(a)
#undef v22_iounmap
#define v22_iounmap(a) /*noop*/
#elif defined __i386__
#define v22_ioremap ioremap_nocache
#define v22_ioremap_cache ioremap
#elif defined __ia64__
#define v22_ioremap ioremap_nocache
#define v22_ioremap_cache ioremap
#elif defined __sparc_v9__
#define v22_ioremap ioremap
#elif defined __powerpc__
void* v22_ioremap(long physbase,long size);
#undef v22_iounmap
#define v22_iounmap vfree
#endif

#define v22_get_free_pages(a,b) __get_free_pages((a),(b))

#endif

#if LINUX_XX < 24

#include <linux/pci.h>

#define dev_kfree_skb_any(a) dev_kfree_skb(a)
#define dev_kfree_skb_irq(a) dev_kfree_skb(a)

typedef struct wait_queue *wait_queue_head_t;

#define virt_to_page(a) (mem_map+MAP_NR(a))

struct pci_device_id {
	unsigned int vendor, device;		/* Vendor and device ID or PCI_ANY_ID */
	unsigned int subvendor, subdevice;	/* Subsystem ID's or PCI_ANY_ID */
	unsigned int class, class_mask;		/* (class,subclass,prog-if) triplet */
	unsigned long driver_data;		/* Data private to the driver */
};

#define PCI_ANY_ID (~0)

#define VXX_MAX_DEV_PER_DRIVER 16
struct pci_driver {
	char *name;
	const struct pci_device_id *id_table;	/* NULL if wants all devices */
	int (*probe)(struct v22_pci_dev *dev, const struct pci_device_id *id);	/* New device inserted */
	void (*remove)(struct v22_pci_dev *dev);	/* Device removed (NULL if not a hot-plug capable driver) */
	struct v22_pci_dev *devs[VXX_MAX_DEV_PER_DRIVER];
};

#define DECLARE_WAITQUEUE(a,b) struct wait_queue a = { (b) , 0}

#define pci_dev_driver_data(d) ((void*)(d)->base_address[5])

#define vma_private_data(v) ((void*)(v)->vm_pte)

#define v24_mem_map_reserve(a) set_bit(PG_reserved, &(a)->flags)
#define v24_mem_map_unreserve(a) clear_bit(PG_reserved, &(a)->flags)
#define init_waitqueue_head(a) init_waitqueue(a)
#define init_MUTEX(s) do { *(s) = MUTEX; } while (0)
#define pci_resource_start(pdev,i) ((pdev)->base_address[i] & PCI_BASE_ADDRESS_MEM_MASK)

#define module_init(x)	int init_module(void) { return x(); }
#define module_exit(x)	void cleanup_module(void) { x(); }

#define vma_get_pgoff(vma) ((vma)->vm_offset / PAGE_SIZE)

int pci_module_init(struct pci_driver *);
void pci_unregister_driver(struct pci_driver *);

#if 0
#define page_address(a) (((a)-mem_map)*PAGE_SIZE+PAGE_OFFSET)
#endif

#define THIS_MODULE (&__this_module)

#define netif_wake_queue(dev) do { (dev)->tbusy = 0;mark_bh(NET_BH); } while (0)
#define netif_start_queue(dev) do { (dev)->tbusy = 0; } while (0)
#define netif_stop_queue(dev) {}

#define dev_start(a,b) do { (a)->start = (b) ; } while (0)

#define net_device_stats enet_statistics

#define net_device device

struct net_device * v24_dev_alloc(char *s,int *err, int num);

#else

#define pci_dev_driver_data(d) ((d)->driver_data)

#define vma_private_data(v) ((v)->vm_private_data)

#define v24_mem_map_reserve mem_map_reserve
#define v24_mem_map_unreserve mem_map_unreserve

#define dev_start(a,b)

#define v24_dev_alloc(s,err,num) dev_alloc(s,err)

#define vma_get_pgoff(vma) ((vma)->vm_pgoff)

#endif


#endif /* linux20.h */

