#if GM_SMPHACKS

#define GM_INSIDE_SMP_DEFS 1

#include "gm_arch_def.h"
#if defined(__ASM_SMP_H) 
#error renaming apic_reg will not work if asm/smp.h is already included in gm_internal.h
#endif

#ifdef __SMP__
#define gm_this_ops gm_smp_ops
/* this one should be before the inline func that use it */
#define apic_reg gm_apic_reg
#else
#define gm_this_ops gm_uni_ops
#endif

#include <linux/smp.h>
#include <linux/sched.h>
#include <asm/semaphore.h>
#include <linux/mm.h>

#define smp_flush_tlb gm_smp_flush_tlb /* used in page.h */
#include <asm/page.h>
#include <asm/pgtable.h>

#ifdef __SMP__
/* hopefully our only use of cpu_data is in delay.h */
#define cpu_data gm_cpu_data
#endif

#include <linux/delay.h>





static struct task_struct *this_current(void)
{
  return current;
}

static void this_down(struct semaphore * sem)
{
  down(sem);
}

static void this_up(struct semaphore * sem)
{
  up(sem);
}

static void this_udelay(unsigned long usecs)
{
  udelay(usecs);
}
static void this_flush_tlb_page(struct vm_area_struct *vma, unsigned long page)
{
  flush_tlb_page(vma,page);
}


struct gm_arch_ops gm_this_ops = {
  this_current,
  this_down,
  this_up,
  this_udelay,
  this_flush_tlb_page
};






#endif
