#ifndef _gm_hybrid_mod_h
#define _gm_hybrid_mod_h


#if GM_SMPHACKS

struct vm_area_struct;

extern struct gm_arch_ops {
  struct task_struct *(*op_current)(void);
  void (*op_down)(struct semaphore *);
  void (*op_up)(struct semaphore *);
  void (*op_udelay)(unsigned long usecs);
  void (*op_flush_tlb_page)(struct vm_area_struct *vma, unsigned long page);
} gm_uni_ops,gm_smp_ops,gm_ops;

/* in gm_smp.o we arrange to use these variable instead of the original ones */
extern unsigned char *gm_apic_reg;
extern struct cpuinfo_x86 *gm_cpu_data;

#define gm_udelay (gm_ops.op_udelay)
#define gm_current (gm_ops.op_current())
#define gm_down (gm_ops.op_down)
#define gm_up (gm_ops.op_up)
#define gm_flush_tlb_page (gm_ops.op_flush_tlb_page)
void gm_init_smphacks(void);

#else /* GM_SMPHACKS */
#define gm_udelay udelay
#define gm_current current
#define gm_down down
#define gm_up up
#define gm_flush_tlb_page flush_tlb_page
#define gm_init_smphacks()
#endif /* GM_SMPHACKS */


#endif
