#error This file is no longer maintained.  --Glenn

#if 0
gm_status_t
gm_dev_to_port_state (dev_t dev, gm_port_state_t ** psp)
{
  NOT_IMP;
  return -1;
}
#endif


/* this stuff now done in gm_instance.c - FIXME: make sure it all is */
#if 0

/* Copy the eeprom for a device, and use the info therein to map the
   control registers, special registers, and SRAM for a device. */
gm_status_t
gm_map_pci (gm_instance_state_t *is, unsigned int board_base)
{
  int unit = is->id;
  gm_myrinet_eeprom_t *eeprom_ptr = NULL;
   
  START;
  
  /*
   * only type supported by Linux
   */
  is->ifc_type = GM_MYRINET_BUS_PCI;

  /*
   * first map the EEPROM
   */
  eeprom_ptr = (gm_myrinet_eeprom_t *)
    ioremap (board_base + GM_PCI_EEPROM_OFFSET, GM_PCI_EEPROM_LEN);

  if (!eeprom_ptr) {
    GM_NOTE (("Ioremap of eeprom space failed.\n"));
    goto abort_with_nothing;
  }

  gm_arch_copy_eeprom (eeprom_ptr, &is->lanai.eeprom);

  iounmap (eeprom_ptr);

  /* Check for old, out-of-date board. */
  if (is->lanai.eeprom.lanai_cpu_version < gm_lanai_4_0) {
    GM_NOTE (("Pre-LANai4.0 boards not supported."));
    goto abort_with_nothing;
  }
  
  /* Check that the LANai SRAM size agrees with header files */
  if (is->lanai.eeprom.lanai_sram_size < GM_LANAI_MEM_LEN) {
    GM_NOTE (("LANai has less than 0x%x bytes of SRAM.\n"
	      "LANai has 0x%x bytes of SRAM.\n",
	      GM_LANAI_MEM_LEN,
	      is->lanai.eeprom.lanai_sram_size));
    goto abort_with_nothing;
  }

  /* Map the control registers.  */
  if (!(is->lanai.control_regs = (gm_s16_t *)
	ioremap (board_base + GM_PCI_CONTROL_REGS_OFFSET, GM_PAGE_LEN))) {
    GM_NOTE (("Control register mapping failed for unit %d",
		 unit));
    goto abort_with_nothing;
  }
  
  GM_PRINT (GM_PRINT_LEVEL >= 3, ("[%d]: new-board: mapped in %d bytes for CONTROL\n",
		unit, GM_PAGE_LEN));
  GM_PRINT (GM_PRINT_LEVEL >= 3, ("[%d]: CONTROL[0] looks like \"0x%04x\"\n",
		unit, *(unsigned short *) is->lanai.control_regs));
  GM_PRINT (GM_PRINT_LEVEL >= 3, ("[%d]: CONTROL[1] looks like \"0x%04x\"\n",
		unit, *((unsigned short *) is->lanai.control_regs+1)));

  /* Map the special registers. */
  if (!(is->lanai.special_regs = (gm_lanai_special_registers_t *)
	ioremap (board_base + GM_PCI_SPECIAL_REGS_OFFSET, GM_PAGE_LEN))) {
    GM_NOTE (("Special register mapping failed for unit %d",
		 unit));
    goto abort_with_control_regs;
  }

  GM_PRINT (GM_PRINT_LEVEL >= 3, ("[%d]: new-board: mapped in %d bytes for SPECIAL\n",
		unit, GM_PAGE_LEN));

  /* Map the LANai SRAM. */
  {
    gm_hup_t sram_base_addr;
    
    if (is->lanai.eeprom.lanai_sram_size == (1024*1024)) {
      sram_base_addr = GM_PCI_MEMORY2_OFFSET;
    } else {
      sram_base_addr = GM_PCI_MEMORY_OFFSET;
    }

    /* BAD HACK FIXME: clip sram until the MCP can make use of different
       memory sizes */
    is->lanai.eeprom.lanai_sram_size = GM_LANAI_MEM_LEN;
    
    GM_PRINT (GM_PRINT_LEVEL >= 3, ("sram base addr = 0x%lx\n", sram_base_addr));
    
    if (!(is->lanai.sram = (caddr_t *)
	  ioremap (board_base + sram_base_addr, is->lanai.eeprom.lanai_sram_size))) {
      GM_NOTE (("SRAM mapping failed for unit %d",
		   unit));
      goto abort_with_special_regs;
    }
    GM_PRINT (GM_PRINT_LEVEL >= 3, ("[%d]: new-board: mapped in %d bytes for SRAM\n",
		  unit, is->lanai.eeprom.lanai_sram_size));
  }    

  RETURN (GM_SUCCESS);
  
abort_with_sram:
  iounmap (is->lanai.sram);
abort_with_special_regs:
  iounmap (is->lanai.special_regs);
abort_with_control_regs:
  iounmap (is->lanai.control_regs);
abort_with_nothing:
  RETURN (GM_FAILURE);
}

void
gm_unmap_pci (gm_instance_state_t *is)
{
  iounmap (is->lanai.sram);
  iounmap (is->lanai.special_regs);
  iounmap (is->lanai.control_regs); 
}

gm_status_t
gm_map (gm_instance_state_t *is, unsigned int board_base)
{
  int x = gm_map_pci (is, board_base);
  GM_PRINT (GM_PRINT_LEVEL >= 5, ("gm_map_pci() returned %d\n", x));
  return x;
}

/* Undo gm_map () */

void
gm_unmap (gm_instance_state_t * is)
{
  gm_unmap_pci (is);
}

gm_status_t
gm_init_sw (struct device *dev)
{
  gm_instance_state_t *is = (gm_instance_state_t *) dev->priv;
  
  START;
  
  ASSERT (is->lanai.control_regs);
  ASSERT (is->lanai.special_regs);
  
  /* Make device quiescent. */
  
  gm_reset_on (is);
  gm_disable_interrupts (is);

  gm_kton_32 (is, &is->lanai.special_regs->EIMR, 0);
  GM_STBAR ( );
  is->lanai.running = 0;

  if (gm_ntok (is, &is->lanai.special_regs->EIMR) != 0) {
    GM_NOTE (("EIMR != 0\n"));
    RETURN (GM_FAILURE);
  }
  
  /* register an interrupt handler */
  
  if (request_irq (dev->irq,
		   (void *) gm_linux_intr,
		   SA_SHIRQ,
		   dev->name,
		   dev)) {
    GM_NOTE (("Couldn't allocate IRQd\n", dev->irq));
    RETURN (GM_FAILURE);
  }

  GM_PRINT (GM_PRINT_LEVEL >= 3, ("Requested IRQ%d correctly allocated\n", dev->irq));

#if 0
  /*** Initialize mutex's */

  /* FIXME: this is done in gm_instance now */

  gm_arch_sync_init (&is->pause_sync);
  gm_arch_sync_init (&is->daemon_rqst_q.may_rqst_sync);
  gm_arch_sync_init (&is->daemon_rqst_q.rqst_sync);
  gm_arch_sync_init (&is->page_hash.sync);
  gm_arch_sync_init (&is->total_buffer_pages_sync);

  GM_PRINT (GM_PRINT_LEVEL >= 3, ("initialized mutexes\n"));
#endif
  
  /* Create /devices/gm* */
  
  if (register_chrdev (GM_MAJOR, "gm", &gm_linux_file_ops)) {
    GM_NOTE (("failed to allocate a major number"));
    goto abort_with_interrupt_handler;
  }
  
  GM_PRINT (GM_PRINT_LEVEL >= 3, ("registered a character device\n"));

  /* Set the board clock value. */

  gm_kton_32 (is, &is->lanai.special_regs->clock_val,
	      is->lanai.eeprom.lanai_clockval);

  GM_STBAR ( );

  /* Clear the LANai SRAM *EXCEPT* for the hash table pieces at the end of
     memory. */

  bzero (is->lanai.sram, GM_LANAI_MEM_LEN - GM_PAGE_HASH_PIECE_REF_TABLE_LEN);

  /* FIXME: we don't know how to determine the number of physical pages
     on the machine from the kernel, so we pick a value that users are
     not likely to allocate more than. */
  is->num_host_phys_pages = GM_MAX_BUFFER_PAGES;

  /* Now that we know the number of host physical pages, allocate the
     page hash table. */

  GM_PRINT (GM_PRINT_LEVEL >= 3, ("about to alloc hash table\n"));

  if (gm_alloc_page_hash_table (is) != GM_SUCCESS)
    goto abort_with_minor_nodes;  
  
  {
    /* Decide which MCP to use. */
    
    unsigned gm_control_program_length;
    char *gm_control_program;
    int max_mcp_len;
    
    switch (GM_PAGE_LEN) {
    case 4096:
      gm_control_program = gm_control_program_4k;
      gm_control_program_length = gm_control_program_4k_length;
      GM_PRINT (GM_PRINT_LEVEL >= 3, ("loading MCP for 4Kb pages\n"));
      break;
    case 8192:
      gm_control_program = gm_control_program_8k;
      gm_control_program_length = gm_control_program_8k_length;
      GM_PRINT (GM_PRINT_LEVEL >= 3, ("loading MCP for 8Kb pages\n"));
      break;
    default:
      GM_NOTE (("oops: bogus GM_PAGE_LEN\n"));
      goto abort_with_hash_table;
    }
    
    max_mcp_len =
      GM_LANAI_MEM_LEN
      - GM_PAGE_LEN * GM_NUM_PORTS	/* ports */
      - GM_PAGE_LEN		/* Activation page */
      - GM_PAGE_HASH_PIECE_REF_TABLE_LEN	/* hash piece pointers */
      - 4096; /* stack */ 
    
    GM_PRINT (GM_PRINT_LEVEL >= 3, ("About to load MCP.\n"));
    
#ifdef USE_ZLIB
    {
      /* Load a compressed MCP - see zlib.h for
	 details */
      
      z_stream zs;
      
      zs.zalloc = gm_zlib_calloc;
      zs.zfree = gm_zlib_free;
      zs.opaque = 0;
      
      if (inflateInit (&zs) != Z_OK) {
	GM_NOTE (("fatal error in inflateInit\n"));
	goto abort_with_hash_table;
      }
      
      zs.next_in = gm_control_program;
      zs.avail_in = gm_control_program_length;
      
      zs.next_out = is->lanai.sram;
      zs.avail_out = max_mcp_len;
      
      if (inflate (&zs, Z_FINISH) != Z_STREAM_END) {
	GM_NOTE (("fatal error in inflate\n"));
	goto abort_with_hash_table;
      }
      
      gm_always_assert (zs.avail_in == 0);
      gm_always_assert (zs.avail_out != 0);
      
      if (inflateEnd (&zs) != Z_OK) {
	GM_NOTE (("fatal error in inflateEnd\n"));
	goto abort_with_hash_table;
      }
      
      GM_PRINT (GM_PRINT_LEVEL >= 3, ("Inflated mcp from %ld to %ld bytes.\n",
		    gm_control_program_length, zs.total_out));
    }
#else
    /* Load an uncompressed MCP. */
    
    if (gm_control_program_length > max_mcp_len)
      {
	GM_NOTE (("oops: LANai control program too big.\n"));
	goto abort_with_hash_table;
      }
    
    bcopy (gm_control_program, is->lanai.sram, gm_control_program_length);
#endif 
  }
  
  gm_always_assert (gm_ntok_32 (is, &is->lanai.special_regs->EIMR) == 0); 
  
  /* Take the LANai out of reset */
  
  gm_reset_off (is);
  
  GM_PRINT (GM_PRINT_LEVEL >= 3, ("Waiting for MCP to initialize.\n"));
  
  /* Wait for the LANai control program to initialize itself. */
  
  while (!(gm_ntok_32 (is, &is->lanai.special_regs->ISR) & GM_HOST_SIG_BIT))
    {
      /* BAD: Need to watch the time here. */
      ;
    }
  
  GM_PRINT (GM_PRINT_LEVEL >= 3, ("MCP is initialized.\n"));
  
  /* Record pointer to LANai globals */
  
  is->lanai.globals = is->lanai.sram +
    gm_ntok_32 (is, &is->lanai.special_regs->SMP);
  is->lanai.running = 1;

  /* Now that we know where the LANai globals are, set those that must be 
     set by the host. */

  is->lanai.globals->page_hash.bogus_sdma_ptr = gm_htonl
    (kvirt_to_bus (is->page_hash.bogus_sdma_region.addr));
  is->lanai.globals->page_hash.bogus_rdma_ptr = gm_htonl
    (kvirt_to_bus (is->page_hash.bogus_rdma_region.addr));
  is->lanai.globals->dma_sts = gm_htonl (is->page_hash.dma_region.sts);
  
  GM_PRINT (GM_PRINT_LEVEL >= 3, ("STS = %d\n", is->page_hash.dma_region.sts));
  
  /* Tell the LANai that initialization is done.  Also, clear all ISR
     bits that might cause an interrupt. */
  
  gm_kton_32 (is, &is->lanai.special_regs->ISR, GM_HOST_SIG_BIT);
  
  /* Clear the host sig bit. */
  
  gm_kton_32 (is, &is->lanai.special_regs->EIMR, GM_HOST_SIG_BIT); 
  GM_STBAR ( );

  /* Enable interrupts */
  
  gm_enable_interrupts (is);
  
  /* Clear the host sig bit. */
  
  gm_kton_32 (is, &is->lanai.special_regs->EIMR, GM_HOST_SIG_BIT); 
  GM_STBAR ( );
  
  /* Report attachment */  
  GM_PRINT (GM_PRINT_LEVEL >= 3, ("Reported attachment.  Done.\n"));

  RETURN (GM_SUCCESS);
  
  /********************* Error handling */

abort_with_hash_table:
  gm_free_page_hash_table (is);
  
abort_with_minor_nodes:
  /* Remove all minor nodes */
  unregister_chrdev (GM_MAJOR, "gm");

abort_with_interrupt_handler:
  free_irq (dev->irq, dev);

abort_with_mutexes:
  /* FIXME: this is done in gm_instance now */

  /*
  gm_arch_sync_destroy (&is->total_buffer_pages_sync);
  gm_arch_sync_destroy (&is->page_hash.sync);
  gm_arch_sync_destroy (&is->daemon_rqst_q.rqst_sync);
  gm_arch_sync_destroy (&is->daemon_rqst_q.may_rqst_sync);
  gm_arch_sync_destroy (&is->pause_sync);
  */

abort_with_register_mappings:
  gm_unmap (is);

  RETURN (GM_FAILURE);
}

#endif /* obsolete code */

