/*
  $Id: gx.c,v 1.18 2000/12/20 23:53:39 maxstern Exp $

  ifnet driver for gm/irix
*/

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/sysmacros.h>
#include <sys/cmn_err.h>
#include <sys/debug.h>
#include <sys/hwgraph.h>
#include <sys/iograph.h>
#include <sys/errno.h>
#include <sys/PCI/pciio.h>
/*#include <sys/idbgentry.h>*/
#include <sys/tcp-param.h>
#include <sys/mbuf.h>   
#include <sys/immu.h>
#include <sys/sbd.h>
#include <sys/kmem.h>
#include <sys/cpu.h>
#include <sys/invent.h>
#include <net/if.h>
#include <net/if_types.h>
#include <net/netisr.h>
#include <netinet/if_ether.h>
#include <net/raw.h>
#include <net/multi.h>
#include <netinet/in_var.h>
#include <net/soioctl.h>
#include <sys/dlsap_register.h>

/* The IRIX man page intro(D5) says this header file "must always be   */
/* the last header file included":                                     */
#include <sys/ddi.h>       /* DDI driver stuff                         */

#include "gm_debug.h"		/* for GM_STATIC */
#include "gx.h"
#include "gm_arch_local.h"

#if GM_IRIX_DEBUG_MEMLEAKS
extern struct gm_irix_mld gm_irix_mld_struct;
#endif

#define INSIST 1

/**********************************************************************
 *
 * Set this flag to 1 to enable the use of ether_input() and ether_output()
 * instead of gx_input and gx_if_output.
 *
 * As of now, we are not doing this.   2000/06/01  - Max
 *
 **********************************************************************/

#define USE_NEW_ETHER_INTERFACE 0


/**********************************************************************
 *
 * Set this flag to 1 to enable the use of arpresolve() instead of
 * the old ip_arpresolve() protocol.
 *
 **********************************************************************/

#define USE_NEW_ARPRESOLVE 1


/**********************************************************************
 *
 * Set this flag to 1 to hack up the _arpcom.ac_ipaddr value if the
 * system returns a 0 value.
 *
 **********************************************************************/

#define HACK_IFADDR 1


#if (GM_DEBUG && GM_IRIX_DEBUG_IP)
#define GM_IRIX_DISPLAY_GXDEVICE 1
#else
#define GM_IRIX_DISPLAY_GXDEVICE 0
#endif

#if (GM_IRIX_DISPLAY_GXDEVICE && (GM_PRINT_LEVEL > 0))
#define GM_IRIX_DISPLAY_ARPCOM 1
#define GM_IRIX_DISPLAY_IFNET 1
#define GM_IRIX_DISPLAY_MBUF 1
#define GM_IRIX_DISPLAY_QUEUE 1
#else
#define GM_IRIX_DISPLAY_ARPCOM 0
#define GM_IRIX_DISPLAY_IFNET 0
#define GM_IRIX_DISPLAY_MBUF 0
#define GM_IRIX_DISPLAY_QUEUE 0
#endif


#define ALIGNED(addr, alignment)    (((u_long)(addr) & (alignment-1)) == 0)

u_int8_t  gx_broadcast_address[6] = {0xff,0xff,0xff,0xff,0xff,0xff};

#define GX_BROADCAST(a)(0 == bcmp((char*)(a), (char*)&gx_broadcast_address, 6))
#define IFF_ALIVE  (IFF_UP | IFF_RUNNING)

static gx_Device*gx_devices[GX_MAX_DEVICES];

extern vertex_hdl_t gm_irix_get_vertex (gm_port_t*p);
extern gm_boolean_t gm_irix_port_use_A64_dma(gm_port_t*p);
#if GM_IRIX_DISPLAY_MBUF
void gx_printMbuf (struct mbuf*m, char *theComment);
#endif
int gx_isEmpty (gx_Queue*q);
int gx_put (gx_Queue*q, gx_Item*p);
gx_Item*gx_get (gx_Queue*q);
gx_Item*gx_newItem (gx_Device*d, int size);
void gx_freeItem (gx_Item*p);
void gx_dfun (struct mbuf*m);
void gx_ffun (struct mbuf*m);
gx_Item*gx_newMbufItem (gx_Device*d, gx_Item*p);
int gx_feedGm (gx_Device*d);
gx_Device*gx_newDevice (struct gm_port *thePort);
void gx_freeDevice (gx_Device*d);
int gx_detach (int unit);
int gx_open (gx_Device*d);
int gx_attach (int unit);
int gx_close (gx_Device*d);
int gx_send (gx_Device*d, struct mbuf*m);
void gx_sendDone (gx_Device*d);
void gx_receiveDone (gx_Device*d, unsigned length, gm_u16_t csum);
int gx_if_ioctl (struct ifnet*ifp, int command, void* data);
#if USE_NEW_ETHER_INTERFACE
/* HACK -- we don't seem to have access to an appropriate IRIX header file */
extern void ether_input(struct etherif *eif, int snoopflags, struct mbuf *m);
extern int  ether_output(struct ifnet    *ifp, struct mbuf    *m0,
                         struct sockaddr *dst, struct rtentry *rte);
#else
void gx_input (gx_Device *d, struct mbuf*m, int length);
int  gx_if_output (struct ifnet    *ifp, struct mbuf    *m0,
                   struct sockaddr *dst, struct rtentry *rte);
#endif
static int gx_if_reset (int a, int b);
static void gx_if_watchdog (struct ifnet *ifp);

/*
#undef IFNET_LOCK
#undef IFNET_UNLOCK

#define IFNET_LOCK(a)
#define IFNET_UNLOCK
*/

#if GM_PRINT_LEVEL > 0
#define GM_GX_ANNOUNCE_FUNCTION(name) \
  GM_PRINT (1, ("Function gx.c:" # name "() entry\n"));
#define GM_GX_ANNOUNCE_VRETURN(name) \
  GM_PRINT (1, ("Function gx.c:" # name "() returning\n")); \
  return;
#define GM_GX_ANNOUNCE_RETURN(name, retval) \
  GM_PRINT (1, ("Function gx.c:" # name "() returning %d\n", retval)); \
  return(retval);
#define GM_GX_ANNOUNCE_XRETURN(name, retval) \
  GM_PRINT (1, ("Function gx.c:" # name "() returning 0x%x\n", retval)); \
  return(retval);
#else
#define GM_GX_ANNOUNCE_FUNCTION(name)
#define GM_GX_ANNOUNCE_VRETURN(name) return;
#define GM_GX_ANNOUNCE_RETURN(name, retval) return(retval);
#define GM_GX_ANNOUNCE_XRETURN(name, retval) return(retval);
#endif

#define GX_DETECT_FLAG(flagval)                 \
     if (flags_copy & ( flagval ))              \
     {                                          \
        _GM_PRINT (1, ("    " # flagval "\n")); \
        flags_copy &= ~( flagval );             \
     }



#if GM_IRIX_DEBUG_IP
GM_STATIC char *gx_decodeIoctl(int theCommand)
{
   switch (theCommand)
   {
     case SIOCSIFADDR:
	return "SIOCSIFADDR";

     case SIOCSIFFLAGS:
        return "SIOCSIFFLAGS";

     default:
        return "<**unexpected**>";
   }
}
#endif


#if GM_IRIX_DISPLAY_MBUF
void gx_printBuf (char*p, int length, char *theComment)
{
  int  i,j;
  char lblpart[20],
       hexpart[100],
       chrpart[100];
  char ht[768] =
  " 0\0 1\0 2\0 3\0 4\0 5\0 6\0 7\0 8\0 9\0 a\0 b\0 c\0 d\0 e\0 f\0"
/* Avoid octal encodings, which begin with \00 .. \07                */
  "10\0""11\0""12\0""13\0""14\0""15\0""16\0""17\0"
  "18\0""19\0""1a\0""1b\0""1c\0""1d\0""1e\0""1f\0"
  "20\0""21\0""22\0""23\0""24\0""25\0""26\0""27\0"
  "28\0""29\0""2a\0""2b\0""2c\0""2d\0""2e\0""2f\0"
  "30\0""31\0""32\0""33\0""34\0""35\0""36\0""37\0"
  "38\0""39\0""3a\0""3b\0""3c\0""3d\0""3e\0""3f\0"
  "40\0""41\0""42\0""43\0""44\0""45\0""46\0""47\0"
  "48\0""49\0""4a\0""4b\0""4c\0""4d\0""4e\0""4f\0"
  "50\0""51\0""52\0""53\0""54\0""55\0""56\0""57\0"
  "58\0""59\0""5a\0""5b\0""5c\0""5d\0""5e\0""5f\0"
  "60\0""61\0""62\0""63\0""64\0""65\0""66\0""67\0"
  "68\0""69\0""6a\0""6b\0""6c\0""6d\0""6e\0""6f\0"
  "70\0""71\0""72\0""73\0""74\0""75\0""76\0""77\0"
  "78\0""79\0""7a\0""7b\0""7c\0""7d\0""7e\0""7f\0"
  "80\081\082\083\084\085\086\087\088\089\08a\08b\08c\08d\08e\08f\0"
  "90\091\092\093\094\095\096\097\098\099\09a\09b\09c\09d\09e\09f\0"
  "a0\0a1\0a2\0a3\0a4\0a5\0a6\0a7\0a8\0a9\0aa\0ab\0ac\0ad\0ae\0af\0"
  "b0\0b1\0b2\0b3\0b4\0b5\0b6\0b7\0b8\0b9\0ba\0bb\0bc\0bd\0be\0bf\0"
  "c0\0c1\0c2\0c3\0c4\0c5\0c6\0c7\0c8\0c9\0ca\0cb\0cc\0cd\0ce\0cf\0"
  "d0\0d1\0d2\0d3\0d4\0d5\0d6\0d7\0d8\0d9\0da\0db\0dc\0dd\0de\0df\0"
  "e0\0e1\0e2\0e3\0e4\0e5\0e6\0e7\0e8\0e9\0ea\0eb\0ec\0ed\0ee\0ef\0"
  "f0\0f1\0f2\0f3\0f4\0f5\0f6\0f7\0f8\0f9\0fa\0fb\0fc\0fd\0fe\0ff";

  char ct[512] =
  ".\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0"   /* 00 - 0f */
  ".\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0"   /* 10 - 1f */
  " \0!\0\"\0#\0$\0%\0&\0\'\0(\0)\0*\0+\0,\0-\0.\0/\0" /* 20 - 2f */
  "0\0""1\0""2\0""3\0""4\0""5\0""6\0""7\0"             /* 30 - 37 */
                         "8\09\0:\0;\0<\0=\0>\0\?\0"   /* 38 - 3f */
  "@\0A\0B\0C\0D\0E\0F\0G\0H\0I\0J\0K\0L\0M\0N\0O\0"   /* 40 - 4f */
  "P\0Q\0R\0S\0T\0U\0V\0W\0X\0Y\0Z\0[\0\\\0]\0^\0_\0"  /* 50 - 5f */
  "`\0a\0b\0c\0d\0e\0f\0g\0h\0i\0j\0k\0l\0m\0n\0o\0"   /* 60 - 6f */
  "p\0q\0r\0s\0t\0u\0v\0w\0x\0y\0z\0{\0|\0}\0~\0.\0"   /* 70 - 7f */
  ".\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0"   /* 80 - 8f */
  ".\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0"   /* 90 - 9f */
  ".\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0"   /* a0 - af */
  ".\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0"   /* b0 - bf */
  ".\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0"   /* c0 - cf */
  ".\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0"   /* d0 - df */
  ".\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0"   /* e0 - ef */
  ".\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0.\0"   /* f0 - ff */ ;

  gx_insist (p);

  GM_PRINT (1, ("%s at %p - length is %d\n", theComment, p, length));
  for (i = 0; i < length; i+=8)
  {
    sprintf(lblpart, "%p", &(p[i]));
    sprintf(hexpart,
            "%s %s %s %s %s %s %s %s",
            &(ht[3*(p[i])]),   &(ht[3*(p[i+1])]),
            &(ht[3*(p[i+2])]), &(ht[3*(p[i+3])]),
            &(ht[3*(p[i+4])]), &(ht[3*(p[i+5])]),
            &(ht[3*(p[i+6])]), &(ht[3*(p[i+7])]));
    sprintf(chrpart,
            "%s%s%s%s%s%s%s%s",
            &(ct[2*(p[i])]),   &(ct[2*(p[i+1])]),
            &(ct[2*(p[i+2])]), &(ct[2*(p[i+3])]),
            &(ct[2*(p[i+4])]), &(ct[2*(p[i+5])]),
            &(ct[2*(p[i+6])]), &(ct[2*(p[i+7])]));

    if ((i+8) > length)
       for (j = 7; (i+j) >= length; j--) /* put blanks in excess locations */
       {
	  hexpart[j*3]     = ' ';
	  hexpart[j*3 + 1] = ' ';
	  chrpart[j]       = ' ';
       }

    GM_PRINT (1, ("   %s: %s  | %s\n",
                  &(lblpart[strlen(lblpart)-4]), hexpart, chrpart));
  }

  exception: return;
}


void gx_printArp (arpMsg_t *p, int length)
{
  gx_insist (p);
  
  GM_PRINT (1, ("length is %d\n", length));
  _GM_PRINT (1, ("hwtype = %d, protocol_type = %d\n",
		p->hwtype, p->protocol_type));
  _GM_PRINT (1, ("hlen = %d, plen = %d, operation = %d\n",
		p->hlen, p->plen, p->operation));
  _GM_PRINT (1, ("sender_ha = %x.%x.%x.%x.%x.%x\n",
		p->sender_ha[0], p->sender_ha[1], p->sender_ha[2],
		p->sender_ha[3], p->sender_ha[4], p->sender_ha[5]));
  _GM_PRINT (1, ("sender_ip = %d.%d.%d.%d\n",
		p->sender_ip[0], p->sender_ip[1],
                p->sender_ip[2], p->sender_ip[3]));
  _GM_PRINT (1, ("target_ha = %x.%x.%x.%x.%x.%x\n",
		p->target_ha[0], p->target_ha[1], p->target_ha[2],
		p->target_ha[3], p->target_ha[4], p->target_ha[5]));
  _GM_PRINT (1, ("target_ip = %d.%d.%d.%d\n",
		p->target_ip[0], p->target_ip[1],
                p->target_ip[2], p->target_ip[3]));

  if (length != sizeof(arpMsg_t))
    _GM_PRINT (1, ("length SHOULD HAVE BEEN %d\n", sizeof(arpMsg_t)));
  if (p->hlen != 6)
    _GM_PRINT (1, ("hlen SHOULD HAVE BEEN 6\n"));
  if (p->plen != 4)
    _GM_PRINT (1, ("plen SHOULD HAVE BEEN 4\n"));
  if (!((p->operation == 1) || (p->operation == 2)))
    _GM_PRINT (1, ("operation SHOULD HAVE BEEN 1 or 2\n"));

  exception: return;
}

#endif /* GM_IRIX_DISPLAY_MBUF */



#if GM_IRIX_DISPLAY_IFNET
void gx_show_ifnet(struct ifnet *ifnt, char *the_text)
{
     __uint32_t flags_copy;


     GM_PRINT (1, ("ifnet struct at %p, %s ->\n", ifnt, the_text));
     _GM_PRINT (1, ("  if_name  = %s\n",
		    (ifnt->if_name) ? ifnt->if_name : "<nil>"));
     _GM_PRINT (1, ("  unit     = %d\n",   ifnt->if_unit));
     _GM_PRINT (1, ("  flags    = 0x%x\n", ifnt->if_flags));
     flags_copy = ifnt->if_flags;
     GX_DETECT_FLAG(IFF_UP);
     GX_DETECT_FLAG(IFF_BROADCAST);
     GX_DETECT_FLAG(IFF_DEBUG);
     GX_DETECT_FLAG(IFF_LOOPBACK);
     GX_DETECT_FLAG(IFF_POINTOPOINT);
     GX_DETECT_FLAG(IFF_NOTRAILERS);
     GX_DETECT_FLAG(IFF_RUNNING);
     GX_DETECT_FLAG(IFF_NOARP);
     GX_DETECT_FLAG(IFF_PROMISC);
     GX_DETECT_FLAG(IFF_ALLMULTI);
     GX_DETECT_FLAG(IFF_FILTMULTI);
     GX_DETECT_FLAG(IFF_INTELLIGENT);
     GX_DETECT_FLAG(IFF_MULTICAST);
     GX_DETECT_FLAG(IFF_CKSUM);
     GX_DETECT_FLAG(IFF_ALLCAST);
     GX_DETECT_FLAG(IFF_DRVRLOCK);
     GX_DETECT_FLAG(IFF_PRIVATE);
     GX_DETECT_FLAG(IFF_LINK0);
     GX_DETECT_FLAG(IFF_LINK1);
     GX_DETECT_FLAG(IFF_LINK2);
     GX_DETECT_FLAG(IFF_L2IPFRAG);
     GX_DETECT_FLAG(IFF_L2TCPSEG);
     GX_DETECT_FLAG(IFF_IPALIAS);

     if (flags_copy)
        _GM_PRINT (1, ("***UNKNOWN FLAGS 0x%x\n", flags_copy));

     _GM_PRINT (1, ("  if_mtu      = 0x%x\n", ifnt->if_mtu));
     _GM_PRINT (1, ("  if_type     = 0x%x\n", ifnt->if_type));
     _GM_PRINT (1, ("  if_addrlen  = %d\n",   ifnt->if_addrlen));
     _GM_PRINT (1, ("  if_hdrlen   = %d\n",   ifnt->if_hdrlen));
     _GM_PRINT (1, ("  if_ipackets = %d\n",   ifnt->if_ipackets));
     _GM_PRINT (1, ("  if_opackets = %d\n",   ifnt->if_opackets));
     _GM_PRINT (1, ("  if_ierrors  = %d\n",   ifnt->if_ierrors));
     _GM_PRINT (1, ("  if_oerrors  = %d\n",   ifnt->if_oerrors));
     _GM_PRINT (1, ("  if_iqdrops  = %d\n",   ifnt->if_iqdrops));
     _GM_PRINT (1, ("  if_odrops   = %d\n",   ifnt->if_odrops));
     _GM_PRINT (1, ("  if_noproto  = %d\n",   ifnt->if_noproto));
     _GM_PRINT (1, ("<- ifnet struct\n"));
}
#endif


#if GM_IRIX_DISPLAY_ARPCOM
void gx_show_arpcom(struct arpcom *apc, char *the_text)
{
     GM_PRINT (1, ("arpcom struct at %p, fields %s ->\n", apc, the_text));
#if GM_IRIX_DISPLAY_IFNET
     gx_show_ifnet(&(apc->ac_if), "at start of arpcom struct");
#endif
     GM_PRINT (1, ("ac_ipaddr = %x.%x.%x.%x\n",
		   ((char *)(&(apc->ac_ipaddr)))[0],
		   ((char *)(&(apc->ac_ipaddr)))[1],
		   ((char *)(&(apc->ac_ipaddr)))[2],
		   ((char *)(&(apc->ac_ipaddr)))[3]));
     _GM_PRINT (1, ("ac_enaddr = %x.%x.%x.%x.%x.%x\n",
		   apc->ac_enaddr[0],
		   apc->ac_enaddr[1],
		   apc->ac_enaddr[2],
		   apc->ac_enaddr[3],
		   apc->ac_enaddr[4],
		   apc->ac_enaddr[5]));
     _GM_PRINT (1, ("<- arpcom struct\n"));
}
#endif


#if GM_IRIX_DISPLAY_MBUF
void gx_show_mbuf(struct mbuf *m)
{
  char     *typenames[MT_MAX+1] =
  {
    "MT_FREE",		
    "MT_DATA",		
    "MT_HEADER",	
    "MT_SOCKET",	
    "MT_PCB",		
    "MT_RTABLE",
    "MT_HTABLE",	
    "MT_ATABLE",	
    "MT_SONAME",	
    "MT_SAT",		
    "MT_SOOPTS",	
    "MT_FTABLE",	
    "MT_RIGHTS",	
    "MT_IFADDR",		
    "MT_CPI",			
    "MT_CLDATA",		
    "MT_MCAST_RINFO",	
    "MT_IPMOPTS",	
    "MT_MRTABLE",	
    "MT_SOACL",	
#ifndef XTP
    "MT_MAX"		
#else
    "MT_X_CTRL",	
    "MT_X_DIAG",	
    "MT_X_MKPKT",	
    "MT_X_MKPKT_T",	
    "MT_X_OQ",	
    "MT_X_CTXT",	
    "MT_X_NAME",	
    "MT_MAX"	
#endif
  };
  u_char flags_copy;		/* matches the type used in <sys/mbuf.h> */

  GM_PRINT (1, (" m_next         = 0x%p\n", m->m_next) );
  GM_PRINT (1, (" m_off          = 0x%x\n", m->m_off) );
  GM_PRINT (1, (" m_act (nextpkt)= 0x%p\n", m->m_act) );
  GM_PRINT (1, (" m_len          = %d\n",   m->m_len) );
  flags_copy = m->m_flags;
  if (flags_copy == 0)
    GM_PRINT (1, (" m_flags        = <NONE>\n") );
  else
  {
    GM_PRINT (1, (" m_flags        = 0x%x\n", flags_copy) );
    /* printing flags */
    GX_DETECT_FLAG(M_CLUSTER);
    GX_DETECT_FLAG(M_CKSUMMED);
    GX_DETECT_FLAG(M_BCAST);   
    GX_DETECT_FLAG(M_MCAST);
    GX_DETECT_FLAG(M_SHARED);
    GX_DETECT_FLAG(M_LOANED);
    if (flags_copy)
      GM_PRINT (1, ("     UNKNOWN FLAGS 0x%x\n", flags_copy) );
  }
  
  GM_PRINT (1, (" m_type         = %s \n", typenames[m->m_type]) );

  GM_PRINT (1, (" m_length()     = %d\n", m_length(m)) );

  if (m->m_flags & M_CLUSTER)
  {
    GM_PRINT (1, (" mu_size        = %d\n",   m->m_u.m_us.mu_size) );
    GM_PRINT (1, (" m_freefunc     = 0x%p\n", m->m_freefunc) );
    GM_PRINT (1, (" m_farg         = 0x%x\n", m->m_farg) );
    GM_PRINT (1, (" m_dupfunc      = 0x%p\n", m->m_darg) );
  }
}



void gx_printMbuf (struct mbuf *m, char *theComment)
{
  int         np,
              length;
  struct mbuf *t;

  gx_insist (m);

  GM_PRINT (1, ("printing the mbuf at %p %s:\n", m, theComment) );

  np = 0;
  length = 0;

  for (t = m; t; t = t->m_next)
  {
    if (t->m_len == 0)
      continue;

    GM_PRINT (1, ("Piece %d at %p\n", np++, t));
    length+= t->m_len;

    gx_show_mbuf(t);

    gx_printBuf (mtod (t, char*), t->m_len, "mbuf piece");
  }
  GM_PRINT (1, ("total length was %d\n", length));

  exception: return;
}

#endif /* GM_IRIX_DISPLAY_MBUF */



#if GM_IRIX_DISPLAY_QUEUE
GM_STATIC void
gx_display_queue(gx_Queue theQueue, char *theComment)
{
   GM_PRINT (1, ("  %s queue: size = %d,\n", theComment, theQueue.size));
   _GM_PRINT (1, ("    head = 0x%p, tail = 0x%p\n",
	          theQueue.head, theQueue.tail));
}
#endif


#if GM_IRIX_DISPLAY_GXDEVICE
GM_STATIC void
gx_display_gxDevice(gx_Device *theStruct, char *theComment)
{
   GM_PRINT (1, ("Display of gx_Device struct at %p %s:\n",
                theStruct, theComment));
#if GM_IRIX_DISPLAY_ARPCOM
   gx_show_arpcom(&(theStruct->_arpcom), "embedded in gx_Device struct");
#endif
   GM_PRINT (1, ("More gx_Device struct fields:\n"));
   _GM_PRINT (1, ("  vertex  = %d (0x%x)\n",
                theStruct->vertex, theStruct->vertex));
   _GM_PRINT (1, ("  gmPort  = 0x%p\n", theStruct->gmPort));
   if (theStruct->gmPort)
      _GM_PRINT (1, ("     (unit = %d, id = %d)\n",
	           theStruct->gmPort->unit, theStruct->gmPort->id));
   _GM_PRINT (1, ("  address = %x.%x.%x.%x.%x.%x\n",
                theStruct->address[0], theStruct->address[1],
                theStruct->address[2], theStruct->address[3],
                theStruct->address[4], theStruct->address[5]));
   _GM_PRINT (1, ("  name    = %s\n",   theStruct->name));
   _GM_PRINT (1, ("  unit    = %d\n",   theStruct->unit));
   _GM_PRINT (1, ("  flags   = 0x%x\n", theStruct->flags));
   _GM_PRINT (1, ("  forceAlignment = %d (%s)\n",
                theStruct->forceAlignment,
                (theStruct->forceAlignment) ? "True" : "False"));
   _GM_PRINT (1, ("  opened  = %d (%s)\n",
                theStruct->opened, (theStruct->opened) ? "True" : "False"));
#if GM_IRIX_DISPLAY_QUEUE
   gx_display_queue(theStruct->freeSends,       "freeSends"      );
   gx_display_queue(theStruct->freeReceives,    "freeReceives"   );
   gx_display_queue(theStruct->pendingSends,    "pendingSends"   );
   gx_display_queue(theStruct->pendingReceives, "pendingReceives");
#endif
   _GM_PRINT (1, ("<- gx_Device struct\n"));
}

#endif


int gx_isEmpty (gx_Queue*q)
{
  gx_insist (q);
  gx_insist (q->size >= 0);
  gx_insist (q->head && q->size || !q->head && !q->size);
  return !q->head;
  exception: return 0;
}



/* NOTE: This function has an error return but none of the calls test
 *       that return value.  Figure out what to do.  /////
 */
int gx_put (gx_Queue*q, gx_Item*p)
{
  GM_GX_ANNOUNCE_FUNCTION(gx_put)
  gx_insist (q && p);
  gx_insist (q->size >= 0);
  
  p->next = 0;
  if (!q->tail)
  {
    gx_insist (!q->head && q->size == 0);
    q->tail = q->head = p;
  }
  else
  {
    gx_insist (q->head && q->size);
    q->tail->next = p;
    q->tail = p;
  }
  q->size++;
  return 1;
  
  exception: return 0;
}

gx_Item*gx_get (gx_Queue*q)
{
  gx_Item*p;

  GM_GX_ANNOUNCE_FUNCTION(gx_get)
  gx_insist (q);
  gx_insist (q->size >= 0);
  
  if (!q->head)
  {
    gx_insist (!q->tail && q->size == 0);
    return 0;
  }
  p = q->head;
  q->head = q->head->next;
  if (!q->head)
  {
    gx_insist (p == q->tail && q->size == 1);
    q->tail = 0;
  }
  q->size--;
  return p;
  exception: return 0;
}


gx_Item*gx_newItem (gx_Device*d, int size)
{
  gx_Item   *p;
  int       dma_alloc_flags = PCIIO_DMA_DATA | PCIIO_BYTE_STREAM;
  int       dma_alloc_size;

  GM_GX_ANNOUNCE_FUNCTION(gx_newItem)
  gx_insist (d);
  gx_insist (size >= sizeof (struct ifheader));

  if (d->flags & GX_DEV_A64_DMA)
     dma_alloc_flags |= PCIIO_DMA_A64;

  p = (gx_Item*) gm_irix_kmemzalloc (sizeof (gx_Item), KM_NOSLEEP);
  gx_insist (p);

  /* Must be PHYSCONTIG so multiple pages can be addressed from one
   * base DMA address
   */
  p->aa = (char*) gm_irix_kmemalloc (size,
                                   KM_NOSLEEP | KM_PHYSCONTIG | KM_CACHEALIGN);
  gx_insist (p->aa);

  p->va = p->aa + sizeof (struct ifheader);
  dma_alloc_size = (int)(size - sizeof (struct ifheader));

  if (dma_alloc_size <= 0)
  {
     GM_WARN(("gx_newItem called with size %d, too small for data area\n",
              size));
     return 0;
  }

  gx_insist (GX_ALIGNED ((unsigned long)p->va));
  
  p->osize = size;
  p->device = d;

  GM_PRINT ((GM_IRIX_DEBUG_DMAMAPS || GM_IRIX_DEBUG_IP),
            ("calling pciio_dmamap_alloc(%d,<dev-desc>,0x%x,0x%x)\n",
	     d->vertex, dma_alloc_size, dma_alloc_flags));

#if GM_IRIX_DEBUG_MEMLEAKS
   gm_irix_mld_struct.dmamap_alloc_cnt++; /* tally _tries_, not _successes_ */
   gm_irix_mld_struct.ifn_dmamap_alloc_cnt++;
#endif

  p->map = pciio_dmamap_alloc(d->vertex, device_desc_default_get(d->vertex),
                              dma_alloc_size, dma_alloc_flags);
  gx_insist (p->map);

#if GM_IRIX_DEBUG_IP || GM_IRIX_DEBUG_DMAMAPS
/* NOTE:
 *      For the use of kvtophys(), see note at gm_arch.c:gm_irix_dmamap_addr().
 */
  {
     paddr_t   physaddr;
     iopaddr_t dma_addr;

     physaddr = kvtophys(p->va);
     dma_addr = pciio_dmamap_addr (p->map, physaddr, dma_alloc_size);
     p->pa    = (gm_dp_t)dma_addr;
     GM_PRINT (1, ("gx_newItem: kva = %p, phys addr = %p,\n",
                   p->va, physaddr) );
     _GM_PRINT (1, ("    iopaddr = %p, dma addr = %p\n", dma_addr, p->pa) );
  }
#else
  p->pa = (gm_dp_t)pciio_dmamap_addr(p->map, kvtophys (p->va), dma_alloc_size);
#endif

  gx_insist (p->pa);
  p->pgcnt = (unsigned int)(((p->osize)+GM_PAGE_LEN-1) / GM_PAGE_LEN);
#if GM_IRIX_DEBUG_MEMLEAKS
  gm_irix_mld_struct.dma_pg_alloc_cnt += p->pgcnt;
  gm_irix_mld_struct.ifn_dma_pg_alloc_cnt += p->pgcnt;
#endif
  return p;
  
  exception: return 0;
}

void gx_freeItem (gx_Item*p)
{
  GM_GX_ANNOUNCE_FUNCTION(gx_freeItem)
  gx_insist (p);

  if (p->map)
  {
    gx_insist (p->pgcnt == 
	       (unsigned int)(((p->osize)+GM_PAGE_LEN-1) / GM_PAGE_LEN));
       
#if GM_IRIX_DEBUG_MEMLEAKS
    gm_irix_mld_struct.dma_pg_free_cnt += p->pgcnt;
    gm_irix_mld_struct.ifn_dma_pg_free_cnt += p->pgcnt;
#endif
    pciio_dmamap_done (p->map);
    pciio_dmamap_free (p->map);

#if GM_IRIX_DEBUG_MEMLEAKS
    gm_irix_mld_struct.dmamap_free_cnt++;
    gm_irix_mld_struct.ifn_dmamap_free_cnt++;
#endif
  }
  gm_irix_kmemfree (p->aa, p->osize       );
  gm_irix_kmemfree (p,     sizeof(gx_Item));
  
  exception:;
}

gx_Item*gx_newMbufItem (gx_Device*d, gx_Item*p)
{
  GM_GX_ANNOUNCE_FUNCTION(gx_newMbufItem)
  gx_insist (d && p);
  
  MGETHDR (p->m, M_DONTWAIT, MT_DATA);
  gx_insist (p->m);
  
  p->refs = 1;
  p->m = mclgetx (gx_dfun, (long) p, gx_ffun, (long) p, p->va, p->osize, 0);

  gx_insist (p->m && p->m->m_flags & M_CLUSTER);
  
  return p;

  exception: return 0;
}

int gx_feedGm (gx_Device*d)
{
  gx_Item*p;
  gm_ethernet_segment_descriptor_t piece;
  
  GM_GX_ANNOUNCE_FUNCTION(gx_feedGm)
  gx_insist (d && d->opened);

  while (d->pendingReceives.size < GM_NUM_ETHERNET_RECV_TOKENS && (p = gx_get (&d->freeReceives)))
  {
    /*    p = gx_newMbufItem (d, p);*/
    gx_insist (p);
    
    piece.ptr = gm_hton_dp (p->pa);
    piece.len = gm_hton_u32 (p->osize);
    
    gx_put (&d->pendingReceives, p);
    _gm_provide_ethernet_scatter_list (d->gmPort, 1, &piece);
  }
  return 1;
  exception: return 0;
}


void gx_dfun (struct mbuf*m)
{
  gx_Item*p;
 
  GM_GX_ANNOUNCE_FUNCTION(gx_dfun)
  gx_insist (m);
  GM_PRINT (GM_IRIX_DEBUG_IP,
            ("gx_dfun mbuf is %x and m_farg is%x\n", m, m->m_farg));

  p = (gx_Item*) m->m_farg;
  if (!p)
    return;
  
  gx_insist (p->refs >= 0);
  
  p->refs++;
  exception:;
}

void gx_ffun (struct mbuf*m)
{
  gx_Item*p;
 
  GM_GX_ANNOUNCE_FUNCTION(gx_ffun)
  gx_insist (m);

  GM_PRINT (GM_IRIX_DEBUG_IP,
            ("gx_ffun mbuf is %x and m_farg is%x\n", m, m->m_farg));

  p = (gx_Item*) m->m_farg;
  if (!p)
    return;
  
  gx_insist (p && p->device);
  gx_insist (p->m);

  gx_insist (p->refs >= 0);  
  
  if (--p->refs)
    return;
  
  gx_put (&p->device->freeReceives, p);

  /*
  p->m->m_freefunc = 0;
  m_freem (p->m);
  */
  if (p->device->opened)
    gx_feedGm (p->device);

  exception:;
}

gx_Device*gx_newDevice (struct gm_port *thePort)
{
  gx_Device    *d = 0;
  int          i;
  vertex_hdl_t vertex;

  GM_GX_ANNOUNCE_FUNCTION(gx_newDevice)
  gx_insist (thePort);

  vertex = gm_irix_get_vertex (thePort);
  gx_insist (vertex);

  GM_PRINT (GM_IRIX_DEBUG_IP, ("gx_newDevice for vhdl %d\n", vertex));

  d = (gx_Device*) gm_irix_kmemzalloc (sizeof (gx_Device), KM_NOSLEEP);
  gx_insist (d);
  
  d->vertex = vertex;
  d->gmPort = thePort;
  strncpy (d->name, GX_NAME, GX_NAME_LENGTH);  
  d->unit   = thePort->unit;
  d->flags  = 0;
  if (gm_irix_port_use_A64_dma(thePort))
  {
     d->flags |= GX_DEV_A64_DMA;
     GM_PRINT (GM_IRIX_DEBUG_DMAMAPS, ("Using A64 DMA for this device\n"));
  }
  else
     GM_PRINT (GM_IRIX_DEBUG_DMAMAPS, ("Using A32 DMA for this device\n"));

#if GM_EMULATE_BYTE_DMAS
  d->forceAlignment = 0;
#else
  d->forceAlignment = 1;
#endif

/* WARNING: Some of the function calls below may use various
 *          fields in the gx_Device struct 'd', so all such
 *          fields need to have been initialized by now.
 */

  gx_insist (gx_isEmpty (&d->pendingSends));
  gx_insist (gx_isEmpty (&d->pendingReceives));

  for (i = 0; i < GX_NUM_SEND_BUFFERS; i++)
    gx_put (&d->freeSends, gx_newItem (d, GX_BUFFER_SIZE));

  for (i = 0; i < GX_NUM_RECEIVE_BUFFERS; i++)
    gx_put (&d->freeReceives, gx_newItem (d, GX_BUFFER_SIZE));
  
  gx_insist (d->freeReceives.size == GX_NUM_RECEIVE_BUFFERS);
  gx_insist (d->freeSends.size == GX_NUM_SEND_BUFFERS);

  GM_GX_ANNOUNCE_XRETURN(gx_newDevice, d)

  exception: GM_GX_ANNOUNCE_RETURN(gx_newDevice, 0)
}

void gx_freeDevice (gx_Device*d)
{
  gx_Item*p;
  
  GM_GX_ANNOUNCE_FUNCTION(gx_freeDevice)
  gx_insist (gx_isEmpty (&d->pendingSends));
  gx_insist (gx_isEmpty (&d->pendingReceives));

  while (p = gx_get (&d->freeSends))
    gx_freeItem (p);
  
  while (p = gx_get (&d->freeReceives))
    gx_freeItem (p);

  while (p = gx_get (&d->pendingReceives))
    gx_freeItem (p);

  gx_insist (gx_isEmpty (&d->freeSends));
  gx_insist (gx_isEmpty (&d->freeReceives));

  gm_irix_kmemfree (d, sizeof (gx_Device));
  exception:;
}

int gx_detach (int unit)
{
  gx_Device*d;

  GM_GX_ANNOUNCE_FUNCTION(gx_detach)
  gx_insist (unit >= 0 && unit < GX_MAX_DEVICES);
  d = gx_devices[unit];
  gx_insist (d);
  
  gx_freeDevice (d);
  gx_devices[unit] = 0;
  
  return 1;
  exception: return 0;
}

int gx_open (gx_Device*d)
{
  int r;
  
  GM_GX_ANNOUNCE_FUNCTION(gx_open)
  gx_insist (d);
  gx_insist (!d->opened);
  /*gx_insist (d->freeSends.size == GX_NUM_SEND_BUFFERS);*/
  gx_insist (d->freeReceives.size == GX_NUM_RECEIVE_BUFFERS);

  GM_PRINT (GM_IRIX_DEBUG_IP,
            ("gx_open: calling gm_open() for unit %d, port %d\n",
                d->unit, GM_ETHERNET_PORT_ID));
    
  r = gm_open (&d->gmPort, d->unit, GM_ETHERNET_PORT_ID,
               d->name, GM_API_VERSION_1_0);
  gx_insist (r == GM_SUCCESS);

  GM_PRINT (GM_IRIX_DEBUG_IP,
            ("gm_open() called by gx_open() reported success\n"));
  d->opened = 1;
  
  r = gm_get_unique_board_id (d->gmPort, d->address);
  gx_insist (r == GM_SUCCESS);
  GM_PRINT (GM_IRIX_DEBUG_IP, ("Device address is %x.%x.%x.%x.%x.%x\n",
		d->address[0], d->address[1], d->address[2],
                d->address[3], d->address[4], d->address[5]));

  gm_ethernet_set_sent_intr_callback (d->gmPort, gx_sendDone, d);
  gm_ethernet_set_recv_intr_callback (d->gmPort, gx_receiveDone, d);

  gx_feedGm (d);

  ((struct ifnet*) d)->if_flags |= IFF_UP;

  GM_GX_ANNOUNCE_RETURN(gx_open, 1)

  exception: GM_GX_ANNOUNCE_RETURN(gx_open, 0)
}

int gx_attach (int unit)
{
  int            r;
  struct ifnet   *ifp;
  gx_Device      *d;
  struct gm_port *gmPort;
  char           name[GX_NAME_LENGTH];
#ifdef INET6
  char           *inet6not = "IS" ;
#else
  char           *inet6not = "is NOT" ;
#endif

  GM_GX_ANNOUNCE_FUNCTION(gx_attach)
  GM_PRINT (GM_IRIX_DEBUG_IP,
            ("sizeof(gm_ethernet_segment_descriptor_t) = %d\n",
             sizeof(gm_ethernet_segment_descriptor_t)));
  GM_PRINT (GM_IRIX_DEBUG_IP, ("'INET6' %s defined\n", inet6not));
  GM_PRINT (GM_IRIX_DEBUG_IP,
            ("gx_attach: calling gm_open() for unit %d, port %d\n",
                unit, GM_ETHERNET_PORT_ID));

  r = gm_open (&gmPort, unit, GM_ETHERNET_PORT_ID, name, GM_API_VERSION_1_0);
  gx_insist (r == GM_SUCCESS);
  GM_PRINT (GM_IRIX_DEBUG_IP,
            ("gm_open() called by gx_attach() reported success\n"));

  d  = gx_newDevice (gmPort);
  GM_PRINT (GM_IRIX_DEBUG_IP, ("gx_newDevice returned 0x%p\n", d) );
  gx_insist (d);

#if GM_IRIX_DISPLAY_GXDEVICE
  gx_display_gxDevice(d, "just after gx_newDevice");
#endif

#if GM_EMULATE_BYTE_DMAS
  d->forceAlignment = 0;
#else
  d->forceAlignment = 1;
#endif

  gx_insist(d->unit == unit);

  GM_PRINT (GM_IRIX_DEBUG_IP,
            ("gx_attach: calling gm_close() for port %d (unit %d)\n",
                d->gmPort->id, d->gmPort->unit));
  gm_close (d->gmPort);
  d->gmPort = NULL;

  r = gx_open (d);
  gx_insist (r);
  
  ifp = gxtoifp (d);
  
  bcopy (d->address, d->_arpcom.ac_enaddr, 6);
  
  ifp->if_addrlen = 6;
  ifp->if_hdrlen  = sizeof (struct ether_header);
  ifp->if_unit    = d->unit;
  ifp->if_name    = d->name;
  ifp->if_rtrequest = arp_rtrequest;    /* *Mandatory* to use normal ARP */
  ifp->if_mtu     = GM_IP_MTU;
  ifp->if_type    = IFT_ETHER;
  ifp->if_flags   = IFF_NOTRAILERS | IFF_BROADCAST | IFF_LINK0 ;
  ifp->if_rtrequest = arp_rtrequest;    /* *Mandatory* to use normal ARP */
  ifp->if_baudrate.ifs_log2 = 3;	/* L7 SAN == 1.28 Gbit/sec */
  ifp->if_baudrate.ifs_value = 160*1000*1000;

#if USE_NEW_ETHER_INTERFACE
  ifp->if_output   = ether_output;
#else
  ifp->if_output   = gx_if_output;
#endif
  ifp->if_ioctl    = gx_if_ioctl;
  ifp->if_watchdog = gx_if_watchdog;
  ifp->if_reset    = gx_if_reset;
  
  GM_PRINT (GM_IRIX_DEBUG_IP, ("Calling if_attach(0x%p)\n", ifp) );
  if_attach (ifp);

  gx_devices[unit] = d;
  
  ifp->if_snd.ifq_maxlen = 512;
  ifp->if_flags |= IFF_RUNNING;

  r = gx_close (d);
  gx_insist (r);

  GM_GX_ANNOUNCE_RETURN(gx_attach, 1)

  exception:   GM_GX_ANNOUNCE_RETURN(gx_attach, 0)
}

int gx_close (gx_Device*d)
{  
  gx_Item*p;
  
  GM_GX_ANNOUNCE_FUNCTION(gx_close)
  gx_insist (d);
  gx_insist (d->opened);

#if GM_IRIX_DISPLAY_GXDEVICE
  gx_display_gxDevice(d, "at entry to gx_close");
#endif
  
  gm_ethernet_set_sent_intr_callback (d->gmPort, 0, 0);
  gm_ethernet_set_recv_intr_callback (d->gmPort, 0, 0);

  GM_PRINT (GM_IRIX_DEBUG_IP,
            ("gx_close: calling gm_close() for port %d (unit %d)\n",
                d->gmPort->id, d->gmPort->unit));
  gm_close (d->gmPort);
  d->opened = 0;
  d->gmPort = NULL;

  while (p = gx_get (&d->pendingReceives))
    gx_put (&d->freeReceives, p);
  
  while (p = gx_get (&d->pendingSends))
  {
    if (p->m)
    {
      m_freem (p->m);
      p->m = 0; 
    }
    gx_put (&d->freeSends, p);
  }

  ((struct ifnet*) d)->if_flags &= ~IFF_UP;

#if GM_IRIX_DISPLAY_GXDEVICE
  gx_display_gxDevice(d, "at exit from gx_close");
#endif
  
  return 1;

  exception: return 0;
}

int gx_send (gx_Device*d, struct mbuf*m)
{
  struct mbuf   *t;
  gx_Item       *item = 0 ;
  char          *gather;	/* next gather location */
  unsigned char address[6];
  int           numPieces;
  int           aligned,
                broadcast;
  struct ifnet  *ifp = gxtoifp (d);
  gm_ethernet_segment_descriptor_t
                pieces[GM_MAX_ETHERNET_GATHER_CNT];

  GM_GX_ANNOUNCE_FUNCTION(gx_send)
  gx_insist (d && m);

  if (d->pendingSends.size >= GM_NUM_SEND_TOKENS || 
      !(item = gx_get (&d->freeSends)))
  {
    GM_PRINT (1, ("dropping on send (no gx queue space)\n"));
    
    ifp->if_snd.ifq_drops++;
    gx_insist (ifp->if_snd.ifq_len);
    /*    IF_DEQUEUE (&ifp->if_snd, t);

    GM_PRINT (1, ("m is %x and t is %x\n", m, t));
    
    gx_insist (m == t);
    */
    m_freem (m);
    GM_GX_ANNOUNCE_RETURN(gx_send, 0)
  }
  gx_insist (item);
  
  numPieces = item->size = 0;
  aligned = 1;
  
  for (t = m; t; t = t->m_next)
  {
    if (t->m_len == 0)
      continue;
    
    gx_insist (mtod (t, char*));
    
    numPieces++;
    item->size += t->m_len;
    
    aligned = aligned && GX_ALIGNED (mtod (t, unsigned)) && GX_ALIGNED (t->m_len);
  }

  if (item->size > (GM_IP_MTU + sizeof (struct ether_header) + 2))
  {
    ifp->if_oerrors++;
    GM_PRINT (1, ("dropped send message (too big).\n"));

    /*    IF_DEQUEUE (&ifp->if_snd, t);
    gx_insist (m == t);
    */
    ifp->if_snd.ifq_drops++;
    m_freem (m);
    gx_put (&d->freeSends, item);
    GM_GX_ANNOUNCE_RETURN(gx_send, 0)
  } 

  bcopy (mtod (m, unsigned char*), address, 6);
  
  broadcast = address[0] & 0x1;

  GM_PRINT (GM_IRIX_DEBUG_IP, ("dest address is %x.%x.%x.%x.%x.%x\n",
                ((unsigned char)address[0]) & 0xff,
                ((unsigned char)address[1]) & 0xff,
                ((unsigned char)address[2]) & 0xff,
                ((unsigned char)address[3]) & 0xff,
                ((unsigned char)address[4]) & 0xff,
                ((unsigned char)address[5]) & 0xff));

#if GM_IRIX_DISPLAY_MBUF
  gx_printMbuf (m, "in gx_send()");
#endif
  /*  if (numPieces > GM_MAX_ETHERNET_GATHER_CNT || !aligned && d->forceAlignment)*/
  {
    item->m = 0;
       
    
    gather = item->va;
    for (t = m; t; t = t->m_next)
    {
      if (t->m_len == 0)
	continue;      
     
      GM_PRINT (GM_IRIX_DISPLAY_MBUF,
                ("copying section of length %d to %p\n", t->m_len, gather));
      bcopy (mtod (t, char*), gather, t->m_len);
      gather += t->m_len;
    }
    gx_insist (gather ==  item->va + item->size);
    
    pieces[0].ptr = gm_hton_dp (item->pa);
    pieces[0].len = gm_hton_u32 (GX_ROUND_INT (item->size));
    
    numPieces = 1;
    /*    m_freem (m);*/
  }
  /*  else numPieces = gx_dmaLoadPieces (item, m, pieces);*/

  gx_insist (numPieces <= GM_MAX_ETHERNET_GATHER_CNT);
 
  item->m = m;
  gx_put (&d->pendingSends, item);
  gx_insist (d->pendingSends.size <= GM_NUM_SEND_TOKENS);

#if GM_IRIX_DISPLAY_MBUF
  gx_printBuf (item->va, gm_ntoh_u32(pieces[0].len), "The gather");
#endif

  IF_ENQUEUE_NOLOCK(&ifp->if_snd, m);

  if (broadcast)
  {
    GM_PRINT (GM_IRIX_DEBUG_IP,
              ("calling gm_ethernet_broadcast(0x%x, %d, 0x%x, 1)\n",
               d->gmPort, numPieces, pieces));
    gm_ethernet_broadcast (d->gmPort, numPieces, pieces, 1);
  }
  else
  {
       
    GM_PRINT (GM_IRIX_DEBUG_IP,
              ("calling gm_ethernet_send(0x%x, %d,\n", d->gmPort, numPieces));
    _GM_PRINT (GM_IRIX_DEBUG_IP,
               ("    0x%x, 0x%x, 1)\n", pieces, address));
    gm_ethernet_send (d->gmPort, numPieces, pieces, address, 1);
  }

  GM_GX_ANNOUNCE_RETURN(gx_send, 1)

  exception: GM_GX_ANNOUNCE_RETURN(gx_send, 0)

} /* gx_send() */

void gx_sendDone (gx_Device*d)
{
  gx_Item*p;
  struct mbuf*m;
  struct ifnet*ifp = gxtoifp (d);
  
  GM_GX_ANNOUNCE_FUNCTION(gx_sendDone)
  gx_insist (d);

  p = gx_get (&d->pendingSends);
  gx_insist (p);
  gx_insist ((p->size > 0) && (p->size <= (GM_IP_MTU + sizeof (struct ether_header) + 2)));
  gx_insist (p->m);
  
  ifp->if_opackets++;
  ifp->if_obytes += p->size;
  
  if (p->map)
    pciio_dmamap_drain (p->map);
  else
    pciio_dmaaddr_drain (d->vertex, kvtophys (p->va), p->osize);
  
  gx_insist (ifp->if_snd.ifq_len);
  IF_DEQUEUE (&ifp->if_snd, m);

  GM_PRINT (GM_IRIX_DISPLAY_MBUF,
            ("Freeing mbuf; m is %x and p->m is %x\n", m, p->m));
  gx_insist (m == p->m);
  m_freem (p->m);
  
  gx_put (&d->freeSends, p);
  
  GM_PRINT (GM_IRIX_DEBUG_IP, ("Returning from gx_sendDone\n"));
  
  exception: return;
}

void gx_receiveDone (gx_Device*d, unsigned length, gm_u16_t csum)
{
/* //// What should we do with the csum? */
  gx_Item      *p;
  struct ifnet *ifp = gxtoifp (d);
  struct mbuf  *m;
  
  GM_GX_ANNOUNCE_FUNCTION(gx_receiveDone)

  gx_insist (d && ifp);
  gx_insist ((length > 0) &&
             (length <= (GM_IP_MTU + sizeof(struct ether_header) +2)));

  p = gx_get (&d->pendingReceives);
  gx_insist (p);

#if GM_IRIX_DISPLAY_MBUF
  gx_printBuf (p->va, length, "pendingReceive in gx_receiveDone");
#endif

  if (d->pendingReceives.size < GX_MIN_RECEIVE_BUFFERS)
  {
    GM_PRINT (1, ("no receive buffers. Dropping size %d message.\n",
                  d->pendingReceives.size));

    /*p->m->m_farg = 0;
      m_freem (p->m);*/
    gx_put (&d->freeReceives, p);
    gx_feedGm (d);
    ifp->if_snd.ifq_drops++;
  }
  else
  {

    /*  p->m->m_off = (char*)p->aa - (char*)p->m;
    p->m->m_len = length + sizeof (struct ifheader);
    p->m->m_next = 0;
    */
    
    m = m_vget(M_DONTWAIT, length + sizeof (struct ifheader), MT_DATA);

    if (!m)
    {
      GM_PRINT (1, ("dropping on receive (couldn't alloc cluster mbuf\n"));
      gx_put (&d->freeReceives, p);
      gx_feedGm (d);
      ifp->if_snd.ifq_drops++;
    }
    m->m_len = (unsigned short)(length + sizeof (struct ifheader));
    bcopy (p->va, mtod (m, char*) + sizeof (struct ifheader), length);

    gx_put (&d->freeReceives, p);
    gx_feedGm (d);
    
    ifp->if_ipackets++;
    ifp->if_ibytes += length;    
    
#if USE_NEW_ETHER_INTERFACE
/*  Not sure what second parameter ("snoopflags") should be */
    ether_input(&d->_arpcom.ac_if, 0, m);
#else
    gx_input(d, m, m->m_len);
#endif
  }
  
  exception:;
}

int gx_if_ioctl (struct ifnet*ifp, int command, void* data)
{
  gx_Device      *d   = (gx_Device*) ifp;
#if GM_IRIX_DEBUG_IP
  char           *decodedIoctl;
#endif

  GM_GX_ANNOUNCE_FUNCTION(gx_if_ioctl)
  gx_insist (d);

#if GM_IRIX_DEBUG_IP
  decodedIoctl = gx_decodeIoctl(command);
  GM_PRINT (1, ("gx_if_ioctl received ioctl %s (0x%x)\n",
                decodedIoctl, command) );
#endif

  switch (command)
  {
    case SIOCSIFADDR:		/* this is ioctl command code i-12 (0x690c)  */
    {
      struct sockaddr  *our_sockaddr = _IFADDR_SA(data);

      if (our_sockaddr->sa_family == AF_INET)
      {
        d->_arpcom.ac_ipaddr = ((struct sockaddr_in *)our_sockaddr)->sin_addr;
        if (((char*)(&(d->_arpcom.ac_ipaddr)))[0] == 0)
	{
#if HACK_IFADDR
	   GM_WARN (("IP addr of 0 in ioctl SIOCSIFADDR; hacking the addr\n"));
           ((char*)(&(d->_arpcom.ac_ipaddr)))[0] = 199;
           ((char*)(&(d->_arpcom.ac_ipaddr)))[1] = 201;
           ((char*)(&(d->_arpcom.ac_ipaddr)))[2] = 130;
           ((char*)(&(d->_arpcom.ac_ipaddr)))[3] = 131;
#else
	   GM_WARN (("IP addr of 0 in ioctl SIOCSIFADDR\n"));
#endif
	}
        GM_PRINT (GM_IRIX_DISPLAY_ARPCOM,
                  ("Saved %x.%x.%x.%x as _arpcom.ac_ipaddr\n",
                      ((char*)(&(d->_arpcom.ac_ipaddr)))[0],
                      ((char*)(&(d->_arpcom.ac_ipaddr)))[1],
                      ((char*)(&(d->_arpcom.ac_ipaddr)))[2],
	              ((char*)(&(d->_arpcom.ac_ipaddr)))[3]));
      }
      else
      {
	GM_WARN (("Received ioctl SIOCSIFADDR for unsupported sa_family %d\n",
                  our_sockaddr->sa_family));
      }
    }
    break;
  
    case SIOCSIFFLAGS:		/* this is ioctl command code i-122 (0x697a) */
      if (((struct ifreq*)data)->ifr_flags & IFF_UP)
      {
	if (!d->opened)
	  gx_open (d);
      }
      else
      {
	if (d->opened)
	  gx_close (d);
      } 
      break;

    default:
      GM_PRINT (1, ("Unexpected ioctl code 0x%x in gx_if_ioctl()\n",
                    command) );
  }
  exception: GM_GX_ANNOUNCE_RETURN(gx_if_ioctl, 0)
}

#if !USE_NEW_ETHER_INTERFACE
void gx_input (gx_Device*d, struct mbuf*m, int length)
{
  struct gx_Header *h;
  uint             etherType;
#if 0
  struct ifqueue   *ifq;
#endif

  GM_GX_ANNOUNCE_FUNCTION(gx_input)
#if GM_IRIX_DISPLAY_MBUF
  gx_printMbuf (m, "passed to gx_input()");
#endif

  gx_insist (d && m && length <= GM_ETHERNET_MTU);
  h = mtod (m, gx_Header*);

  IF_INITHEADER (h, gxtoifp (d), sizeof (gx_Header));
  
  if (GX_BROADCAST (&h->_ether_header.ether_dhost))
    m->m_flags |= M_BCAST;

  etherType = htons (h->_ether_header.ether_type);

#if GM_IRIX_DISPLAY_MBUF
  GM_PRINT (1, ("etherType is %x\n", etherType));
  
  GM_PRINT (1, ("packet w/out stack header looks like this:\n"));
  if (etherType == ETHERTYPE_ARP)
    gx_printArp ((arpMsg_t *)((char*)h + sizeof (gx_Header)),
                 length - (int)(sizeof (gx_Header)));
  else
    gx_printBuf ((char*)h + sizeof (gx_Header), length - sizeof (gx_Header),
		 "packet without gx_Header");
#endif

  switch (etherType)
  {
    case ETHERTYPE_IP:
      GM_PRINT (GM_IRIX_DISPLAY_IFNET, ("case ETHERTYPE_IP\n"));

      network_input(m, AF_INET, 0);
#if 0
      ifq = &ipintrq;
      
      if (IF_QFULL (ifq))
      {
	(gxtoifp (d))->if_iqdrops++;
	(gxtoifp (d))->if_ierrors++;
	
	GM_PRINT (1, ("\n"));
	_GM_PRINT (1, ("queue full. dropping packet\n"));
	_GM_PRINT (1, ("\n"));
	IF_DROP (ifq);
	m_freem (m);
      }
      IF_ENQUEUE (ifq, m);
#endif
      break;

    case ETHERTYPE_ARP:
      GM_PRINT (GM_IRIX_DISPLAY_IFNET, ("case ETHERTYPE_ARP\n"));
      arpinput ((struct arpcom*)d, m);
      GM_GX_ANNOUNCE_VRETURN(gx_input)

    default:
      GM_PRINT (1, ("UNKNOWN ETHER TYPE %d\n", etherType));
      m_freem (m);
      break;
  }
  exception: GM_GX_ANNOUNCE_VRETURN(gx_input)
}
#endif /* not USE_NEW_ETHER_INTERFACE */


static void gx_if_watchdog (struct ifnet *ifp)
{
  GM_GX_ANNOUNCE_FUNCTION(gx_if_watchdog)
}

static int gx_if_reset (int a, int b)
{
  GM_GX_ANNOUNCE_FUNCTION(gx_if_reset)
  return 0;
}



#if !USE_NEW_ETHER_INTERFACE
/*
 * Transmit packet.  If the destination is this system or
 * broadcast, send the packet to the loop-back device if
 * we cannot hear ourself transmit.  Return 0 or errno.
 */
int gx_if_output (struct ifnet    *ifp, struct mbuf    *m0,
                  struct sockaddr *dst, struct rtentry *rte)
{
  gx_Device           *d = ifptogx(ifp);
  struct ether_header *sh;
  struct mbuf         *m1;
  struct mbuf         *mloop;
  struct sockaddr_sdl *sdl;
#if USE_NEW_ARPRESOLVE
  int                 arp_err;
#endif
#if GM_IRIX_DISPLAY_MBUF
  arpMsg_t            *arpMsg;
#endif

  GM_GX_ANNOUNCE_FUNCTION(gx_if_output)
  GM_PRINT (GM_IRIX_DISPLAY_IFNET, ("ifnet at %p, mbuf at %p,\n", ifp, m0));
  _GM_PRINT (GM_IRIX_DISPLAY_IFNET,
             ("    sockaddr at %p, rtentry at %p\n", dst, rte));

  mloop = NULL;

#if GM_IRIX_DISPLAY_MBUF
  gx_printMbuf (m0, "passed to gx_if_output()");
  arpMsg = (arpMsg_t *)(mtod (m0, char*));
  switch (arpMsg->operation)
  {
    case 1:
    {
       int ix;
       GM_PRINT (1,("Above is ARP request packet with sender_ip %x.%x.%x.%x\n",
		     arpMsg->sender_ip[0],
		     arpMsg->sender_ip[1],
		     arpMsg->sender_ip[2],
		     arpMsg->sender_ip[3]) );
       for (ix=0; ix < 4; ix++)
         if (arpMsg->sender_ip[ix] != 0)
	      break;
       GM_PRINT (1, ("Fixing bad ARP sender IP field\n"));
       arpMsg->sender_ip[0] = 199;
       arpMsg->sender_ip[1] = 201;
       arpMsg->sender_ip[2] = 130;
       arpMsg->sender_ip[3] = 131;
       gx_printMbuf (m0, "after fixing ARP sender field");

       break;
    }

  case 2:
       GM_PRINT (1, ("Above is ARP response\n") );
       break;

  case 3:
       GM_PRINT (1, ("Above is RARP request (***UNEXPECTED***)\n") );
       break;

  case 4:
       GM_PRINT (1, ("Above is RARP response (***UNEXPECTED***)\n") );
       break;

  default:
       GM_PRINT (1, ("Above is not an ARP message\n") );
  }

#endif
  
  /*
   * If snd queue full, try reclaiming some completed
   * mbufs.  If it's still full, then just drop the
   * packet and return ENOBUFS.
   */
  
  if (IF_QFULL(&ifp->if_snd))
  {
    GM_PRINT (1, ("IFQ full. dropping on send\n"));
    
    m_freem(m0);
    ifp->if_odrops++;
    IF_DROP(&ifp->if_snd);
    GM_GX_ANNOUNCE_XRETURN(gx_if_output, ENOBUFS)
   }
  
  switch (dst->sa_family)
  {
    case AF_INET:

      GM_PRINT (GM_IRIX_DISPLAY_IFNET, ("case AF_INET\n"));
      /*
       * Get room for media header,
       * use this mbuf if possible.
       */
      if (!M_HASCL(m0)
	  && m0->m_off >= MMINOFF+sizeof(*sh)
	  && (sh = mtod(m0, struct ether_header*))
	  && ALIGNED(sh, sizeof (int)))
      {
	ASSERT(m0->m_off <= MSIZE);
	m1 = 0;
	--sh;
      } else
      {
	m1 = m_get(M_DONTWAIT, MT_DATA);
	if (m1 == NULL)
	{
	  GM_PRINT (1, ("dropping on send (no mbuf)\n"));
	  
	  m_freem(m0);
	  ifp->if_odrops++;
	  IF_DROP(&ifp->if_snd);
	  
          GM_GX_ANNOUNCE_XRETURN(gx_if_output, ENOBUFS)
	}
	sh = mtod(m1, struct ether_header*);
	m1->m_len = sizeof (*sh);
      }
 
      bcopy(&d->address, &sh->ether_shost, 6);
 
#if GM_IRIX_DISPLAY_ARPCOM
      gx_show_arpcom(&d->_arpcom, "before calling arpresolve()");
#endif

#if USE_NEW_ARPRESOLVE
/* use new arpresolve() protocol */
#if GM_IRIX_DEBUG_IP
      GM_PRINT (1, ("calling arpresolve(0x%p, 0x%p,\n", &d->_arpcom, rte));
      _GM_PRINT (1, ("    0x%p, 0x%p,\n",
                     m0, &((struct sockaddr_in *)dst)->sin_addr));
      _GM_PRINT (1, ("    0x%p, 0x%p)\n",
 		     (u_char*)&sh->ether_dhost, &arp_err));
      _GM_PRINT (1, ("destination ip address is %x.%x.%x.%x\n",
                    ((char*)(&((struct sockaddr_in *)dst)->sin_addr))[0],
                    ((char*)(&((struct sockaddr_in *)dst)->sin_addr))[1],
                    ((char*)(&((struct sockaddr_in *)dst)->sin_addr))[2],
                    ((char*)(&((struct sockaddr_in *)dst)->sin_addr))[3]));
#endif
      /* arpresolve() function documented in email from Carl Becker of SGI
       * dated Jan 13 and Jan 18, 2000.
       */
      if (!arpresolve(
                 &d->_arpcom,	             /* arpcom structure            */
                 rte,		             /* path to routing table entry */
                 m0,	                     /* mbuf to be sent             */
                 &((struct sockaddr_in *)dst)->sin_addr, /* IP destination  */
                 (u_char*)&sh->ether_dhost,  /* Ether dest. to be filled in */
                 &arp_err))                  /* arpresolve return value     */
      {
	if (m1)
	  m_freem(m1);
	GM_PRINT (1, ("dropping on send (arp_err = %d)\n", arp_err));
        GM_GX_ANNOUNCE_RETURN(gx_if_output, 0) /* just wait if not yet resolved */
      }
      else
      {
        GM_PRINT (GM_IRIX_DEBUG_IP,
                   ("arpresolve() returned %d and %x.%x.%x.%x.%x.%x\n",
		       arp_err,
                       sh->ether_dhost[0], sh->ether_dhost[1],
                       sh->ether_dhost[2], sh->ether_dhost[3],
                       sh->ether_dhost[4], sh->ether_dhost[5]));
      }

#else
/* use old ip_arpresolve() protocol */
      /*
       * translate dst IP address to media address.
       */
#if GM_IRIX_DEBUG_IP
      GM_PRINT (1, ("calling ip_arpresolve(0x%p, 0x%p,\n", &d->_arpcom, m0));
      _GM_PRINT (1, ("    0x%p, 0x%p)\n",
		     &((struct sockaddr_in *)dst)->sin_addr,
		     (u_char*)&sh->ether_dhost));
      _GM_PRINT (1, ("destination ip address is %x.%x.%x.%x\n",
                     ((char*)(&((struct sockaddr_in *)dst)->sin_addr))[0],
                     ((char*)(&((struct sockaddr_in *)dst)->sin_addr))[1],
                     ((char*)(&((struct sockaddr_in *)dst)->sin_addr))[2],
                     ((char*)(&((struct sockaddr_in *)dst)->sin_addr))[3]));
#endif
/*    The ip_arpresolve() function is not well-documented.  See
 *    <netinet/if_ether.h> for the few details that we have.
 */
      if (!ip_arpresolve(&d->_arpcom,                /* (struct arpcom *)  */
                         m0,                         /* (struct mbuf *)    */
			 &((struct sockaddr_in *)dst)->sin_addr,
                                                     /* (struct in_addr *) */
			 (u_char*)&sh->ether_dhost)) /* (u_char *)         */
      {
	if (m1)
	  m_freem(m1);
	GM_PRINT (1, ("dropping on send (waiting for arp)\n"));
        GM_GX_ANNOUNCE_RETURN(gx_if_output, 0) /* just wait if unresolved */
      }
 
      GM_PRINT (GM_IRIX_DEBUG_IP,
                ("ip arp resolve results: %x.%x.%x.%x.%x.%x\n",
                    sh->ether_dhost[0], sh->ether_dhost[1],
                    sh->ether_dhost[2], sh->ether_dhost[3],
                    sh->ether_dhost[4], sh->ether_dhost[5]));
#endif /* USE_NEW_ARPRESOLVE */

      if (m1 == 0)
      {
	 m0->m_off -= sizeof (*sh);
	 m0->m_len += sizeof (*sh);
      }
      else
      {
	 m1->m_next = m0;
	 m0 = m1;
      }
 
      sh->ether_type = ETHERTYPE_IP;
      
      /*
       * Listen to ourself, if we are supposed to.
       */
      if (GX_BROADCAST(&sh->ether_shost))
      {
	mloop = m_copy(m0, sizeof (*sh), M_COPYALL);
	if (mloop == NULL)
        {
	  m_freem(m0);
	  ifp->if_odrops++;
	  IF_DROP(&ifp->if_snd);
          GM_GX_ANNOUNCE_XRETURN(gx_if_output, ENOBUFS)
	}
      }
      break;
 
    case AF_UNSPEC:

      GM_PRINT (GM_IRIX_DISPLAY_IFNET,
                 ("case AF_UNSPEC: sending an arp packet\n"));
      _GM_PRINT (GM_IRIX_DISPLAY_IFNET, ("\n"));
      
#define EP      ((struct ether_header *)&dst->sa_data[0])
      /*
       * Translate an ARP packet using RFC-1042.
       * Require the entire ARP packet be in the first mbuf.
       */

      if (EP->ether_type != ETHERTYPE_ARP)
      {
	GM_PRINT (1, ("gx_if_output: bad ARP output\n"));

	m_freem(m0);
	ifp->if_oerrors++;
	IF_DROP(&ifp->if_snd);
        GM_GX_ANNOUNCE_XRETURN(gx_if_output, EAFNOSUPPORT)
      }

      sh = mtod(m0, struct ether_header*);
      if (M_HASCL(m0)
	  ||!ALIGNED(sh, sizeof (int))
	  || m0->m_len < sizeof(struct ether_arp)
	  || m0->m_off < MMINOFF+sizeof(*sh))
      {
	m1 = m_get (M_DONTWAIT, MT_DATA);
	if (!m1)
	{  
	  m_freem(m0);
	  ifp->if_oerrors++;
	  IF_DROP(&ifp->if_snd);
	  GM_PRINT (1, ("dropping on send (mbuf)\n"));

          GM_GX_ANNOUNCE_XRETURN(gx_if_output, ENOBUFS)
	}
	sh = mtod(m1, struct ether_header*);
	m1->m_len = sizeof (*sh);
	m1->m_next = m0;
	m0 = m1;
      }
      else
      {
	ASSERT(m0->m_off <= MSIZE);
	m0->m_len += sizeof(*sh);
	m0->m_off -= sizeof(*sh);
	--sh;
      }
      
      bcopy(&d->address, &sh->ether_shost, 6);
      bcopy(&EP->ether_dhost[0], &sh->ether_dhost, 6);
 
      GM_PRINT (GM_IRIX_DEBUG_IP, ("EP->ether_type is %x\n", EP->ether_type));
      sh->ether_type = EP->ether_type;
#undef EP
      break;
 
    case AF_RAW:
      GM_PRINT (GM_IRIX_DISPLAY_IFNET, ("case AF_RAW\n"));
      /* The mbuf chain contains the raw frame incl header.
       */
      sh = mtod(m0, struct ether_header*);
      if (M_HASCL(m0)
	  || m0->m_len < sizeof(*sh)
	  || !ALIGNED(sh, sizeof (int))) {
	m0 = m_pullup(m0, sizeof (struct ether_header));
	if (m0 == NULL) {
	  ifp->if_odrops++;
	  IF_DROP(&ifp->if_snd);
	  GM_PRINT (1, ("dropping on send (mbuf)\n"));
          GM_GX_ANNOUNCE_XRETURN(gx_if_output, ENOBUFS)
 	};
	sh = mtod(m0, struct ether_header*);
      }
      break;
 
    case AF_SDL:
      GM_PRINT (GM_IRIX_DISPLAY_IFNET, ("case AF_SDL\n"));
      /*
       * Send an 802 packet for DLPI.
       * mbuf chain should already have everything
       * but MAC header.
       */
      sdl = (struct sockaddr_sdl*) dst;
 
      /* sanity check the MAC address */
      if (sdl->ssdl_addr_len != 6) {
	m_freem(m0);
        GM_GX_ANNOUNCE_XRETURN(gx_if_output, EAFNOSUPPORT)
      }
      sh = mtod(m0, struct ether_header*);
      if (!M_HASCL(m0)
	  && m1->m_off >= MMINOFF+sizeof (struct ether_header)
	  && ALIGNED(sh, sizeof(int))) {
	ASSERT(m0->m_off <= MSIZE);
	m0->m_len += sizeof (struct ether_header);
	m0->m_off -= sizeof (struct ether_header);
      } else {
	m1 = m_get(M_DONTWAIT,MT_DATA);
	if (!m1) {
	  m_freem(m0);
	  ifp->if_odrops++;
	  IF_DROP(&ifp->if_snd);
          GM_GX_ANNOUNCE_XRETURN(gx_if_output, ENOBUFS)
	}
	m1->m_len = sizeof (struct ether_header);
	m1->m_next = m0;
	m0 = m1;
	sh = mtod(m0, struct ether_header*);
      }
      sh->ether_type = htons(ETHERTYPE_IP);
      bcopy(&d->address, &sh->ether_shost, 6);
      bcopy(sdl->ssdl_addr, &sh->ether_dhost, 6);
      break;
 
    default:
      GM_PRINT (1, ("sk_output:  bad af %u\n", dst->sa_family));
      m_freem(m0);
      GM_GX_ANNOUNCE_XRETURN(gx_if_output, EAFNOSUPPORT)
  }
 
  /*
   * Save a copy of the mbuf chain to free later.
   */
  
  /*IF_ENQUEUE_NOLOCK(&ifp->if_snd, m0);*/
 
  /*
   * MISSING
   * Allocate and initialize transmit descriptor resources
   * and kick the chip to start DMA reads for transmitting.
   */

  if (gx_send (d, m0))
    ifp->if_opackets++;
  
  exception: GM_GX_ANNOUNCE_RETURN(gx_if_output, 0)
} /* gx_if_output */
#endif
