/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/*
 $Id: gm_arch_io.h,v 1.7 2000/08/15 00:44:14 maxstern Exp $
 */

/*
 * This file contains the declarations and conditional includes
 * specific to IRIX.  It is included by gm_io.h.
 *
 * NOTE: For a Table of Contents of this subdirectory, see README_TOC.
 */

#ifndef _gm_arch_io_h_
#define _gm_arch_io_h_

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_ERRNO_H
#include <sys/errno.h>
#endif


/****************************************
 * Name-related declarations
 ****************************************/

/* The following constant defines a string length great enough to hold
 * a minor device edge name like "gmp99999m99999" or "gmp999m9999999.
 */
#define GM_IRIX_EDGE_NAME_MAX_SZ 14
#define GM_IRIX_MINOR_NAME_MAX_NUMBER 999999999
/* Device open name (convenience vertex) is "/hw/<edgename>" */
#define GM_IRIX_OPEN_NAME_MAX_SZ GM_IRIX_EDGE_NAME_MAX_SZ + 4


/* This typedef declares the arg passed to ioctl for the special
 * GM_SET_PORT_NUM_CALL in IRIX 6.5.
 */
typedef struct
{
   unsigned int port_id;
   int          name_size;
   char         *name;
} gm_irix_set_port_num_arg_t;

#endif /* ifndef _gm_arch_io_h_ */
