/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/*
 $Id: gm_arch.h,v 1.14 2000/11/28 23:03:03 maxstern Exp $
 */

#ifndef _gm_arch_h_
#define _gm_arch_h_

/**********************************************************************
 * This file declares the IRIX-specific macros and inline functions
 * exported to the platform-independent parts of the GM driver, chiefly
 * to gm.c.  The declarations may or may not be referenced by gm_arch.c.
 * See gm_arch_types.h for typedefs used in gm_impl.h.
 * 
 * This driver supports IRIX 6.5 *only*.  The "bible" for IRIX 6.5
 * device driver implementation is "IRIX Device Driver Programmer's
 * Guide," SGI Document Number 007-0911-110.
 *
 * NOTE: For a Table of Contents of this subdirectory, see README_TOC.
 **********************************************************************/

/************************************************************************
 * The following #include's are only those directly needed to support
 * the definitions in this header file.  For more information on this
 * practice, see "README.manifesto" in this subdirectory.
 ************************************************************************/

#include "gm_io.h"         /* needed for GM_MAX_DEVICES  */


				/* Values of flags passed to
                                   dma_region_alloc() to indicate the
                                   type of receive buffer to allocate */
#define GM_ARCH_DMA_READ	0x010
#define GM_ARCH_DMA_WRITE	0x020
#define GM_ARCH_DMA_RDWR	(GM_ARCH_DMA_READ | GM_ARCH_DMA_WRITE)
#define GM_ARCH_DMA_CONSISTENT  0x040
#define GM_ARCH_DMA_STREAMING   0x080
#define GM_ARCH_DMA_CONTIGUOUS	0x100


				/* Return values for gm_intr() to
                                   indicate whether the interrupt was
                                   claimed. */
#define GM_ARCH_INTR_CLAIMED	1
#define GM_ARCH_INTR_UNCLAIMED	2

				/* command passed to gm_arch_dma_region_sync()
                                   to indicate the direction of the sync. */
#define GM_ARCH_SYNC_FOR_DEVICE	0x01
#define GM_ARCH_SYNC_FOR_CPU	0x02

#define GM_SLEEP_WOKE        0
#define GM_SLEEP_TIMED_OUT   1
#define GM_SLEEP_INTERRUPTED 2


/************
 * Debugging output macros
 ************/

/* Function prototypes for diagnostic functions, used in macros below */
void gm_irix_print (char *format, ...);
void gm_irix_info (char *format, ...);
void gm_irix_warn  (char *format, ...);
void gm_irix_panic (char *format, ...);
void gm_irix_note  (char *format, ...);

#define GM_ARCH_PRINT(args) gm_irix_print args
#define GM_ARCH_INFO(args) gm_irix_print args
#define GM_ARCH_WARN(args) gm_irix_print args
#define GM_ARCH_PANIC(args) gm_irix_print args
#define GM_ARCH_NOTE(args) gm_irix_print args


#endif /* _gm_arch_h_ */
