#ifndef _gm_arch_types_h_
#define _gm_arch_types_h_

#include <sys/sem_beta.h>
#ifdef ISR
#undef ISR
#endif

#ifndef __KERNEL__
#define __KERNEL__ 1
#endif

#ifndef NULL
#define NULL ((void *)0)
#endif

#if 0

#define GM_ARCH_KMALLOC_REGION 1
#define GM_ARCH_VMALLOC_REGION 2
#define GM_ARCH_GFP_REGION 3
#define GM_SEND_RING 4
#define GM_RECV_RING 8
#define GM_SEND_RING_MAX_INDEX (GM_SEND_RING -1)
#define GM_RECV_RING_MAX_INDEX (GM_RECV_RING -1)
#define GM_NET_COPY_THRESHOLD 400


#define USER_LOCK_DEAD 0x6598731
#define USER_LOCK_ALIVE 0x635290

#endif

#define GM_SLEEP_WOKE 0
#define GM_SLEEP_INTERRUPTED 1

typedef struct gm_arch_instance_info  
{
  struct isc_table_type*isc;
  uint32_t physical_base_address;
  int unit;
} gm_arch_instance_info_t;

typedef struct gm_arch_dma_region
{
  gm_arch_instance_info_t*ai;
  int length;
  char*iova;
  char*iova_advance;
  char*va;
} gm_arch_dma_region_t;

typedef struct gm_arch_port_info
{
  int nothing;
} gm_arch_port_info_t;

typedef struct gm_arch_sync
{
  struct b_sema semaphore;
} gm_arch_sync_t;

typedef struct gm_arch_page_lock
{
  int nothing;
} gm_arch_page_lock_t;

typedef int gm_arch_minor_t;
typedef int gm_arch_ioctl_context_t;


#endif /* _gm_arch_types_h_ */





