/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_ether_h_
#define _gm_ether_h_

#if !GM_KERNEL
#  error This file can only be used in the kernel.
#endif

#include "gm_internal.h"

GM_ENTRY_POINT void
_gm_provide_ethernet_scatter_list (gm_port_t *p, gm_u32_t segment_cnt,
				   gm_ethernet_segment_descriptor_t segment[]);

void
gm_ethernet_send (gm_port_t *p, gm_u32_t segment_cnt,
		  gm_ethernet_segment_descriptor_t segment[],
		  gm_u8_t *ethernet_addr, int prepend_type);

void
gm_ethernet_broadcast (gm_port_t *p,
		       gm_u32_t segment_cnt,
		       gm_ethernet_segment_descriptor_t segment[],
		       int prepend_type);

void
gm_ethernet_set_recv_intr_callback (gm_port_t *p,
				    void (*callback)(void *, unsigned int, gm_u16_t csum),
				    void *context);

void
gm_ethernet_set_sent_intr_callback (gm_port_t *p,
				    void (*callback)(void *),
				    void *context);

#endif /* _gm_ether_h_ */
