/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_freebsd_h_
#define _gm_freebsd_h_

/**********************************************************************
 * This file architecture-specific marcros and inline functions
 * required by gm.c and gm_arch.c. See gm_arch_types.h for typedefs.
 **********************************************************************/

/************************************************************************
 * Items in this section are not required by gm.c, but needed by the
 * implementations of the functions required by gm.c.
 ************************************************************************/


/* variables to tune */
#define GM_ARCH_MAX_MINOR 256
#define GM_ARCH_MAX_INSTANCE 16

#ifdef __alpha__
#define GM_BC_PAGE_LEN 8192
#elif __intel__
#define GM_BC_PAGE_LEN 4096
#endif


/* others */



extern void *gm_instancep;
extern void *gm_minorp;

extern unsigned gm_control_program_4k_length;
extern unsigned gm_control_program_8k_length;
extern char gm_control_program_4k[];
extern char gm_control_program_8k[];

/* Values of flags passed to
   dma_region_alloc() to indicate the
   type of receive buffer to allocate */

#define GM_ARCH_DMA_READ	0x10
#define GM_ARCH_DMA_WRITE	0x20
#define GM_ARCH_DMA_RDWR	(GM_ARCH_DMA_READ | GM_ARCH_DMA_WRITE)
#define GM_ARCH_DMA_CONSISTENT  0x40
#define GM_ARCH_DMA_STREAMING   0x80
#define GM_ARCH_DMA_CONTIGUOUS  0x100

#define GM_ARCH_INTR_CLAIMED         1
#define GM_ARCH_INTR_UNCLAIMED       2
#define GM_ARCH_SYNC_FOR_DEVICE      3
#define GM_ARCH_SYNC_FOR_CPU         4

/************
 * Debugging output macros
 ************/

#define GM_ARCH_PRINT(args) printf args
#define GM_ARCH_INFO(args) printf args
#define GM_ARCH_NOTE(args) printf args
#define GM_ARCH_WARN(args) printf args
#define GM_ARCH_PANIC(args) printf args

#include "gm_internal.h"
#include "gm_arch_types.h"
#include "gm_impl.h"
#include "gm_lanai.h"


/* PAGE_OFFSET should be the first physical page of memory, that
   should works even if memory does not begin at physical address 0 */
#define MEM_WIN_PCI_OFFSET (gm_virt_to_bus((void*)PAGE_OFFSET))
#define GM_FREEBSD_PAGE_ZERO __pa((void*)PAGE_OFFSET)
#define GM_FREEBSD_HIGH_MEM __pa((void*)high_memory)

#define GM_PHYS_MAP_NR(phys)                                                    \
({                                                                              \
  unsigned long __phys = phys;                                                  \
  gm_assert(__phys >= GM_FREEBSD_PAGE_ZERO && __phys < GM_FREEBSD_HIGH_MEM);      \
  MAP_NR(__va(__phys));                                                         \
})

#if GM_FREEBSD_FULL_MM

struct vm_area_struct *gm_vm_fixup(struct vm_area_struct * vma, 
                                       unsigned long start, unsigned long end);

void gm_freebsd_unreg_page(gm_arch_page_lock_t *lock);
int gm_freebsd_reg_page(gm_arch_page_lock_t *lock,unsigned long addr);
extern int gm_full_mm;
#endif


#ifdef __alpha__
int gm_alpha_init(void);
#endif


#endif /* _gm_freebsd_h_ */
     
