#ifndef _gm_stbar_h_
#define _gm_stbar_h_

/* find out what architecture we are compiling for */

#include "gm_config.h"

/****************************************************************
 * Store synchronization barrier Macro
 ****************************************************************/

/******************
 * lanai
 ******************/

#if defined lanai3 || defined lanai7 || defined lanai

 /* ": : :" for C++ compat. */
#define GM_STBAR() asm volatile ("! GM_STBAR" : : :"memory")
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()

/****************
 * sparc
 ****************/

#elif GM_CPU_sparc || GM_CPU_sparc64
#ifdef __GNUC__
#define GM_STBAR( ) asm ("stbar": : :"memory") /* ": : :" for C++ compat. */
#define GM_READBAR() asm ("membar " "#LoadLoad | #LoadStore" : : : "memory")
#define GM_WRITEBAR() asm ("membar " "#StoreLoad | #StoreStore" : : : "memory")
#elif (defined (__SUNPRO_C) || defined (__SUNPRO_CC)) && defined(__sparcv9)
#define GM_STBAR( ) {}
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()
#elif (defined (__SUNPRO_C) || defined (__SUNPRO_CC)) && defined(__sparc)
#define GM_STBAR( ) {}
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()
#else
#error Do not know how to emit the "stbar" instruction under this compiler.
#endif

/****************
 * x86
 ****************/

#elif GM_CPU_x86
#if defined _MSC_VER
extern void __gm_stbar ();
#define GM_STBAR( ) __gm_stbar ()
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()
#elif defined __GNUC__
#define GM_STBAR()
/* #define GM_READBAR() asm ("lock; addl $0,0(%%esp)": : :"memory") */
#define GM_READBAR() asm ("": : :"memory")
#define GM_WRITEBAR() asm ("": : :"memory")
#elif defined __PGI
#define GM_STBAR()
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()
#else
#define GM_STBAR()
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()
#endif

/****************
 * ia64
 ****************/

#elif GM_CPU_ia64
#if defined _MSC_VER
extern void _gm_stbar (void);
#define GM_STBAR( ) __gm_stbar ()
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()
#elif defined __GNUC__
#define GM_STBAR() asm volatile ("mf": : :"memory") /* ": : :" for C++ */
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()
#else
#error Do not know how to emit the "mf" instruction with this compiler.
#endif

/****************
 * alpha
 ****************/

#elif GM_CPU_alpha
#if defined __GNUC__
#define GM_STBAR()  asm volatile ("mb": : :"memory") /* ": : :" for C++ */
#define GM_READBAR() asm volatile ("mb": : :"memory")
#define GM_WRITEBAR() asm volatile ("wmb": : :"memory")
#elif defined __DECC || defined __DECCXX
#if !GM_KERNEL
#include <c_asm.h>
#define GM_STBAR() asm ("mb")
#define GM_READBAR() asm ("mb")
#define GM_WRITEBAR() asm ("wmb")
#else
#include <sys/types.h>
#define GM_STBAR() mb()
#define GM_READBAR() mb()
#define GM_WRITEBAR() mb()
#endif
#else
#error Do not know how to emit the "mb" instruction with this compiler.
#endif

/****************
 * powerpc
 ****************/

#elif GM_CPU_powerpc
#ifdef __GNUC__
/* can't use -ansi for vxworks ccppc or this will fail with a syntax error */
#define GM_STBAR()  asm volatile ("isync": : :"memory") /* ": : :" for C++ */
#define GM_READBAR() asm volatile ("sync": : :"memory")
#define GM_WRITEBAR() asm volatile ("eieio": : :"memory")
#else
#error Do not know how to emit the "isync" instruction with this compiler.
#endif

/****************
 * mips
 ****************/

#elif GM_CPU_mips
#if GM_KERNEL
void flushbus(void);		/* hack to avoid including <sys/systm.h> */
#define GM_STBAR() flushbus();	/* kernel */
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()
#else
void gm_sync(void);		/* the myricom-provided flushbus() equiv. */
#define GM_STBAR() gm_sync();	/* user */
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()
#endif

/*****************
 * HP-PA RISC 
 *****************/
#elif GM_CPU_hppa
#define GM_STBAR()
#define GM_READBAR() GM_STBAR()
#define GM_WRITEBAR() GM_STBAR()

#endif /* various architectures */

#endif /* _gm_stbar_h_ */

