# file : rc.tcl
#
# this file loads and save the ~/.bwatchrc.tcl resource file
# which contains all user configurable options
#
# we first check if ~/.bWatchrc.tcl exists.  If so than we load i.e.
# source that script.  If ~/.bWatch.tcl does NOT exist than we create 
# one with default options


#--------------------------------------------------------------------
# Procedure saverc
#
#
#
#--------------------------------------------------------------------

proc saverc {} {
    
    global debug display colour freeSwapLimit freeMemLimit cell blank loadLimit
    global listOfHosts bWatchVersion homeDir
    
    # we first open a the file

    set errorCode [catch {set f [open "$homeDir/.bWatchrc.tcl" w+]} \
		       errorMessage]

    if {$errorCode} {
      	.console.messageList insert end \
	    "saverc :: error opening $homeDir/.bWatchrc.tcl."
      	.console.messageList insert end \
	    "saverc :: $errorMessage"
    } else {
	set errorCode [catch {
	    
	    
	    # Now we write our defaults into ~/.bWatchrc.tcl
	    puts $f "set bWatchrcVersion $bWatchVersion"
	    puts $f "set listOfHosts {$listOfHosts}"
	    puts $f ""
	    puts $f "# set the columns which should be displayed"
	    puts $f "#"
	    puts $f "# 1 - information will be displayed for every host"
	    puts $f "# 0 - column will not be shown"
	    puts $f ""
	    
	    
	    puts $f "# number of users on the system"
	    puts $f "set display(numUsers) $display(numUsers)"
	    puts $f ""
	    
	    puts $f "# system time"
	    puts $f "set display(time) $display(time)"
	    puts $f ""
	    
	    puts $f "# 1 minute average load"
	    puts $f "#set display(load1) $display(load1)"
	    puts $f ""
    
	    puts $f "# 5 minutes average load"
	    puts $f "set display(load5) $display(load5)" 
	    puts $f ""
	    
	    puts $f "# 15 minutes average load"
	    puts $f "set display(load15) $display(load15)"
	    puts $f ""
	    
	    puts $f "# number of processes"
	    puts $f "set display(numProcesses) $display(numProcesses)"
	    puts $f ""
	    
	    puts $f "# total RAM"
	    puts $f "set display(totalMemory) $display(totalMemory)"
	    puts $f ""
	    
	    puts $f "# available free RAM"
	    puts $f "set display(freeMemory) $display(freeMemory)"
	    puts $f ""
	    
	    puts $f "# shared RAM"
	    puts $f "set display(sharedMemory) $display(sharedMemory)"
	    puts $f ""
	    
	    puts $f "# buffered memory" 
	    puts $f "set display(buffers) $display(buffers)"
	    puts $f ""
	    
	    puts $f "# cached memory"
	    puts $f "set display(cache) $display(cache)"
	    puts $f ""
	    
	    puts $f "# total swap space"
	    puts $f "set display(totalSwap) $display(totalSwap)"
	    puts $f ""
	    
	    puts $f "# available swap space"
	    puts $f "set display(freeSwap) $display(freeSwap)"    
	    puts $f ""
	    
	    puts $f "# foreground and background coulours"
	    puts $f "# of the heading of the table"
	    puts $f ""
	    
	    puts $f "set colour(headingBG) $colour(headingBG)"
	    puts $f "set colour(headingFG) $colour(headingFG)"
	    puts $f ""
	    
	    puts $f "# foreground and background colours"
	    puts $f "# of the first column showing host names"
	    puts $f ""
	    
	    puts $f "set colour(hostNameBG) $colour(hostNameBG)"
	    puts $f "set colour(hostNameFG) $colour(hostNameFG)"
	    puts $f ""
	    puts $f ""
	    
	    # the system load, memory etc is divided into 5 operating states represented
	    # by different colours :
	    #
	    # idle           - idle state, almost no memory usage (not implemented yet)
	    # neutral        - normal load conditions, CPU crunching away doing normal work
	    # firstWarning   - quite high load, low memory.  Not a major problem
	    # secondWarning  - overloaded, running out of memory.  Should investigate
	    # error          - load very high or running out of swap.  Can cause problems eg
	    #                  processes might start dying 
	    
	    puts $f "set colour(neutralFG) $colour(neutralFG)"
	    puts $f "set colour(firstWarningFG) $colour(firstWarningFG)"
	    puts $f "set colour(secondWarningFG) $colour(secondWarningFG)"
	    puts $f "set colour(errorFG) $colour(errorFG)"
	    puts $f "set colour(errorBG) $colour(errorBG)"
	    puts $f ""
	    puts $f ""
	    
	    # The five different operating states give us information
	    # about the system and how it is performing.
	    # Please modify the numbers to suit your system.
	    # numbers below represent my choice for topcat 
	    
	    # load limits
	    
	    # idle is up to neutral e.g 0.0 - 0.5 (not yet used)
	    #set loadsLimit(neutral)                   0.5
	    
	    puts $f "set loadLimit(firstWarning) $loadLimit(firstWarning)"
	    puts $f "set loadLimit(secondWarning) $loadLimit(secondWarning)"
	    puts $f "set loadLimit(error) $loadLimit(error)"
	    puts $f ""
	    puts $f ""
	    
	    # memory limits in KB
	    #set freeMemLimit(neutral)
	    puts $f "set freeMemLimit(firstWarning) $freeMemLimit(firstWarning)"
	    puts $f "set freeMemLimit(secondWarning) $freeMemLimit(secondWarning)"
	    puts $f "set freeMemLimit(error) $freeMemLimit(error)"
	    puts $f ""
	    puts $f ""
	    
	    # swap limits in KB
	    
	    # give me first warning when 
	    # swap less then 20 MB
	    puts $f "set freeSwapLimit(firstWarning) $freeSwapLimit(firstWarning)"
	    
	    # give me socond warning when
	    # swap less then 10 MB
	    puts $f "set freeSwapLimit(secondWarning) $freeSwapLimit(secondWarning)"
	    
	    # give me third warning when 
	    # swap less then 5 MB
	    puts $f "set freeSwapLimit(error) $freeSwapLimit(error)"
	    puts $f ""
	    puts $f ""
	    
	    # initial display 
	    
	    # what should be displayed when
	    # information cannot be obtained
	    puts $f "set blank $blank"
	    puts $f ""
	    
	    # default width of all the cells
	    puts $f "set cell(width) $cell(width)"
	} errorMessage]
	
	if ${errorCode} {
	    .console.messageList insert end \
		"saverc :: $errorMessage"
	}
	close $f
    }
}


#--------------------------------------------------------------------
# Procedure loadrc
#
#        try loading file ~/.bWatchrc.tcl  If this file does NOT 
#        exist then call procedure saverc which will create this
#        file and save default options  
#
#--------------------------------------------------------------------

proc loadrc {} {
    global debug display colour freeSwapLimit freeMemLimit cell blank loadLimit
    global listOfHosts homeDir

    # we first check if the file exists
    set errorCode [catch {source "$homeDir/.bWatchrc.tcl"} errorMessage]
    if {$errorCode} {
	.console.messageList insert end \
	    "loadrc : $errorMessage"
	.console.messageList insert end \
	    "loadrc : Creating $homeDir/.bWatchrc.tcl ... "
	# save default
	saverc
    } else {
	.console.messageList insert end \
	    "$homeDir/.bWatchrc.tcl loaded."
    }
}











    










