#----------------------------------------------------------------------------
# procedure getUpTime
# 
#        Procedure sends the $command(uptime) to the $host and stores the
#        result in local variable upTime
# 
# Arguments :
#        $host - the name of the host to which $command(uptime) should be
#                send to
#
# Results :
#        Procedure returns either the string which wqas returned by 
#        $command(uptime) or the string "error" if any errors occured
#
#----------------------------------------------------------------------------

proc getUpTime {host} {

    global command

    set errorCode \
	[catch {set upTime [exec $command(rsh) -n \
				$host $command(uptime)]} errorMessage] 
    # check if the command returned an error
    if {$errorCode} {
	set date [getDate]
	.console.messageList insert end \
	    "$date :: getUpTime($host) : $errorMessage"
	return "error"
    } else {
	return $upTime
    }
}



#----------------------------------------------------------------------------
# procedure getMemInfo
# 
# returns the ammount of free memory left on the host
# $host is passed as an argument to this procedure
#----------------------------------------------------------------------------

proc getMemInfo {host} {

    global command bWatchDir

    set errorCode \
	[catch {exec $command(rsh) -n \
		    $host $command(memInfo) > $bWatchDir/bWatchMemInfo } errorMessage] 
    # check if the command returned an error
    if {$errorCode} {
	set date [getDate]
	.console.messageList insert end \
	    "$date :: getMemInfo($host) : $errorMessage"
	return "error"
    } else {
	return
    }
}

#----------------------------------------------------------------------------
# procedure getFreeMemory
# 
# returns the ammount of free memory left on the host
# $host is passed as an argument to this procedure
#----------------------------------------------------------------------------

proc getFreeMemory {host} {

    global command bWatchDir

    set errorCode \
	[catch {set freeMemory \
		    [exec cat $bWatchDir/bWatchMemInfo | grep MemFree]} errorMessage] 
    # check if the command returned an error
    if {$errorCode} {
	set date [getDate]
	.console.messageList insert end \
	    "$date :: getFreeMemory($host) : $errorMessage"
	return "error"
    } else {
	return $freeMemory
    }
}


#----------------------------------------------------------------------------
# procedure getTotalMemory
# 
# returns the ammount of free memory left on the host
# $host is passed as an argument to this procedure
#----------------------------------------------------------------------------

proc getTotalMemory {host} {

    global command bWatchDir

    set errorCode \
	[catch {set totalMemory \
		    [exec cat $bWatchDir/bWatchMemInfo | grep MemTotal]} errorMessage] 
    # check if the command returned an error
    if {$errorCode} {
	set date [getDate]
	.console.messageList insert end \
	    "$date :: getTotalMemory($host) : $errorMessage"
	return "error"
    } else {
	return $totalMemory
    }
}


#----------------------------------------------------------------------------
# procedure getSharedMemory
# 
#----------------------------------------------------------------------------

proc getSharedMemory {host} {

    global command bWatchDir

    set errorCode \
	[catch {set sharedMemory \
		    [exec cat $bWatchDir/bWatchMemInfo | grep MemShared]} errorMessage] 
    # check if the command returned an error
    if {$errorCode} {
	set date [getDate]
	.console.messageList insert end \
	    "$date :: getSharedMemory($host) : $errorMessage"
	return "error"
    } else {
	return $sharedMemory
    }
}


#----------------------------------------------------------------------------
# procedure getBuffers
#----------------------------------------------------------------------------

proc getBuffers {host} {

    global command bWatchDir

    set errorCode \
	[catch {set buffers \
		    [exec cat $bWatchDir/bWatchMemInfo | grep Buffers]} errorMessage] 
    # check if the command returned an error
    if {$errorCode} {
	set date [getDate]
	.console.messageList insert end \
	    "$date :: getBuffers($host) : $errorMessage"
	return "error"
    } else {
	return $buffers
    }
}


#----------------------------------------------------------------------------
# procedure getCache
#----------------------------------------------------------------------------

proc getCache {host} {

    global command bWatchDir

    set errorCode \
	[catch {set cache \
		    [exec cat $bWatchDir/bWatchMemInfo | grep Cached]} errorMessage] 
    # check if the command returned an error
    if {$errorCode} {
	set date [getDate]
	.console.messageList insert end \
	    "$date :: getCache($host) : $errorMessage"
	return "error"
    } else {
	return $cache
    }
}


#----------------------------------------------------------------------------
# procedure getTotalSwap
#----------------------------------------------------------------------------

proc getTotalSwap {host} {

    global command bWatchDir

    set errorCode \
	[catch {set totalSwap \
		    [exec cat $bWatchDir/bWatchMemInfo | grep SwapTotal]} errorMessage] 
    # check if the command returned an error
    if {$errorCode} {
	set date [getDate]
	.console.messageList insert end \
	    "$date :: getTotalSwap($host) : $errorMessage"
	return "error"
    } else {
	return $totalSwap
    }
}


#----------------------------------------------------------------------------
# procedure getFreeSwap
#----------------------------------------------------------------------------

proc getFreeSwap {host} {

    global command bWatchDir

    set errorCode \
	[catch {set freeSwap \
		    [exec cat $bWatchDir/bWatchMemInfo | grep SwapFree]} errorMessage] 
    # check if the command returned an error
    if {$errorCode} {
	set date [getDate]
	.console.messageList insert end \
	    "$date :: getFreeSwap($host) : $errorMessage"
	return "error"
    } else {
	return $freeSwap
    }
}


#----------------------------------------------------------------------------
# procedure getNumberOfProcesses 
#
# returns number of current processes on $host
# $host is this procedures argument
#----------------------------------------------------------------------------

proc getNumberOfProcesses {host} {

    global command

    set errorCode \
	[catch {set numProcesses [exec $command(rsh) -n \
				      $host $command(numberOfProcesses)]} errorMessage]
    # check if the command returned an error
    if {$errorCode} {
	set date [getDate]
	.console.messageList insert end \
	    "$date :: getNumberOfProcesses($host) : $errorMessage"
	return "error"
    } else {
	return $numProcesses
    }
}

