#----------------------------------------------------------------------------
# Now build the screen
#
# main screen layout
# build the frammes where all the widgets will go into

# toolbar frame is reserved for future use.  It will
# hold a toolbar with tool buttons

frame .toolbarFrame

pack .toolbarFrame \
	-side top

# main holds all the labels showing memory, load etc
# for all the hosts

frame .mainFrame 

pack .mainFrame \
    -side top \
    -fill both \
    -expand 1

# button frame is the frame at the bottom of the screen
# which has two buttons at the moment : [refresh] and [exit]

frame .buttonFrame 

pack .buttonFrame \
	-side bottom \
	-fill x

# frame for the top heading for labels explaining
# what each column represents

frame .headingFrame 

pack .headingFrame \
    -in .mainFrame \
    -side top \
    -fill both \
    -expand 1

# build the headings

# name of the host heading 

label .hostnameHeading \
    -text "Host\nName" \
    -bg $colour(headingBG) \
    -fg $colour(headingFG) \
    -relief raised \
    -width $cell(width)

pack .hostnameHeading \
    -in .headingFrame \
    -side left \
    -fill both \
    -expand 1

# number of users heading

if {$display(numUsers)} {
    label .numUsersHeading \
	-text "Num\nUsers" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .numUsersHeading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# system time heading

if {$display(time)} {
    label .timeHeading \
	-text "Time" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .timeHeading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# 1 minute load heading

if {$display(load1)} {
    label .load1Heading \
	-text "1 min\nLoad" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .load1Heading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# build the heading for the 5 minute load column 

if {$display(load5)} {
    label .load5Heading \
	-text "5 min\nLoad" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)

    pack .load5Heading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# build the heading for rhe 15 minute load column

if {$display(load15)} {
    label .load15Heading \
	-text "15 min\nLoad" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .load15Heading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# build the heading for the number of processes column

if {$display(numProcesses)} {
    label .numOfProcessesHeading \
	-text "Num\nprocs." \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .numOfProcessesHeading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# build the heading for the Total Memory column

if {$display(totalMemory)} {
    label .totalMemoryHeading \
	-text "Total\nMem" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)

    pack .totalMemoryHeading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}


# build the heading for the FREE MEMORY column

if  {$display(freeMemory)} {
    label .freeMemoryHeading \
	-text "Free\nMem" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .freeMemoryHeading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# build the heading for the SHARED MEMORY column

if  {$display(sharedMemory)} {
    label .sharedMemoryHeading \
	-text "Shared\nMem" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .sharedMemoryHeading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# build the heading for the BUFFERS column

if  {$display(buffers)} {
    label .buffersHeading \
	-text "Buffers" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .buffersHeading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# build the heading for the CACHE column

if  {$display(cache)} {
    label .cacheHeading \
	-text "Cache" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .cacheHeading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# build the heading for the TOTAL SWAP column

if  {$display(totalSwap)} {
    label .totalSwapHeading \
	-text "Total\nSwap" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .totalSwapHeading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}

# build the heading for the FREE SWAP column

if  {$display(freeSwap)} {
    label .freeSwapHeading \
	-text "Free\nSwap" \
	-bg $colour(headingBG) \
	-fg $colour(headingFG) \
	-relief raised \
	-width $cell(width)
    
    pack .freeSwapHeading \
	-in .headingFrame \
	-side left \
	-fill both \
	-expand 1
}


# build buttons

button .refreshButton \
	-command {refresh} \
	-text "Refresh" 
	
pack .refreshButton \
	-in .buttonFrame \
	-side left \
	-expand 1 \
	-fill x


button .exitButton \
	-command {exit} \
	-text "Exit"

pack .exitButton \
	-in .buttonFrame \
	-side left \
	-expand 1 \
	-fill x


#----------------------------------------------------------------------------
# for each of the hosts in listOfHosts
# create a label in the table
#----------------------------------------------------------------------------

foreach host $listOfHosts {

    # initilize the colours and display

    set time($host)                $blank 
    set numUsers($host)            $blank
    set load1($host)               $blank
    set load5($host)               $blank
    set load15($host)              $blank
    set numProcesses($host)        $blank
    set totalMemory($host)         $blank
    set freeMemory($host)          $blank
    set sharedMemory($host)        $blank
    set buffers($host)             $blank
    set cache($host)               $blank
    set totalSwap($host)           $blank
    set freeSwap($host)            $blank 
    set timeColour($host)          $colour(neutralFG)
    set numUsersColour($host)      $colour(neutralFG)
    set load1Colour($host)         $colour(neutralFG)
    set load5Colour($host)         $colour(neutralFG)
    set load15Colour($host)        $colour(neutralFG)
    set numProcessesColour($host)  $colour(neutralFG)
    set totalMemoryColour($host)   $colour(neutralFG)
    set freeMemoryColour($host)    $colour(neutralFG)
    set sharedMemoryColour($host)  $colour(neutralFG)
    set buffersColour($host)       $colour(neutralFG)
    set cacheColour($host)         $colour(neutralFG)
    set totalSwapColour($host)     $colour(neutralFG)
    set freeSwapColour($host)      $colour(neutralFG)

    # build horisontal frame which will contain all the
    # labels with information for this host

    frame ."$host"Frame

    pack ."$host"Frame \
	    -in .mainFrame \
	    -side top \
	    -fill both \
	    -expand 1

    # host name
    # we always require this !

    label ."$host"HostName \
	-text $host \
	-bg $colour(hostNameBG) \
	-fg $colour(hostNameFG) \
	-width $cell(width) \
	-relief raised
    
    pack ."$host"HostName \
	-side left \
	-in ."$host"Frame \
	-fill both \
	-expand 1

    # number of user
    
    if {$display(numUsers)} {
	label ."$host"numUsers \
	    -textvariable numUsers($host) \
	    -fg $numUsersColour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"numUsers  \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }

    # system time
    
    if {$display(time)} {
	label ."$host"time \
	    -textvariable time($host) \
	    -fg $timeColour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken

	pack ."$host"time  \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }

    # 1 minute load

    if {$display(load1)} {
	label ."$host"load1 \
	    -textvariable load1($host) \
	    -fg $load1Colour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"load1 \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }

    # 5 minute load
	
    if {$display(load5)} {
	label ."$host"load5 \
	    -textvariable load5($host) \
	    -fg $load5Colour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"load5 \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }

    # 15minute load

    if {$display(load15)} {
	label ."$host"load15 \
	    -textvariable load15($host) \
	    -fg $load15Colour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"load15 \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }

    # number of processes

    if {$display(numProcesses)} {
        label ."$host"numProcesses \
	    -textvariable numProcesses($host) \
	    -fg $numProcessesColour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken

	pack ."$host"numProcesses \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }

    # label to show the ammount of free memory on each host    
    
    if {$display(totalMemory)} {
	label ."$host"totalMemory \
	    -textvariable totalMemory($host) \
	    -fg $totalMemoryColour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"totalMemory \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }

    # label to show the ammount of free memory on each host    
    
    if {$display(freeMemory)} {
	label ."$host"freeMemory \
	    -textvariable freeMemory($host) \
	    -fg $freeMemoryColour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"freeMemory \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }
    # label to show the ammount of shared memory on each host    
    
    if {$display(sharedMemory)} {
	label ."$host"sharedMemory \
	    -textvariable sharedMemory($host) \
	    -fg $sharedMemoryColour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"sharedMemory \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }

    # label to show the ammount of buffers on each host    
    
    if {$display(buffers)} {
	label ."$host"buffers \
	    -textvariable buffers($host) \
	    -fg $buffersColour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"buffers \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }

    # label to show the ammount of cache on each host    
    
    if {$display(cache)} {
	label ."$host"cache \
	    -textvariable cache($host) \
	    -fg $cacheColour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"cache \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }

    # label to show the ammount of Total Swap on each host    
    
    if {$display(totalSwap)} {
	label ."$host"totalSwap \
	    -textvariable totalSwap($host) \
	    -fg $totalSwapColour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"totalSwap \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }
    # label to show the ammount of free memory on each host    
    
    if {$display(freeSwap)} {
	label ."$host"freeSwap \
	    -textvariable freeSwap($host) \
	    -fg $freeSwapColour($host) \
	    -width $cell(width) \
	    -justify left \
	    -relief sunken
	
	pack ."$host"freeSwap \
	    -side left \
	    -in ."$host"Frame \
	    -fill both \
	    -expand 1
    }
    update
}

refresh



