#----------------------------------------------------------------------------
# procedure showConsole
#
#      procedure creates a toplevel .console which is the console for bWatch
#      and contains all error messages returned from commands sent to hosts
#
#----------------------------------------------------------------------------

proc showConsole {} {
    toplevel .console
    wm title .console "bWatch Console"

    # main frame which will hold the list box and the scroll bar

    frame .console.mainFrame
    
    pack .console.mainFrame \
	-fill both \
	-expand 1

    # the listbox of error messages

    listbox .console.messageList \
	-yscrollcommand ".console.vScrollBar set" \
	-xscrollcommand ".console.hScrollBar set" \
	-width 50 \
	-height 5 

    pack .console.messageList \
	-in .console.mainFrame \
	-side left \
	-fill both \
	-expand 1

    # Vertical scroll bar

    scrollbar .console.vScrollBar \
	-orient vertical \
	-command ".console.messageList yview"
    
    pack .console.vScrollBar \
	-in .console.mainFrame \
	-side right \
	-fill y 

    # Horisontal scroll bar

    scrollbar .console.hScrollBar \
	-orient horizontal \
	-command ".console.messageList xview"
    
    pack .console.hScrollBar \
	-fill x

    # clear button

    button .console.clearButton \
	-text "Clear" \
	-command {.console.messageList delete 0 1000}

    pack .console.clearButton \
	-fill x 

    return
}


