#ifndef _stats_h_
#define _stats_h_

#include <stdio.h>

struct stats *stats_alloc (void);
void stats_free (struct stats *s);
void stats_clear (struct stats *s);
void stats_append (struct stats *s, double value);
double stats_get_mean (struct stats *s);
double stats_get_max (struct stats *s);
double stats_get_min (struct stats *s);
double stats_get_standard_deviation (struct stats *s);
unsigned int stats_get_count (struct stats *s);
void stats_output_points (FILE *f, const char *mytemplate, struct stats *s);
void stats_scale (struct stats *s, double scale);

int socket_open (char*hostname, int port);
int socket_printf (int fd, char*fmt, ...);
void socket_stats_output_points (int fd, const char *mytemplate, struct stats *s);
void socket_stats_close (int fd);

#ifndef GM_ENABLE_STATS_SOCKET
#define GM_ENABLE_STATS_SOCKET 0
#endif

#endif /* _stats_h_ */
