#!/usr/bin/perl
{
# set up a slave gm_allsize on the destination_node
# gm_allsize --slave --size=20
# then run on the local node
# gmperf.pl <destination_node> [size [local_board [gm_allsize_params]]]


	$desthost = shift(@ARGV) || die "error: gmperf.pl <destination_node> [size [local_board [gm_allsize_params]]]";
	$size = shift(@ARGV) || 20;
	$lboard = shift(@ARGV) || 0;

	$cmd = "gm_debug -L -B $lboard > $desthost.gm_debug";
	print "$cmd\n";
	system "$cmd";

	$cmd = "gm_board_info -B $lboard > $desthost.gm_board_info";
	print "$cmd\n";
	system "$cmd";

	$cmd = "gm_allsize -B $lboard --size=$size -h $desthost -lat -b --geometric -o $desthost.lat.b.gpl @ARGV ";
	print "$cmd\n";
	system "$cmd";

	$cmd = "gm_allsize -B $lboard --size=$size -h $desthost -lat -u --geometric -o $desthost.lat.u.gpl @ARGV ";
	print "$cmd\n";
	system "$cmd";

	$cmd = "gm_allsize -B $lboard --size=$size -h $desthost -bw -b --geometric -o $desthost.bw.b.gpl @ARGV ";
	print "$cmd\n";
	system "$cmd";

	$cmd = "gm_allsize -B $lboard --size=$size -h $desthost -bw -u --geometric -o $desthost.bw.u.gpl @ARGV ";
	print "$cmd\n";
	system "$cmd";

	print "\n\nCompleted GM tests.\n";
}
