/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "gm.h"


#define BUFFER_LEN	(8 * 1024 * 1024)

int
main(int argc, char **argv)
{
	struct gm_port *p;
	gm_u64_t start,stop,middle,total;
	unsigned char *buffer,*startbuffer;
	gm_status_t status;
	unsigned int i;
	int page_len = (int)getpagesize();
	GM_PARAMETER_MAY_BE_UNUSED (argc);
	GM_PARAMETER_MAY_BE_UNUSED (argv);
	
	if (gm_open(&p, 0, 2, "gm_time_reg", GM_API_VERSION_1_0) != GM_SUCCESS) {
		printf("Couldn't open port 'p1' = %d\n",2);
		exit(-1);
	}

	startbuffer = malloc(BUFFER_LEN + 2*page_len);
	if (!startbuffer) {
		printf("Couldn't allocate a buffer\n");
		gm_close(p);
	}

	buffer = (unsigned char *)((((unsigned long)startbuffer)+(page_len-1))& ~(page_len-1));

	printf("Buffer allocated len=%d   start = %p  buffer = %p\n",
		BUFFER_LEN, startbuffer,buffer);
	fflush(stdout);

	start = gm_ticks(p);

	for (i=0; i<BUFFER_LEN; i+=page_len) {
		status = gm_register_memory(p,buffer+i,page_len);
		if (status == GM_SUCCESS) {
			/* OK */
		}
		else {
			printf("Couldn't register memory offset = %d (0x%x)\n",i,i);
			gm_close(p);
			exit(-1);
		}
	}

/*
	printf("Deregistering\n");
	fflush(stdout);
*/
	middle = gm_ticks(p) - start;


	for (i=0; i<BUFFER_LEN; i+=page_len) {
		status = gm_deregister_memory(p,buffer+i,page_len);
		if (status == GM_SUCCESS) {
			/* OK */
		}
		else {
			printf("Couldn't DEregister memory offset = %d (0x%x)\n",i,i);
			gm_close(p);
			exit(-1);
		}
	}

	stop = gm_ticks(p);

	total = stop - start;

	printf("Total time = 0x%x%08x ticks (%8.6f seconds)\n",
		(unsigned int)(total>>32), (unsigned int)(total & 0xFFFFFFFF),
		((float)((unsigned int)total & 0xFFFFFFFF))/2000000.0);

	printf("Reg   time = 0x%x%08x ticks (%8.6f seconds)\n",
		(unsigned int)(middle>>32), (unsigned int)(middle & 0xFFFFFFFF),
		((float)((unsigned int)middle & 0xFFFFFFFF))/2000000.0);

	
	free(startbuffer);
	gm_close(p);
	return 0;
}


/*
  This file uses feldy indentation:

  Local Variables:
  tab-width:4
  c-file-style:"bsd"
  End:
*/
